#!/bin/bash
#: Title      : test_e7evhdr
#: Date       : 2014-09-23
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../e7evhdr$EXT;

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

if [ ! -f ecat7.v ] ; then
  printf "\n Creating test image \n"
  rm -f test.dat
  echo 1 3 6 3 6 3 6 3 6 6 3 6 3 6 3 6 3 3 6 3 6 3 6 3 6 6 3 6 3 6 3 6 3 3 6 3 6 3 6 3 6 6 3 6 3 6 3 6 3 3 6 3 6 3 6 3 6 6 3 6 3 6 3 6 3 > test.dat
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  dft2img -scanner=HR+ -dim=64 -nodecay test.dat plane1.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  rm -f test.dat
  echo 1 6 3 6 3 6 3 6 3 6 6 3 6 3 6 3 6 3 3 6 3 6 3 6 3 6 6 3 6 3 6 3 6 3 3 6 3 6 3 6 3 6 6 3 6 3 6 3 6 3 3 6 3 6 3 6 3 6 6 3 6 3 6 3 6 > test.dat
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  dft2img -scanner=HR+ -dim=64 -nodecay test.dat plane2.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgadd frame1.v plane1.v plane2.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgcalc frame1.v x 1.5 frame2.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  ecatcat frame1.v frame2.v ecat7.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2tif -rb -f=1 ecat7.v ecat7.tif
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "done. \n\n"
fi

if [ ! -f header.ift ] ; then
  printf "\n Creating IFT file \n"
  echo x_pixel_size := 0.5  >  header.ift
  echo y_pixel_size := 0.5  >> header.ift
  echo z_pixel_size := 0.25 >> header.ift
fi


printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n1.0.0 Edit image with header file \n\n"

rm -f edited.v newheader.ift
cp -f ecat7.v edited.v
$PROGRAM edited.v header.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2tif -rb -f=1 edited.v edited.tif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

lshdr edited.v > newheader.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
#cat newheader.ift
iftisval newheader.ift x_pixel_size 0.5
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval newheader.ift y_pixel_size 0.5
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval newheader.ift z_pixel_size 0.25
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

