#!/bin/bash
#: Title      : test_esetstrt
#: Date       : 2014-09-07
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../esetstrt$EXT;

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"

if [ ! -f test.v ] || [ ! -f test.img ]; then
  rm -f temp.dat test?.img test?.v
  echo 1 1 2 3 4 >  temp.dat
  echo 3 2 3 4 5 >> temp.dat
  dft2img -Scanner=HR+ -Dim=8 temp.dat test.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  dft2img -Scanner=Adv -Dim=4 temp.dat test.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n0.1.0 Invalid date or time \n\n"

rm -f stdout.txt
$PROGRAM test.v 2006-31-04 14:55:00 &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid date and time."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


rm -f stdout.txt
$PROGRAM test.v 2006-01-30 14:65:00 &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid date and time."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n===================================================================\n"

printf "\n1.0.0 Set winter time date and time in ECAT 7 \n\n"

cp -f test.v temp.v
rm -f output.ift lmhdr.ift
$PROGRAM temp.v 2006-01-04 14:55:01
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

egetstrt -o=output.ift temp.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift scan_start_time "2006-01-04 14:55:01"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

lmhdr temp.v > lmhdr.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval lmhdr.ift scan_start_time "2006-01-04 14:55:01"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n1.0.1 Set date and time during daylight saving in ECAT 7 \n\n"

cp -f test.v temp.v
rm -f output.ift lmhdr.ift
$PROGRAM temp.v 2006-06-04 14:55:01
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

egetstrt -o=output.ift temp.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift scan_start_time "2006-06-04 14:55:01"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

lmhdr temp.v > lmhdr.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval lmhdr.ift scan_start_time "2006-06-04 14:55:01"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n===================================================================\n"



printf "\n1.1.0 Set winter time date and time in ECAT 6 \n\n"

cp -f test.img temp.img
rm -f output.ift lmhdr.ift
$PROGRAM temp.img 2006-01-04 14:55:01
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

egetstrt -o=output.ift temp.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift scan_start_time "2006-01-04 14:55:01"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

lmhdr temp.img > lmhdr.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval lmhdr.ift scan_start_time "2006-01-04 14:55:01"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n1.1.1 Set date and time during daylight saving in ECAT 6 \n\n"

cp -f test.img temp.img
rm -f output.ift lmhdr.ift
$PROGRAM temp.img 2006-06-04 14:55:01
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

egetstrt -o=output.ift temp.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift scan_start_time "2006-06-04 14:55:01"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

lmhdr temp.img > lmhdr.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval lmhdr.ift scan_start_time "2006-06-04 14:55:01"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n===================================================================\n"

printf "\n1.2.0 Change time with difference in ECAT 6 \n\n"

cp -f test.img temp.img
rm -f output.ift
$PROGRAM temp.img 2006-06-04 14:55:01
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM temp.img 60
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
egetstrt -o=output.ift temp.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift scan_start_time "2006-06-04 15:55:01"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM temp.img -60
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
egetstrt -o=output.ift temp.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift scan_start_time "2006-06-04 14:55:01"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n1.2.1 Change time with difference in ECAT 7 \n\n"

cp -f test.v temp.v
rm -f output.ift
$PROGRAM temp.v 2006-06-04 14:55:01
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM temp.v 60
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
egetstrt -o=output.ift temp.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift scan_start_time "2006-06-04 15:55:01"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM temp.v -60
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
egetstrt -o=output.ift temp.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift scan_start_time "2006-06-04 14:55:01"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

