#!/bin/bash
#: Title      : test_mkcalhdr
#: Date       : 2016-11-18
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../mkcalhdr$EXT;

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n verifying that required data exists \n"

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

if [ ! -f calibrationstudyF18-fore-128.i.hdr ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi


printf "\n making test data \n"


if [ ! -f temp.sif ]; then
  printf "16/11/2016 19:17:21 1 4 1 Test F-18\n" > temp.sif
  printf "0 14398 0 0\n" >> temp.sif
fi

if [ ! -f calibrationstudyF18-fore-128.i ]; then
  simcirc -format=float 128 100 temp.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=hrrt -zoom=1.0 temp.bin petmask.v 1 1 128 128 
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgcalc petmask.v x 0.25 out.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgcalc petmask.v x 5.2828 in.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
#  imgadd temp1.v out.v out.v out.v out.v out.v out.v out.v out.v out.v out.v out.v out.v out.v out.v out.v out.v out.v out.v
  imgadd -x=18 temp1.v out.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
#  imgadd temp2.v in.v in.v in.v in.v in.v in.v in.v in.v in.v in.v in.v in.v in.v in.v in.v in.v in.v in.v in.v in.v
  imgadd -x=171 temp2.v in.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
#  imgadd temp3.v in.v in.v in.v in.v in.v in.v in.v in.v in.v in.v in.v
#  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
#  imgadd temp.v temp1.v temp2.v temp2.v temp2.v temp2.v temp2.v temp2.v temp2.v temp2.v temp3.v temp1.v
  imgadd temp.v temp1.v temp2.v temp1.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  eframe temp.v temp.sif
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  fvar4img -seed=70891428 -i=F-18 temp.v 20.0 noisy.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2tif -rb -s noisy.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2flat noisy.v calibrationstudyF18-fore-128.i
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  rm -f temp*.v in.v out.v temp.bin
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n 1.0.0 \n"
printf " Test case 1: Default settings. \n"
printf " Test case 2: Interfile name given without .i extension. \n"
printf " Expected result: Resulting calibration file contents are close to correct. \n\n"

rm -f calibrationstudyF18_FOREDIFT_i0s0_s9_m128.cal.hdr

$PROGRAM -a=4120 calibrationstudyF18-fore-128
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=2.0e+04 calibrationstudyF18_FOREDIFT_i0s0_s9_m128.cal.hdr "calibration factor" 5.36717e+006
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.001 calibrationstudyF18_FOREDIFT_i0s0_s9_m128.cal.hdr "efficient factor for plane 5" 0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.001 calibrationstudyF18_FOREDIFT_i0s0_s9_m128.cal.hdr "efficient factor for plane 6" 0
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.001 calibrationstudyF18_FOREDIFT_i0s0_s9_m128.cal.hdr "efficient factor for plane 200" 0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.001 calibrationstudyF18_FOREDIFT_i0s0_s9_m128.cal.hdr "efficient factor for plane 199" 0
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.0 \n"
printf " Test case 1: Efficiency plane ranges are set with options. \n"
printf " Test case 2: Interfile name given with .i extension. \n"
printf " Expected result: Resulting calibration file contents are close to correct. \n\n"

rm -f calibrationstudyF18_FOREDIFT_i0s0_s9_m128.cal.hdr

$PROGRAM -a=4120 -l=19 -L=189 calibrationstudyF18-fore-128
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=2.0e+04 calibrationstudyF18_FOREDIFT_i0s0_s9_m128.cal.hdr "calibration factor" 5.36717e+006
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.001 calibrationstudyF18_FOREDIFT_i0s0_s9_m128.cal.hdr "efficient factor for plane 17" 0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.1 calibrationstudyF18_FOREDIFT_i0s0_s9_m128.cal.hdr "efficient factor for plane 18" 1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.001 calibrationstudyF18_FOREDIFT_i0s0_s9_m128.cal.hdr "efficient factor for plane 189" 0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.1 calibrationstudyF18_FOREDIFT_i0s0_s9_m128.cal.hdr "efficient factor for plane 188" 1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n 1.2.0 \n"
printf " Test case: Mean ranges are set with options to planes outside of fantom. \n"
printf " Expected result: Resulting calibration fraction is wrong. \n\n"

rm -f calibrationstudyF18_FOREDIFT_i0s0_s9_m128.cal.hdr

$PROGRAM -a=4120 -m=1 -M=18 calibrationstudyF18-fore-128
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=2.0e+04 calibrationstudyF18_FOREDIFT_i0s0_s9_m128.cal.hdr "calibration factor" 5.36717e+006
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

$PROGRAM -a=4120 -m=189 -M=207 calibrationstudyF18-fore-128
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=2.0e+04 calibrationstudyF18_FOREDIFT_i0s0_s9_m128.cal.hdr "calibration factor" 5.36717e+006
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

#
# Tests with real data are here.
# Not included in the packages because data files would increase 
# package size significantly.
#

cd /p/data/

# MKCALHDR001 (make calibration header for F18 study with OSEM-i01 and check)
echo ________________________________________________________________________
echo MKCALHDR001 
mkcalhdr -s -a 4120 calibrationstudyF18-osem-i01.i > /dev/null
diff calibrationstudyF18-osem-i01.cal.hdr calibrationstudyF18_CPSCC-OSEM3D-OP_i01s16_s9.cal.hdr
if2e7 -s calibrationstudyF18_CPSCC-OSEM3D-OP_i01s16_s9.cal.hdr -o tmp.v calibrationstudyF18-osem-i01.i
echo Info: measured activity concentration at scan start 4,12 kbq/mL
imgpreport -s -p tmp.v  calibrationstudyF18.roi
rm -rf calibrationstudyF18_CPSCC-OSEM3D-OP_i01s16_s9.cal.hdr tmp.v

# MKCALHDR002 (make calibration header for F18 study with FORE/DIFT-128 and check)
echo ________________________________________________________________________
echo MKCALHDR002
mkcalhdr -s -a 4120 calibrationstudyF18-fore-128.i > /dev/null
diff calibrationstudyF18-fore-128.cal.hdr calibrationstudyF18_FOREDIFT_s9_m128.cal.hdr
if2e7 -s calibrationstudyF18_FOREDIFT_s9_m128.cal.hdr -o tmp.v calibrationstudyF18-fore-128.i
echo Info: measured activity concentration at scan start 4,12 kbq/mL
imgpreport -s -p tmp.v  calibrationstudyF18-128.roi
rm -rf calibrationstudyF18_FOREDIFT_s9_m128.cal.hdr tmp.v

# MKCALHDR003 (make calibration header for F18 study with OSEM-i01 and OSEM-i08 and check)
echo ________________________________________________________________________
echo MKCALHDR003
mkcalhdr -s -a 4120 calibrationstudyF18-osem-i01.i calibrationstudyF18-osem-i08.i > /dev/null
diff calibrationstudyF18-osem-i01.cal.hdr calibrationstudyF18_CPSCC-OSEM3D-OP_i01s16_s9.cal.hdr
diff calibrationstudyF18-osem-i08.cal.hdr calibrationstudyF18_CPSCC-OSEM3D-OP_i08s16_s9.cal.hdr
rm -rf calibrationstudyF18_CPSCC-OSEM3D-OP_i01s16_s9.cal.hdr calibrationstudyF18_CPSCC-OSEM3D-OP_i08s16_s9.cal.hdr

# MKCALHDR004 (make calibration header for Ge68 study with OSEM-i08 and check)
echo ________________________________________________________________________
echo MKCALHDR004 
mkcalhdr -s -a 6100 calibrationstudyGe68-osem-i08.i > /dev/null
diff calibrationstudyGe68-osem-i08.cal.hdr calibrationstudyGe68_CPSCC-OSEM3D-OP_i08s16_s9.cal.hdr
if2e7 -s calibrationstudyGe68_CPSCC-OSEM3D-OP_i08s16_s9.cal.hdr -o tmp.v calibrationstudyGe68-osem-i08.i
echo Info: measured activity concentration at scan start 6,10 kbq/mL
imgpreport -s -p tmp.v  calibrationstudyGe68.roi
rm -rf calibrationstudyGe68_CPSCC-OSEM3D-OP_i08s16_s9.cal.hdr tmp.v

cd -
