#!/bin/bash
#: Title      : test_imgfrdif
#: Date       : 2017-08-28
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../imgfrdif$EXT;

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi


if [ ! -f original.tac ] || [ ! -f frdif.tac ] || [ ! -f frdifn.tac ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi


printf "\n making test data \n"

if [ ! -f original.v ]; then
  dft2img -scanner=HR+ -zoom=2 -dim=16 original.tac original.v original.roi
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f frdif.v ]; then
  dft2img -scanner=HR+ -zoom=2 -dim=16 frdif.tac frdif.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f frdifn.v ]; then
  dft2img -scanner=HR+ -zoom=2 -dim=16 frdifn.tac frdifn.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n 1.0.0 \n"
printf " Test case 1: Dynamic image in ECAT 7 format. \n"
printf " Expected result: Output image contains correct results. \n\n"

rm -f output.v output.tac

$PROGRAM original.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.001 frdif.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft output.v original.roi output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=y -yunit=y -abs=0.1 -rel=1 -tacnames=n frdif.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.0 \n"
printf " Test case 1: Option to normalize the differences. \n"
printf " Expected result: Output image contains correct results. \n\n"

rm -f output2.v output2.tac

$PROGRAM -norm original.v output2.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.001 frdifn.v output2.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft output2.v original.roi output2.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=y -yunit=y -abs=0.1 -rel=1 -tacnames=n frdifn.tac output2.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n\n"
printf "=====================================================================\n"
printf "testing for errors\n"
printf "=====================================================================\n"


printf "\n 2.0.0 \n"
printf " Test case 1: Unknown option. \n"
printf " Expected result: Error. \n\n"

rm -f stderr.txt
$PROGRAM -stupidoption original.v output.v &> stderr.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stderr.txt Error "invalid option '-stupidoption'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n"



printf "\n 2.1.0 \n"
printf " Test case 1: Image with just one frame. \n"
printf " Expected result: Error. \n\n"

rm -f stderr.txt

$PROGRAM frdif.v output.v &> stderr.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stderr.txt Error "frdif.v contains only 1 time frame."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n"



printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

