#!/bin/bash
#: Title      : test_imgqntls
#: Date       : 2018-02-25
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../imgqntls$EXT;

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi


printf "\n making test data \n"


if [ ! -f image.dat ] || [ ! -f image.v ]; then
rm -f image.bin image.v dynamic.v
printf "0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9\n"  > image.dat
printf "1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9\n" >> image.dat
printf "2.0 2.1 2.2 2.3 2.4 2.5 2.6 2.7 2.8 2.9\n" >> image.dat
printf "3.0 3.1 3.2 3.3 3.4 3.5 3.6 3.7 3.8 3.9\n" >> image.dat
printf "4.0 4.1 4.2 4.3 4.4 4.5 4.6 4.7 4.8 4.9\n" >> image.dat
printf "5.0 5.1 5.2 5.3 5.4 5.5 5.6 5.7 5.8 5.9\n" >> image.dat
printf "6.0 6.1 6.2 6.3 6.4 6.5 6.6 6.7 6.8 6.9\n" >> image.dat
printf "7.0 7.1 7.2 7.3 7.4 7.5 7.6 7.7 7.8 7.9\n" >> image.dat
printf "8.0 8.1 8.2 8.3 8.4 8.5 8.6 8.7 8.8 8.9\n" >> image.dat
printf "9.0 9.1 9.2 9.3 9.4 9.5 9.6 9.7 9.8 9.9\n" >> image.dat
fi

if [ ! -f image.v ] || [ ! -f image3d.v ] || [ ! -f image3dn.v ] || [ ! -f image3d0.v ] || [ ! -f dynamic.v ]; then
  rm -f dynamic.v
  asc2flat image.dat image.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=HRRT image.bin image.v 1 1 10 10 
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgunit -u=Bq/cc image.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgcalc image.v + 0.1 image1.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgcalc image1.v + 10 image2.v
  imgcalc image1.v + 20 image3.v
  imgcalc image1.v + 30 image4.v
  imgcalc image1.v + 40 image5.v
  imgcalc image1.v + 50 image6.v
  imgcalc image1.v + 60 image7.v
  imgcalc image1.v + 70 image8.v
  imgcalc image1.v + 80 image9.v
  imgcalc image1.v + 90 image10.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgadd image3d.v image1.v image2.v image3.v image4.v image5.v image6.v image7.v image8.v image9.v image10.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  imgcalc image6.v x -1 image6n.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgadd image3dn.v image1.v image2.v image3.v image4.v image5.v image6n.v image7.v image8.v image9.v image10.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  imgcalc image.v x 0 image0.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgadd image3d0.v image0.v image1.v image2.v image3.v image4.v image5.v image6.v image7.v image8.v image9.v image10.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f dynamic.v ]; then
  ecatcat image1.v image2.v image3.v image4.v image5.v image6.v image7.v image8.v image9.v image10.v dynamic.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n 1.0.0 \n"
printf " Test case 1: Static ECAT7 2D image. \n"
printf " Test case 2: Ten groups. \n"
printf " Expected result: Correct quantiles listed. \n\n"

rm -f output.ift
$PROGRAM image.v 10 > output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.01 output.ift quantile[1] 8.95
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.01 output.ift quantile[9] 0.95
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.0.1 \n"
printf " Test case 1: Static ECAT7 3D image. \n"
printf " Test case 2: Ten groups. \n"
printf " Expected result: Correct quantiles listed. \n\n"

rm -f output.ift
$PROGRAM image3d.v 10 > output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.01 output.ift quantile[1] 90.05
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.01 output.ift quantile[9] 10.05
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.1.0 \n"
printf " Test case 1: Static ECAT7 3D image. \n"
printf " Test case 2: Option -pos when all are positive. \n"
printf " Expected result: Correct quantiles listed. \n\n"

rm -f output.ift
$PROGRAM -pos -d3 image3d.v 10 > output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.01 output.ift quantile[1] 90.05
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.01 output.ift quantile[9] 10.05
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.1.1 \n"
printf " Test case 1: Static ECAT7 3D image. \n"
printf " Test case 2: Option -pos when there are zeroes. \n"
printf " Expected result: Correct quantiles listed. \n\n"

rm -f output.ift
$PROGRAM -pos -d3 image3d0.v 10 > output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.01 output.ift quantile[1] 90.05
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.01 output.ift quantile[9] 10.05
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.2.1 \n"
printf " Test case 1: Static ECAT7 3D image with negative pixels. \n"
printf " Test case 2: Option -abs. \n"
printf " Expected result: Correct quantiles listed. \n\n"

rm -f output.ift output2.ift
$PROGRAM -abs image3dn.v 10 > output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.01 output.ift quantile[1] 90.05
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.01 output.ift quantile[9] 10.05
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf " Without option the lowest quantile would be different. \n"
$PROGRAM image3dn.v 10 > output2.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.01 output2.ift quantile[1] 90.05
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.01 output2.ift quantile[9] 10.05
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"





printf "\n===================================================================\n"



printf "\n 2.0.0 \n"
printf " Test case: Invalid option. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt
$PROGRAM -stupidoption image.v 10 &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid option '-stupidoption'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 2.0.1 \n"
printf " Test case: Extra argument. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt
$PROGRAM image.v 10 extra &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid argument 'extra'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 2.0.2 \n"
printf " Test case: Missing argument. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt
$PROGRAM -pos image.v &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 2.1.0 \n"
printf " Test case: Input file does not exist. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt
$PROGRAM nonexistingfile.v 10 &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 2.1.1 \n"
printf " Test case 1: Dynamic ECAT7 image. \n"
printf " Expected result: Error. \n\n"

rm -f output.ift
$PROGRAM dynamic.v 10 > output.ift
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

