#!/bin/bash
#: Title      : test_imgslope
#: Date       : 2019-09-17
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../imgslope$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


#printf "\n verifying that required data exists \n"


printf "\n making test data \n"

if [ ! -f data1.tac ] || [ ! -f data1.v ]; then
  printf "start[minutes]	end[kBq/cc]	roi1	roi2	roi3	roi4\n" > data1.tac
  printf "0.0	2.0	1	12.5	-1	2\n" >> data1.tac
  printf "2.0	4.0	3	3	-3	4\n" >> data1.tac
  printf "4.0	8.0	6	6	-6	7\n" >> data1.tac
  printf "8.0	12.0	10	10	-10	1.8\n" >> data1.tac

  dft2img -zoom=2 -scanner=HRRT -dim=8 data1.tac data1.v data.roi
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f correct_0-12.v ]; then
  printf "start[minutes]	end[kBq/cc]	roi1	roi2	roi3	roi4\n" > temp.tac
  printf "0.0	12.0	1	0	-1	0\n" >> temp.tac

  dft2img -zoom=2 -scanner=HRRT -dim=8 temp.tac correct_0-12.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f correct_0-12noneg.v ]; then
  printf "start[minutes]	end[kBq/cc]	roi1	roi2	roi3	roi4\n" > temp.tac
  printf "0.0	12.0	1	0	0	0\n" >> temp.tac

  dft2img -zoom=2 -scanner=HRRT -dim=8 temp.tac correct_0-12noneg.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f correct_2-8.v ]; then
  printf "start[minutes]	end[kBq/cc]	roi1	roi2	roi3	roi4\n" > temp.tac
  printf "2.0	8.0	1	1	-1	1\n" >> temp.tac

  dft2img -zoom=2 -scanner=HRRT -dim=8 temp.tac correct_2-8.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f correct_median.v ]; then
  printf "start[minutes]	end[kBq/cc]	roi1	roi2	roi3	roi4\n" > temp.tac
  printf "0.0	12.0	1	0.361111	-1	0.48888889\n" >> temp.tac

  dft2img -zoom=2 -scanner=HRRT -dim=8 temp.tac correct_median.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi


printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n 1.0.0 \n"
printf " Test case 1: Dynamic image in ECAT 7 format. \n"
printf " Test case 2: Whole time range. \n"
printf " Expected result: Correct output image. \n\n"

rm -f output.v output.tac

$PROGRAM data1.v 0 12 output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft output.v data.roi output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.001 correct_0-12.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.1 \n"
printf " Test case 1: Dynamic image in ECAT 7 format. \n"
printf " Test case 2: Mid time range. \n"
printf " Expected result: Correct output image. \n\n"

rm -f output.v output.tac

$PROGRAM data1.v 2 8 output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft output.v data.roi output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.001 correct_2-8.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.1.0 \n"
printf " Test case 1: Dynamic image in ECAT 7 format. \n"
printf " Test case 2: Median method. \n"
printf " Expected result: Correct output image. \n\n"

rm -f output.v output.tac

$PROGRAM -median data1.v 0 12 output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft output.v data.roi output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.001 correct_median.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.2.0 \n"
printf " Test case 1: Dynamic image in ECAT 7 format. \n"
printf " Test case 2: Change the sign. \n"
printf " Expected result: Correct output image. \n\n"

rm -f output.v output.tac
imgcalc correct_0-12.v x -1 test.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

$PROGRAM -sign data1.v 0 12 output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft output.v data.roi output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.001 test.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.3.0 \n"
printf " Test case 1: Dynamic image in ECAT 7 format. \n"
printf " Test case 2: Negative values set to zero. \n"
printf " Expected result: Correct output image. \n\n"

rm -f output.v output.tac

$PROGRAM -noneg data1.v 0 12 output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft output.v data.roi output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.001 correct_0-12noneg.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

