#!/bin/bash
#: Title      : test_img2flat
#: Date       : 2018-10-23
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../img2flat$EXT;

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"

# Check that required files exist
if [ ! -f $PROGRAM ]; then
  printf "\nError: application file missing.\n\n"
  exit 1
fi

if [ ! -f original.dat ]; then
  printf "\nError: required file missing.\n\n"
  exit 1
fi
if [ ! -f scan.dat ]; then
  printf "\nError: required file missing.\n\n"
  exit 1
fi
if [ ! -f frame.lst ]; then
  printf "\nError: required file missing.\n\n"
  exit 1
fi

if [ ! -f image2.dat ] || [ ! -f image2.fra ] || [ ! -f image2.inf ]; then
  printf "\nError: required file missing.\n\n"
  exit 1
fi

if [ ! -f correct_flat.inf ]; then
  printf "\nError: required file missing.\n\n"
  exit 1
fi
if [ ! -f correct_flatb.inf ]; then
  printf "\nError: required file missing.\n\n"
  exit 1
fi
if [ ! -f correct_flatf.inf ]; then
  printf "\nError: required file missing.\n\n"
  exit 1
fi
if [ ! -f correct_flatp.inf ]; then
  printf "\nError: required file missing.\n\n"
  exit 1
fi
if [ ! -f correct_flats.inf ]; then
  printf "\nError: required file missing.\n\n"
  exit 1
fi


if [ ! -f original.v ] || [ ! -f original.img ]; then
  printf "\n making original images \n"
  dft2img -zoom=2 -scanner=HRRT -dim=32 original.dat plane1.v original.roi
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgcalc plane1.v x 2 plane2.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgadd original.v plane1.v plane2.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgdecay -i=C-11 original.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  esetstrt original.v 2007-03-06 13:02:23
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2dft -P original.v original.roi original.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  e7to63 original.v original.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf " done. \n\n"
fi


if [ ! -f original.scn ] ; then
  printf "\n making test sinogram data \n"
  asc2flat scan.dat scan.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=931 scan.bin plane1.scn 1 1 29 40
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  esetstrt plane1.scn 2007-03-06 13:02:23
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgcalc plane1.scn x 1.1 plane2.scn
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgadd frame1.scn plane1.scn plane2.scn 
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgcalc frame1.scn x 2 frame2.scn
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgcalc frame1.scn x 3 frame3.scn
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  ecatcat frame1.scn frame2.scn frame3.scn original.scn
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  eframe original.scn frame.lst
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2tif -rb original.scn scan.tif
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf " done. \n\n"
fi

if [ ! -f image2.v ] || [ ! -f image2.img ]; then
  printf "\n making another test image \n"
  asc2flat image2.dat image2.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=HR+ -mif=image2.inf image2.bin image2.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  eframe image2.v image2.fra
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgdecay -i=F-18 image2.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  esetstrt image2.v 2006-06-20 12:01:59
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2tif -rb image2.v image2.tif
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  e7to63 image2.v image2.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf " done. \n\n"
fi

if [ ! -f image2.i ] ; then
  printf "\n making ECAT 7 2D test images \n"
  flat2img -scanner=HR+ -mif=image2.inf image2.bin image2.i
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  eframe image2.i image2.fra
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgdecay -i=F-18 image2.i
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  esetstrt image2.i 2006-06-20 12:01:59
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf " done. \n\n"
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n 0.1.0 fails if no options or argments \n\n"

rm -f stdout.txt
$PROGRAM &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 0.1.1 fails if unknown option \n\n"

rm -f stdout.txt
$PROGRAM -stupidoption original.v flat.bin &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid option '-stupidoption'"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 0.1.2 fails if extra argument \n\n"

rm -f stdout.txt
$PROGRAM original.v flat.bin flat.inf extra &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "too many arguments."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "=====================================================================\n"


printf "\n 1.0.0 option -bins \n\n"

printf "\n without option \n\n"

rm -f stdout.txt
$PROGRAM -d2 original.v flat.bin &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt binNr "0"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n error with image \n\n"

rm -f stdout.txt
$PROGRAM -d2 -bins=20 original.v flat.bin &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "bin nr can be used only with sinograms."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n binNr too large fails \n\n"

rm -f stdout.txt
$PROGRAM -d2 -bins=192 original.scn flat.bin flat.inf &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "bin nr should be smaller than sinogram dimx."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n binNr is ok with ECAT6 2D sinogram \n\n"

rm -f stdout.txt flat.bin flat.inf frame.sif temp.scn
$PROGRAM -bins=19 original.scn flat.bin flat.inf &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch correct_flatb.inf flat.inf
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

flat2img -scanner=931 -bins=29 -mif=flat.inf flat.bin temp.scn
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
eframe original.scn frame.sif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
eframe temp.scn frame.sif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.1 -rel=0.5 temp.scn original.scn
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n-------------------------------------------------------------------\n"


printf "\n 1.1.0 fails if input file name not given \n\n"

rm -f stdout.txt
$PROGRAM flat.bin &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.1.1 fails if non-existing input file \n\n"

rm -f stdout.txt
$PROGRAM nonexisting.v flat.bin &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"
iftisval stdout.txt Error "cannot open file"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.1.2 fails if wrong file format \n\n"

rm -f stdout.txt
$PROGRAM original.dat flat.bin &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n-------------------------------------------------------------------\n"

printf "\n 1.2.0 works with ECAT 7 image volume \n\n"

rm -f stdout.txt flat.bin flat.inf frame.sif temp.v
$PROGRAM -d2 original.v flat.bin flat.inf &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

tacmatch correct_flat.inf flat.inf
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

flat2img -scanner=hrrt -mif=flat.inf flat.bin temp.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
eframe original.v frame.sif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
eframe temp.v frame.sif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.1 -rel=0.5 original.v temp.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.2.1 works with ECAT 7 2D image \n\n"

rm -f stdout.txt flat.bin flat.inf frame.sif temp.v
$PROGRAM -d2 image2.i flat.bin flat.inf &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

flat2img -scanner=hr+ -mif=flat.inf flat.bin temp.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
eframe image2.v frame.sif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
eframe temp.v frame.sif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.1 -rel=0.5 image2.v temp.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.2.2 works with ECAT 6 image \n\n"

rm -f stdout.txt flat.bin flat.inf frame.sif temp.img
$PROGRAM -d2 original.img flat.bin flat.inf &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

flat2img -scanner=hrrt -mif=flat.inf flat.bin temp.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
eframe original.img frame.sif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
eframe temp.img frame.sif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.1 -rel=0.5 original.img temp.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.2.3 works with ECAT 6 sinogram \n\n"

rm -f stdout.txt flat.bin flat.inf frame.sif temp.scn
$PROGRAM -d2 original.scn flat.bin flat.inf &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

flat2img -scanner=931 -mif=flat.inf flat.bin temp.scn
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
eframe original.scn frame.sif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
eframe temp.scn frame.sif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.1 -rel=0.5 original.scn temp.scn
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"

printf "\n 2.0.0 fails if output filename not given \n\n"

rm -f stdout.txt
$PROGRAM -d2 original.v &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.0.1 fail if output filename is the same as input filename \n\n"

rm -f temp.v stdout.txt
cp -f original.v temp.v
$PROGRAM temp.v temp.bin temp.v &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "same name for input and output file."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f temp.v stdout.txt
$PROGRAM temp.v temp.v &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "same name for input and output file."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 2.1.0 existing output files are overwritten \n\n"

rm -f flat.bin flat.inf flat2.inf stdout.txt
$PROGRAM -d2 original.v   flat.bin flat.inf &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
rm -f stdout.txt
$PROGRAM -d2 original.scn flat.bin flat.inf &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

rm -f frame.sif
flat2img -scanner=931 -mif=flat.inf flat.bin temp.scn
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
eframe original.scn frame.sif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
eframe temp.scn frame.sif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.1 -rel=0.5 original.scn temp.scn
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.2.0 Matrix information file not given; ok \n\n"

rm -f stdout.txt flat.bin flat.inf
$PROGRAM -d2 original.v flat.bin &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "miffile" ""
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 2.2.1 Matrix information file given as option and argument \n\n"

printf "\n argument overwrites option \n\n"

rm -f stdout.txt flat.bin flat.inf
$PROGRAM -d2 -inf=flat.inf original.v flat.bin flat.mif &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "miffile" "flat.mif"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"

printf "\n 3.0.0 Only one plane \n\n"

rm -f stdout.txt flat.bin flat.inf frame.sif temp.img oneplane.img
esplit original.img 1-3 2 oneplane.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM -d2 oneplane.img flat.bin flat.inf &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch correct_flatp.inf flat.inf
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

flat2img -scanner=hrrt -mif=flat.inf flat.bin temp.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
eframe oneplane.img frame.sif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
eframe temp.img frame.sif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -planes=n -abs=0.1 -rel=0.5 oneplane.img temp.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 3.1.0 Only one frame \n\n"

rm -f stdout.txt flat.bin flat.inf frame.sif temp.img oneframe.img
esplit original.img 2 1-2 oneframe.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM -d2 oneframe.img flat.bin flat.inf &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch correct_flatf.inf flat.inf
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

flat2img -scanner=hrrt -mif=flat.inf flat.bin temp.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
eframe oneframe.img frame.sif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
eframe temp.img frame.sif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -planes=n -abs=0.1 -rel=0.5 oneframe.img temp.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

