#!/bin/bash
#: Title      : test_imgcat
#: Date       : 2018-10-24
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../imgcat$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n verifying that required data exists \n"



printf "\n making test data \n"


if [ ! -f temp1.sif ]; then
  printf "18/11/2016 18:12:09 1 4 1 Test F-18\n" > temp1.sif
  printf "0 10 0 0\n" >> temp1.sif
fi
if [ ! -f temp2.sif ]; then
  printf "18/11/2016 18:12:09 4 4 1 Test O-15\n" > temp2.sif
  printf " 10  20 0 0\n" >> temp2.sif
  printf " 20  60 0 0\n" >> temp2.sif
  printf " 60 120 0 0\n" >> temp2.sif
  printf "120 240 0 0\n" >> temp2.sif
fi
if [ ! -f temp3.sif ]; then
  printf "18/11/2016 18:12:09 2 4 1 Test F-18\n" > temp3.sif
  printf "240 480 0 0\n" >> temp3.sif
  printf "480 720 0 0\n" >> temp3.sif
fi
if [ ! -f seven.sif ]; then
  printf "18/11/2016 18:12:09 7 4 1 Test F-18\n" > seven.sif
  printf "  0  10 0 0\n" >> seven.sif
  printf " 10  20 0 0\n" >> seven.sif
  printf " 20  60 0 0\n" >> seven.sif
  printf " 60 120 0 0\n" >> seven.sif
  printf "120 240 0 0\n" >> seven.sif
  printf "240 480 0 0\n" >> seven.sif
  printf "480 720 0 0\n" >> seven.sif
fi


if [ ! -f mask.dat ] || [ ! -f mask.v ]; then
  rm -f mask.bin mask.v
  printf "0 1 1 0\n"  > mask.dat
  printf "2 2 2 1\n" >> mask.dat
  printf "0 2 2 3\n" >> mask.dat
  printf "0 1 2 3\n" >> mask.dat

  printf "0 2 1 0\n" >> mask.dat
  printf "2 3 3 1\n" >> mask.dat
  printf "0 2 3 3\n" >> mask.dat
  printf "0 2 3 3\n" >> mask.dat

  printf "0 1 0 0\n" >> mask.dat
  printf "1 2 2 1\n" >> mask.dat
  printf "0 1 2 2\n" >> mask.dat
  printf "0 1 2 1\n" >> mask.dat

fi

if [ ! -f mask.bin ] || [ ! -f mask.v ]; then
  asc2flat mask.dat mask.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=HRRT mask.bin mask.v 3 1 4 4
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  eframe mask.v temp1.sif
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2tif -rb -s mask.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n 1.0.0 \n"
printf " Test case 1: Catenate 3D image with itself to get image with two frames. \n"
printf " Test case 2: ECAT 7 format. \n"
printf " Expected result: Result image has two frames. \n\n"

rm -f output.v output.dat
printf "4 4 3 2\n" > correct.dat

$PROGRAM output.v mask.v mask.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgdim output.v > output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch correct.dat output.dat 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

eframe output.v temp3.sif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.1 \n"
printf " Test case 1: Catenate the output image with itself again. \n"
printf " Expected result: Result image has four frames. \n\n"

rm -f output2.v output.dat
printf "4 4 3 4\n" > correct.dat

$PROGRAM output2.v output.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgdim output2.v > output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch correct.dat output.dat 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

eframe output2.v temp2.sif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.0.2 \n"
printf " Test case 1: Catenate the three previous images. \n"
printf " Expected result 1: Result image has seven frames. \n"
printf " Expected result 2: Frame times have been correctly copied. \n\n"

rm -f output3.v output.sif

$PROGRAM output3.v mask.v output2.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
eframe output3.v output.sif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch seven.sif output.sif 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n 1.1.0 \n"
printf " Test case: Catenate three images in NIfTI format. \n"
printf " Expected result: Correct result image is written. \n\n"

rm -f nii/*.nii nii/*.sif
ecat2nii -o=nii mask.v output.v output2.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
cp -f temp1.sif nii/mask.sif
cp -f temp2.sif nii/output2.sif
cp -f temp3.sif nii/output.sif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"


$PROGRAM nii/output3 nii/mask nii/output2 nii/output
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=n seven.sif nii/output3.sif 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"










printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

