#!/bin/bash
#: Title      : test_imgmove
#: Date       : 2018-03-12
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../imgmove$EXT;

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


# printf "\n verifying that required data exists \n"


printf "\n making test data \n"

if [ ! -f tissue.tac ]; then
  rm -f plane1.v orig.roi orig.v
  printf "start[minutes]	end[kBq/cc]	roi1	roi2	roi3	roi4\n" > tissue.tac
  printf "0.0	1.0	0.0e+000	1.0e+000	2.0e+000	3.0e+000\n" >> tissue.tac
  printf "1.0	2.0	1.0e+002	2.0e+002	3.0e+002	4.0e+002\n" >> tissue.tac
  printf "2.0	4.0	5.0e+001	1.0e+002	1.5e+002	2.0e+002\n" >> tissue.tac
  printf "# studynr := exam0001\n" >> tissue.tac
fi

if [ ! -f orig.v ] || [ ! -f orig.roi ]; then
  dft2img -zoom=2 -scanner=Adv -dim=8 tissue.tac plane1.v orig.roi
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgcalc plane1.v x 2 plane2.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  rm -f orig.v
  imgadd orig.v plane1.v plane2.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2dft -p orig.v orig.roi orig.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2tif -rb orig.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f correct_move.tac ]; then
  printf "start[minutes]	end[kBq/cc]	roi1__Pl001	roi1__Pl002	roi2__Pl001	roi2__Pl002	roi3__Pl001	roi3__Pl002	roi4__Pl001	roi4__Pl002\n" > correct_move.tac
  printf "0.0	1.0	0.0000e+000	0.0000e+000	5.0000e-001	1.0000e+000	1.0000e+000	2.0000e+000	2.5	5.0\n" >> correct_move.tac
  printf "1.0	2.0	3.0000e+002	6.0000e+002	4.0000e+002	8.0000e+002	0.0000e+000	0.0000e+000	0.0	0.0\n" >> correct_move.tac
  printf "2.0	4.0	0.0000e+000	0.0000e+000	0.0000e+000	0.0000e+000	1.0000e+002	2.0000e+002	0.0	0.0\n" >> correct_move.tac
  printf "# studynr := exam0001\n" >> correct_move.tac
fi


if [ ! -f mask.dat ] || [ ! -f mask.v ]; then
rm -f mask.bin mask.v
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0\n"  > mask.dat
printf "0 2 2 2 2 2 2 2 2 2 2 2 2 1 2 0\n" >> mask.dat
printf "0 2 1 1 1 1 1 1 1 1 1 1 1 1 2 0\n" >> mask.dat
printf "0 2 1 2 2 2 2 2 2 2 2 0 2 0 2 0\n" >> mask.dat
printf "0 2 1 2 0 0 0 0 0 0 0 0 2 0 2 0\n" >> mask.dat
printf "0 2 0 2 2 2 2 2 0 2 2 2 2 0 2 0\n" >> mask.dat
printf "0 2 0 0 0 0 0 2 0 2 0 0 2 0 2 0\n" >> mask.dat
printf "0 2 0 2 2 0 2 0 0 0 0 2 2 0 2 0\n" >> mask.dat
printf "0 2 0 0 2 0 2 2 2 2 2 2 0 0 2 0\n" >> mask.dat
printf "0 2 2 0 2 0 0 0 2 0 0 0 0 2 2 0\n" >> mask.dat
printf "0 2 0 0 2 2 2 0 2 0 2 2 0 0 2 0\n" >> mask.dat
printf "0 2 0 2 2 0 0 0 2 0 0 0 0 2 2 0\n" >> mask.dat
printf "0 2 0 0 2 2 2 2 2 2 2 2 0 0 2 0\n" >> mask.dat
printf "0 2 2 0 0 0 0 0 0 0 0 2 2 2 2 0\n" >> mask.dat
printf "0 2 2 2 2 2 2 2 2 2 0 2 2 2 2 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
fi

if [ ! -f mask.bin ] || [ ! -f mask.v ]; then
  asc2flat mask.dat mask.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=HRRT mask.bin mask.v 1 1 16 16
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f correct_moved_mask1.v ] || [ ! -f mask1.dat ]; then
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0\n"  > mask1.dat
printf "0 0 2 2 2 2 2 2 2 2 2 2 2 2 1 2\n" >> mask1.dat
printf "0 0 2 1 1 1 1 1 1 1 1 1 1 1 1 2\n" >> mask1.dat
printf "0 0 2 1 2 2 2 2 2 2 2 2 0 2 0 2\n" >> mask1.dat
printf "0 0 2 1 2 0 0 0 0 0 0 0 0 2 0 2\n" >> mask1.dat
printf "0 0 2 0 2 2 2 2 2 0 2 2 2 2 0 2\n" >> mask1.dat
printf "0 0 2 0 0 0 0 0 2 0 2 0 0 2 0 2\n" >> mask1.dat
printf "0 0 2 0 2 2 0 2 0 0 0 0 2 2 0 2\n" >> mask1.dat
printf "0 0 2 0 0 2 0 2 2 2 2 2 2 0 0 2\n" >> mask1.dat
printf "0 0 2 2 0 2 0 0 0 2 0 0 0 0 2 2\n" >> mask1.dat
printf "0 0 2 0 0 2 2 2 0 2 0 2 2 0 0 2\n" >> mask1.dat
printf "0 0 2 0 2 2 0 0 0 2 0 0 0 0 2 2\n" >> mask1.dat
printf "0 0 2 0 0 2 2 2 2 2 2 2 2 0 0 2\n" >> mask1.dat
printf "0 0 2 2 0 0 0 0 0 0 0 0 2 2 2 2\n" >> mask1.dat
printf "0 0 2 2 2 2 2 2 2 2 2 0 2 2 2 2\n" >> mask1.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask1.dat

  asc2flat mask1.dat mask1.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=HRRT mask1.bin correct_moved_mask1.v 1 1 16 16
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f correct_moved_mask2.v ] || [ ! -f mask2.dat ]; then
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n"  > mask2.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask2.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0\n" >> mask2.dat
printf "0 0 2 2 2 2 2 2 2 2 2 2 2 2 1 2\n" >> mask2.dat
printf "0 0 2 1 1 1 1 1 1 1 1 1 1 1 1 2\n" >> mask2.dat
printf "0 0 2 1 2 2 2 2 2 2 2 2 0 2 0 2\n" >> mask2.dat
printf "0 0 2 1 2 0 0 0 0 0 0 0 0 2 0 2\n" >> mask2.dat
printf "0 0 2 0 2 2 2 2 2 0 2 2 2 2 0 2\n" >> mask2.dat
printf "0 0 2 0 0 0 0 0 2 0 2 0 0 2 0 2\n" >> mask2.dat
printf "0 0 2 0 2 2 0 2 0 0 0 0 2 2 0 2\n" >> mask2.dat
printf "0 0 2 0 0 2 0 2 2 2 2 2 2 0 0 2\n" >> mask2.dat
printf "0 0 2 2 0 2 0 0 0 2 0 0 0 0 2 2\n" >> mask2.dat
printf "0 0 2 0 0 2 2 2 0 2 0 2 2 0 0 2\n" >> mask2.dat
printf "0 0 2 0 2 2 0 0 0 2 0 0 0 0 2 2\n" >> mask2.dat
printf "0 0 2 0 0 2 2 2 2 2 2 2 2 0 0 2\n" >> mask2.dat
printf "0 0 2 2 0 0 0 0 0 0 0 0 2 2 2 2\n" >> mask2.dat

  asc2flat mask2.dat mask2.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=HRRT mask2.bin correct_moved_mask2.v 1 1 16 16
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi


if [ ! -f correct_moved_mask3.v ] || [ ! -f mask3.dat ]; then
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0\n"  > mask3.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0\n" >> mask3.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0\n" >> mask3.dat
printf "0 0 2 2 2 2 2 2 2 2 2 2 2 2 1 2\n" >> mask3.dat
printf "0 0 2 1 1 1 1 1 1 1 1 1 1 1 1 2\n" >> mask3.dat
printf "0 0 2 1 2 2 2 2 2 2 2 2 0 2 0 2\n" >> mask3.dat
printf "0 0 2 1 2 0 0 0 0 0 0 0 0 2 0 2\n" >> mask3.dat
printf "0 0 2 0 2 2 2 2 2 0 2 2 2 2 0 2\n" >> mask3.dat
printf "0 0 2 0 0 0 0 0 2 0 2 0 0 2 0 2\n" >> mask3.dat
printf "0 0 2 0 2 2 0 2 0 0 0 0 2 2 0 2\n" >> mask3.dat
printf "0 0 2 0 0 2 0 2 2 2 2 2 2 0 0 2\n" >> mask3.dat
printf "0 0 2 2 0 2 0 0 0 2 0 0 0 0 2 2\n" >> mask3.dat
printf "0 0 2 0 0 2 2 2 0 2 0 2 2 0 0 2\n" >> mask3.dat
printf "0 0 2 0 2 2 0 0 0 2 0 0 0 0 2 2\n" >> mask3.dat
printf "0 0 2 0 0 2 2 2 2 2 2 2 2 0 0 2\n" >> mask3.dat
printf "0 0 2 2 0 0 0 0 0 0 0 0 2 2 2 2\n" >> mask3.dat

  asc2flat mask3.dat mask3.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=HRRT mask3.bin correct_moved_mask3.v 1 1 16 16
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n 1.0.0 \n"
printf " Test case: Move 4D image one frame at a time. \n"
printf " Expected result: Correct regional TACs extracted. \n\n"

$PROGRAM orig.v 0 4 2 moveyu.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft -P moveyu.v orig.roi moveyu.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM moveyu.v -4 -4 3 movex1yd.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft -P movex1yd.v orig.roi movex1yd.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM movex1yd.v 2 0 1 move.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft -P move.v orig.roi move.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

tacmatch -abs=0.0001 correct_move.tac move.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.0 \n"
printf " Test case: Move mask image to right without specifying frame or output file. \n"
printf " Expected result: Mask image modified correctly. \n\n"

cp -f mask.v output.v

$PROGRAM output.v 1 0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

imgmatch correct_moved_mask1.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

printf "\n 1.1.1 \n"
printf " Test case: Move mask image to right and down without specifying frame or output file. \n"
printf " Expected result: Mask image modified correctly. \n\n"

cp -f mask.v output.v

$PROGRAM output.v 1 -2
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

imgmatch correct_moved_mask2.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"


printf "\n 1.2.0 \n"
printf " Test case: Move mask image with option -fill. \n"
printf " Expected result: Mask image modified correctly. \n\n"

cp -f mask.v output.v

$PROGRAM -d10 -fill output.v 1 -2
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

imgmatch correct_moved_mask3.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"



printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0


