#!/bin/bash
#: Title      : test_imgzavg
#: Date       : 2022-02-09
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../imgzavg$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"



if [ ! -f original.tac ]; then
  rm -f original1.v volume.v
  printf "start[seconds]	end[Bq/cc]	reg1	reg2	reg3	reg4\n" > original.tac
  printf "0	60	0	-100	-10	10\n" >> original.tac
  printf "60	120	1000	0	-10	40\n" >> original.tac
  printf "120	240	0	100	0	50\n" >> original.tac
  printf "240	360	0	200	0	50\n" >> original.tac
  printf "360	480	0	300	0	40\n" >> original.tac
  printf "480	600	0	400	0	30\n" >> original.tac
  printf "600	1200	0	500	0	25\n" >> original.tac
  printf "1200	1800	0	600	0	20\n" >> original.tac
fi


printf "\n making test data \n"

if [ ! -f original1.v ] || [ ! -f volume.v ]; then
  dft2img -scanner=HR+ -zoom=2 -dim=16 original.tac original1.v original.roi
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgcalc original1.v x 2 original2.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgcalc original1.v x 3 original3.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgadd volume.v original1.v original2.v original3.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n 1.0.0 \n"
printf " Test case: 4D image. \n"
printf " Expected result: Output image contains one plane with correct values. \n\n"

rm -f output.v

$PROGRAM volume.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.001 original2.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.0 \n"
printf " Test case: Image with just one plane. \n"
printf " Expected result: Image is copied. \n\n"

rm -f output.v

$PROGRAM original3.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.001 original3.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

