#!/bin/bash
#: Title      : test_extrapol
#: Date       : 2014-10-05
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../extrapol$EXT;

printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n 1.0.0 Extrapolate 0-10 min data to 20 min \n"

rm -f output1.dat output1.svg
$PROGRAM -svg=output1.svg extrapol_plasma.dat 20 output1.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.005 extrapol_correct1.dat output1.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\---------------------------------------------------------------\n"
printf "\n 1.1.0 Extrapolate 0-5 min data to 15 min \n"

rm -f output2.dat output2.svg
$PROGRAM -e=5 -svg=output2.svg extrapol_plasma2.dat 15 output2.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.005 extrapol_correct2.dat output2.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.1.1 Extrapolate 0-5 min data to 15 min, with outlier at 2.4 min \n"

rm -f output2b.dat output2b.svg
$PROGRAM -e=5 -svg=output2b.svg extrapol_plasma2b.dat 15 output2b.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.005 extrapol_correct2b.dat output2b.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\---------------------------------------------------------------\n"
printf "\n 1.2.0 Extrapolate 0-5 min data to 15 min with at least 3.5 minutes\n"

rm -f output4.dat output4.svg
$PROGRAM -e=5 -mintime=3.5 -svg=output4.svg extrapol_plasma2.dat 15 output4.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.005 extrapol_correct4.dat output4.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\---------------------------------------------------------------\n"
printf "\n 1.3.0 More than one TAC\n"

rm -f output5.dat output5.svg
$PROGRAM -maxnr=4 -svg=output5.svg extrapol_plasma3.dat 20 output5.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
tacmatch -rel=5 extrapol_correct5.dat output5.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"
printf "  All passed.\n"
printf "===================================================================\n"
exit 0

