#!/bin/bash
#: Title      : test_metabcor
#: Date       : 2015-11-20
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../metabcor$EXT;

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi



if [ ! -f correct_data1_1_3_pure.dat ] || [ ! -f correct_data1_1_4_pure.dat ] ; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f correct_data1_3_4_pure.dat ] || [ ! -f correct_data2_1_1_met.dat ] ; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi 
if [ ! -f correct_data2_1_1_pure.dat ] || [ ! -f correct_data2_1_3_met.dat ] ; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f correct_data2_1_3_met2.dat ] || [ ! -f correct_data2_1_5_met2.dat ] ; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f correct_data2_1_5_met3.dat ] || [ ! -f correct_data2_2_1_met.dat ] ; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f correct_data2_2_1_pure.dat ] || [ ! -f data1_1_3.dat ] ; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f data1_1_4.dat ] || [ ! -f data1_2_3.rat ] || [ ! -f data1_3_1.dat ] ; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f data1_3_2.dat ] || [ ! -f data1_3_3.rat ] || [ ! -f data1_3_4.dat ] ; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f data1_3_4.rat ] || [ ! -f data1_3_5.rat ] || [ ! -f data1_3_6.rat ] ; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f data1_3_7.rat ] || [ ! -f data1_4_1.fit ] || [ ! -f data1_4_2.fit ] ; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f data1_4_3.fit ] || [ ! -f data1_4_4.fit ] || [ ! -f data1_x_x.dat ] ; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f data1_x_x.rat ] || [ ! -f data2_1_1.dat ] || [ ! -f data2_1_1.rat ] ; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f data2_1_2.rat ] || [ ! -f data2_1_3.dat ] || [ ! -f data2_1_3.rat ] ; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f data2_1_4.rat ] || [ ! -f data2_1_5.dat ] || [ ! -f data2_1_5.rat ] ; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f data2_2_1.dat ] || [ ! -f data2_2_1.rat ] || [ ! -f data2_3_1.dat ] ; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
printf "ok\n"
if [ ! -f data2_4_1.fit ] || [ ! -f data2_5_1.dat ] || [ ! -f data2_5_1.rat ] ; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
printf "ok\n"
if [ ! -f data3_1_2.rat ] ; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
printf "ok\n"



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"



printf "\n 1.0.0 \n"
printf " Test case: Plasma file contains more than one TAC. \n"
printf " Expected result 1: First is used, and warning is printed. \n"
printf " Expected result 2: Calculated parent TAC is correct. \n\n"

rm -f stdout.txt

$PROGRAM data1_1_3.dat data1_x_x.rat &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Warning "plasma file contains several TACs; only the first is used."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y correct_data1_1_3_pure.dat data1_1_3_pure.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.0.1 \n"
printf " Test case: Plasma file contains missing value. \n"
printf " Expected result 1: Missing value not included in results. \n"
printf " Expected result 2: Calculated parent TAC is correct. \n\n"

rm -f stdout.txt

$PROGRAM data1_1_4.dat data1_x_x.rat &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y correct_data1_1_4_pure.dat data1_1_4_pure.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.1.0 \n"
printf " Test case: Discrete fractions must not be extrapolated too much. \n"
printf " Expected result: Error when extrapolation is too much. \n\n"

rm -f stdout.txt
cp -f data1_3_2.dat temp.dat
printf "1000 1\n" >> temp.dat

$PROGRAM temp.dat data1_x_x.rat &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "excessive extrapolation needed for fractions."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.1 \n"
printf " Test case: Discrete fractions must not be extrapolated too much. \n"
printf " Expected result: Warning when only reasonable extrapolation. \n\n"

rm -f stdout.txt

$PROGRAM data1_3_2.dat data1_x_x.rat &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Warning "excessive extrapolation needed for fractions."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.2.0 \n"
printf " Test case: Sum of discrete fractions is clearly over 100. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt

$PROGRAM data1_x_x.dat data1_3_3.rat &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid fraction values."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.2.1 \n"
printf " Test case: Sum of discrete fractions is clearly over 1 but less than 100. \n"
printf " Expected result: Fractions divided by 100. Warning. \n\n"

rm -f stdout.txt

$PROGRAM data1_3_4.dat data1_3_4.rat &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Warning "converting percentages to fractions."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch correct_data1_3_4_pure.dat data1_3_4_pure.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.2.2 \n"
printf " Test case: Discrete parent fractions contain a missing value. \n"
printf " Expected result: Missing value is replaced by interpolated value. \n\n"

rm -f stdout.txt

$PROGRAM data1_3_4.dat data1_3_5.rat &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch correct_data1_3_4_pure.dat data1_3_4_pure.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.2.3 \n"
printf " Test case: Discrete metabolite fractions contain a missing value. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt

$PROGRAM data1_3_4.dat data1_3_6.rat &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "missing metabolite fraction(s)."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.2.4 \n"
printf " Test case: Discrete fractions file contain over 4 fractions. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt

$PROGRAM data1_3_4.dat data1_3_7.rat &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error in 'data1_3_7.rat'" "too many metabolites."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n\n---------------------------------------------------------------\n\n"


printf "\n 1.3.0 \n"
printf " Test case: Fitted fractions must be excessively extrapolated. \n"
printf " Expected result: Warning. \n\n"

rm -f stdout.txt

$PROGRAM data1_x_x.dat data1_4_1.fit &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Warning" "excessive extrapolation needed for fractions."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.3.1 \n"
printf " Test case: Sum of fitted fractions exceeds 100. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt

$PROGRAM data1_x_x.dat data1_4_2.fit &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "invalid fraction values."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.3.2 \n"
printf " Test case: Sum of fitted fractions exceeds 1 but not 100. \n"
printf " Expected result: Warning. Automatically converted to fractions.\n\n"

rm -f stdout.txt

$PROGRAM data1_x_x.dat data1_4_3.fit &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Warning" "converting percentages to fractions."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

cp -f data1_x_x.dat test.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fit2dat -f=data1_x_x.dat data1_4_3.fit perc.rat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
taccalc perc.rat x 0.01 test.rat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
$PROGRAM test.dat test.rat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.1 -rel=0.1 test_pure.dat data1_x_x_pure.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.3.3 \n"
printf " Test case: More than 4 fitted fractions. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt

$PROGRAM data1_x_x.dat data1_4_4.fit &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error in 'data1_4_4.fit'" "too many metabolites."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n\n---------------------------------------------------------------\n\n"


printf "\n 1.4.0 \n"
printf " Test case: Unknown option. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt

$PROGRAM -nonexistingoption data1_x_x.dat data1_x_x.rat &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid option '-nonexistingoption'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.4.1 \n"
printf " Test case: Too many arguments. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt

$PROGRAM data1_x_x.dat data1_x_x.rat extra &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid argument 'extra'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n\n---------------------------------------------------------------\n\n"

printf "\n 2.0.0 \n"
printf " Test case: discrete fractions for parent tracer only. \n"
printf " Expected result: Correct parent and one metabolite TAC calculated. \n\n"

rm -f stdout.txt data2_1_1_pure.dat data2_1_1_met.dat

$PROGRAM data2_1_1.dat data2_1_1.rat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch correct_data2_1_1_pure.dat data2_1_1_pure.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch correct_data2_1_1_met.dat data2_1_1_met.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 2.0.1 \n"
printf " Test case: discrete fractions for parent tracer and metabolite, sum 1. \n"
printf " Expected result: Correct parent and one metabolite TAC calculated. \n\n"

rm -f stdout.txt data2_1_1_pure.dat data2_1_1_met.dat

$PROGRAM data2_1_1.dat data2_1_2.rat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch correct_data2_1_1_pure.dat data2_1_1_pure.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch correct_data2_1_1_met.dat data2_1_1_met.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 2.0.2 \n"
printf " Test case: discrete fractions for parent tracer and metabolite, sum less than 1. \n"
printf " Expected result: Correct parent and two metabolite TACs calculated. \n\n"

rm -f stdout.txt data2_1_3_pure.dat data2_1_3_met.dat data2_1_3_met2.dat

$PROGRAM data2_1_3.dat data2_1_3.rat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch correct_data2_1_1_pure.dat data2_1_3_pure.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch correct_data2_1_3_met.dat data2_1_3_met.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch correct_data2_1_3_met2.dat data2_1_3_met2.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.0.2 \n"
printf " Test case: discrete fractions for parent tracer and 2 metabolite, sum 1. \n"
printf " Expected result: Correct parent and two metabolite TACs calculated. \n\n"

rm -f stdout.txt data2_1_3_pure.dat data2_1_3_met.dat data2_1_3_met2.dat

$PROGRAM data2_1_3.dat data2_1_4.rat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch correct_data2_1_1_pure.dat data2_1_3_pure.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch correct_data2_1_3_met.dat data2_1_3_met.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch correct_data2_1_3_met2.dat data2_1_3_met2.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 2.0.3 \n"
printf " Test case: discrete fractions for parent tracer and 2 metabolite, sum less than 1. \n"
printf " Expected result: Correct parent and 3 metabolite TACs calculated. \n\n"

rm -f stdout.txt data2_1_5_pure.dat data2_1_5_met.dat data2_1_5_met2.dat data2_1_5_met3.dat

$PROGRAM data2_1_5.dat data2_1_5.rat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch correct_data2_1_1_pure.dat data2_1_5_pure.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch correct_data2_1_3_met.dat data2_1_5_met.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch correct_data2_1_5_met2.dat data2_1_5_met2.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch correct_data2_1_5_met3.dat data2_1_5_met3.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n===================================================================\n"
printf "   Fraction data is fitted and then used in metabolite correction \n"
printf "===================================================================\n"


printf "\n 3.0.0 \n"
printf " Test case: Traditional Hill type function. \n"
printf " Expected result: Correct parent and metabolite TACs calculated. \n\n"

rm -f data2_2_1.fit data2_2_1_pure.dat data2_2_1_met.dat

fit_ppf -model=hill -d=1 -e=0 data2_2_1.rat data2_2_1.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM data2_2_1.dat data2_2_1.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

fit2dat -f=data2_2_1.dat data2_2_1.fit temp.rat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
taccalc -f data2_2_1.dat x temp.rat pure.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
taccalc -f data2_2_1.dat - pure.dat met.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tacmatch -abs=0.1 -rel=1 data2_2_1_pure.dat pure.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.1 -rel=1 data2_2_1_met.dat met.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 3.1.0 \n"
printf " Test case: Exponential function. \n"
printf " Expected result: Correct parent and metabolite TACs calculated. \n\n"

rm -f data2_3_1.fit data2_3_1_pure.dat data2_3_1_met.dat
cp -f data2_2_1.dat data2_3_1.dat

fit_fexp data2_2_1.rat data2_3_1.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM data2_3_1.dat data2_3_1.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

fit2dat -f=data2_3_1.dat data2_3_1.fit temp.rat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
taccalc -f data2_3_1.dat x temp.rat pure.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
taccalc -f data2_3_1.dat - pure.dat met.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tacmatch -abs=0.1 -rel=1 data2_3_1_pure.dat pure.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.1 -rel=1 data2_3_1_met.dat met.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 3.2.0 \n"
printf " Test case: Exponential function fitted to 4 percentages (fit_exp). \n"
printf " Expected result: Correct parent TAC calculated. \n\n"

rm -f stdout.txt

$PROGRAM data1_x_x.dat data2_4_1.fit &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Warning" "converting percentages to fractions."

fit2dat -f=data1_x_x.dat data2_4_1.fit perc.rat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
taccalc -f perc.rat x 0.01 test.rat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
cp -f data1_x_x.dat test.dat
$PROGRAM test.dat test.rat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

tacmatch -abs=0.1 -rel=1 test_pure.dat data1_x_x_pure.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n 3.3.0 \n"
printf " Test case: fit_ppf fractions. \n"
printf " Expected result: Correct parent and metabolite TACs calculated. \n\n"

rm -f data2_5_1.fit data2_5_1_pure.dat data2_5_1_met.dat

fit_ppf -model=hill -w1 data2_5_1.rat data2_5_1.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM data2_5_1.dat data2_5_1.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

fit2dat -f=data2_5_1.dat data2_5_1.fit temp.rat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
taccalc -f data2_5_1.dat x temp.rat pure.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
taccalc -f data2_5_1.dat - pure.dat met.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tacmatch -abs=0.1 -rel=1 pure.dat data2_5_1_pure.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.1 -rel=1 met.dat data2_5_1_met.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n===================================================================\n"
printf "   Naming options \n"
printf "===================================================================\n"


printf "\n 4.0.0 \n"
printf " Test case: Set output filenames with options -pure and -met. \n"
printf " Expected result: Correctly named parent and metabolite TACs are made. \n\n"

cp -f data1_x_x.dat data4_0_0.dat
rm -f data4_0_0.ftha.dat data4_0_0.met.dat 
fit_ppf -model=hill -d=1 -e=0 -w1  data1_x_x.rat data4_0_0.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM data4_0_0.dat data4_0_0.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM -pure=.ftha -met=.met data4_0_0.dat data4_0_0.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

tacmatch -abs=0.1 -rel=1 data4_0_0_met.dat data4_0_0.met.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.1 -rel=1 data4_0_0_pure.dat data4_0_0.ftha.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 4.0.1 \n"
printf " Test case: Set output filenames with options -pure, -met, and -met2. \n"
printf " Expected result 1: Correctly named parent and metabolite TACs are made. \n"
printf " Expected result 2: TAC names in result files are correct. \n\n"

cp -f data1_x_x.dat data4_0_1.dat
tacunit -yset=kBq/ml data4_0_1.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tacren data4_0_1.dat 1 plasma
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
rm -f data4_0_1_fdopa.dat data4_0_1_omfd.dat data4_0_1_other.dat

$PROGRAM data4_0_1.dat data2_1_4.rat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacren data4_0_1_pure.dat 1 @_fdopa
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tacren data4_0_1_met.dat 1 @_omfd
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tacren data4_0_1_met2.dat 1 @_other
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM -pure=_fdopa -met=_omfd -met2=_other data4_0_1.dat data2_1_4.rat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

tacmatch -abs=0.1 -rel=1 -tacnames=y data4_0_1_pure.dat data4_0_1_fdopa.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.1 -rel=1 -tacnames=y data4_0_1_met.dat data4_0_1_omfd.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.1 -rel=1 -tacnames=y data4_0_1_met2.dat data4_0_1_other.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n\n---------------------------------------------------------------\n\n"


printf "\n 4.1.0 \n"
printf " Test case: Set output filenames with options -fnpure and -fnmet. \n"
printf " Expected result: Correctly named parent and metabolite TACs are made. \n\n"

cp -f data1_x_x.dat data4_1_0.dat
rm -f ftha.dat metab.dat 
fit_ppf -model=hill -d=1 -e=0 -w1  data1_x_x.rat data4_1_0.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM data4_1_0.dat data4_1_0.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM -fnpure=ftha.dat -fnmet=metab.dat data4_1_0.dat data4_1_0.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

tacmatch -abs=0.1 -rel=1 data4_1_0_met.dat metab.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.1 -rel=1 data4_1_0_pure.dat ftha.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 4.1.1 \n"
printf " Test case: Set output filenames with options -fnpure, -fnmet and -fnmet2. \n"
printf " Expected result 1: Correctly named parent and metabolite TACs are made. \n"
printf " Expected result 2: TAC names in result files are correct. \n\n"

cp -f data1_x_x.dat data4_1_1.kbq
rm -f fdopa.kbq omfd.kbq other.kbq 
tacunit -yset=kBq/ml data4_1_1.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tacren data4_1_1.kbq 1 plasma
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

$PROGRAM data4_1_1.kbq data2_1_4.rat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacren data4_1_1_pure.kbq 1 @_fdopa
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tacren data4_1_1_met.kbq 1 @_omfd
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tacren data4_1_1_met2.kbq 1 @_other
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM -fnpure=fdopa.kbq -fnmet=omfd.kbq -fnmet2=other.kbq -pure=_fdopa -met=_omfd -met2=_other data4_1_1.kbq data2_1_4.rat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

tacmatch -abs=0.1 -rel=1 -tacnames=y data4_1_1_pure.kbq fdopa.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.1 -rel=1 -tacnames=y data4_1_1_met.kbq omfd.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.1 -rel=1 -tacnames=y data4_1_1_met2.kbq other.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

