#!/bin/bash
#: Title      : test_imgdv
#: Date       : 2018-06-26
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../imgdv$EXT;

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"

if [ ! -f plasma.dat ] || [ ! -f frames.dat ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi

printf "\n making test data \n"


if [ ! -f dynamic.v ] || [ ! -f dynamic.img ] || [ ! -f dynamic.dft ]; then
  printf "Making dynamic.v for testing\n"
  printf "Note that this contains TACs which cannot be well fitted with Logan\n"
  printf "and therefore you should test only regional vs parametric Logan results.\n"

  rm -f dvorig.dft
  p2t_3c -nosub --silent plasma.dat 0.050 0.025 0 0 0 0 tis.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent dvorig.dft tis.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub --silent plasma.dat 0.050 0.100 0 0 0 0 tis.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent dvorig.dft tis.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub --silent plasma.dat 0.050 0.250 0 0 0 0 tis.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent dvorig.dft tis.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub --silent plasma.dat 0.050 0.025 0.002 0.04 0 0 tis.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent dvorig.dft tis.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub --silent plasma.dat 0.050 0.100 0.002 0.04 0 0 tis.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent dvorig.dft tis.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub --silent plasma.dat 0.050 0.250 0.002 0.04 0 0 tis.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent dvorig.dft tis.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub --silent plasma.dat 0.050 0.025 0.05 0.025 0 0 tis.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent dvorig.dft tis.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub --silent plasma.dat 0.050 0.100 0.05 0.025 0 0 tis.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent dvorig.dft tis.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub --silent plasma.dat 0.050 0.250 0.05 0.025 0 0 tis.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent dvorig.dft tis.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub --silent plasma.dat 0.050 0.025 0.25 0.050 0 0 tis.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent dvorig.dft tis.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub --silent plasma.dat 0.050 0.100 0.25 0.050 0 0 tis.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent dvorig.dft tis.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub --silent plasma.dat 0.050 0.250 0.25 0.050 0 0 tis.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent dvorig.dft tis.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub --silent plasma.dat 0.200 0.050 0 0 0 0 tis.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent dvorig.dft tis.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub --silent plasma.dat 0.200 0.200 0 0 0 0 tis.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent dvorig.dft tis.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub --silent plasma.dat 0.200 0.800 0 0 0 0 tis.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent dvorig.dft tis.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub --silent plasma.dat 0.200 0.050 0.005 0.05 0 0 tis.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent dvorig.dft tis.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub --silent plasma.dat 0.200 0.200 0.005 0.05 0 0 tis.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent dvorig.dft tis.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub --silent plasma.dat 0.200 0.800 0.005 0.05 0 0 tis.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent dvorig.dft tis.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub --silent plasma.dat 0.200 0.050 0.05 0.05 0 0 tis.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent dvorig.dft tis.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub --silent plasma.dat 0.200 0.200 0.05 0.05 0 0 tis.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent dvorig.dft tis.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub --silent plasma.dat 0.200 0.800 0.05 0.05 0 0 tis.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent dvorig.dft tis.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub --silent plasma.dat 0.200 0.050 0.5 0.02 0 0 tis.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent dvorig.dft tis.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub --silent plasma.dat 0.200 0.200 0.5 0.02 0 0 tis.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent dvorig.dft tis.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub --silent plasma.dat 0.200 0.800 0.5 0.02 0 0 tis.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent dvorig.dft tis.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub --silent plasma.dat 0.500 0.050 0 0 0 0 tis.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent dvorig.dft tis.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub --silent plasma.dat 0.500 0.400 0 0 0 0 tis.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent dvorig.dft tis.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub --silent plasma.dat 0.500 0.800 0 0 0 0 tis.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent dvorig.dft tis.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub --silent plasma.dat 0.500 0.050 0.01 0.1 0 0 tis.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent dvorig.dft tis.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub --silent plasma.dat 0.500 0.400 0.01 0.1 0 0 tis.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent dvorig.dft tis.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub --silent plasma.dat 0.500 0.800 0.01 0.1 0 0 tis.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent dvorig.dft tis.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub --silent plasma.dat 0.500 0.050 0.1 0.5 0 0 tis.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent dvorig.dft tis.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub --silent plasma.dat 0.500 0.400 0.1 0.5 0 0 tis.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent dvorig.dft tis.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub --silent plasma.dat 0.500 0.800 0.1 0.5 0 0 tis.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent dvorig.dft tis.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub --silent plasma.dat 0.500 0.050 0.5 0.025 0 0 tis.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent dvorig.dft tis.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub --silent plasma.dat 0.500 0.400 0.5 0.025 0 0 tis.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent dvorig.dft tis.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub --silent plasma.dat 0.500 0.800 0.5 0.025 0 0 tis.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent dvorig.dft tis.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  simframe dvorig.dft frames.dat dvorigf.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacren dvorigf.dft 0 r#
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tac2svg -legend=y dvorigf.svg dvorigf.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  dft2img -scanner=HR+ -zoom=2 -dim=32 dvorigf.dft dynamic.v dv.roi
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgunit -u=kBq/ml dynamic.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  esetstrt dynamic.v 2005-07-25 09:49:00
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgdecay -i=C-11 -dc dynamic.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  img2tif -s -rb dynamic.v dynamic.tif
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2dft -p dynamic.v dv.roi dynamic.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tac2svg dynamic.svg -l dynamic.dft plasma.dat
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  printf "\n ok \n\n"
fi

if [ ! -f correct_dv.v ] || [ ! -f correct_dv.dft ] || [ ! -f correct_dv.res ]; then
  rm -f temp.dat
  printf "0 " > temp.dat
  printf "2.0000E+00 5.0000E-01 2.0000E-01 2.1000E+00 5.2500E-01 " >> temp.dat
  printf "2.1000E-01 6.0000E+00 1.5000E+00 6.0000E-01 1.2000E+01 " >> temp.dat
  printf "3.0000E+00 1.2000E+00 4.0000E+00 1.0000E+00 2.5000E-01 " >> temp.dat
  printf "4.4000E+00 1.1000E+00 2.7500E-01 8.0000E+00 2.0000E+00 " >> temp.dat
  printf "5.0000E-01 1.0400E+02 2.6000E+01 6.5000E+00 4.0000E+00 " >> temp.dat
  printf "1.2500E+00 6.2500E-01 1.1000E+01 1.3750E+00 6.8750E-01 " >> temp.dat
  printf "1.2000E+01 1.5000E+00 7.5000E-01 2.1000E+02 2.6250E+01 " >> temp.dat
  printf "1.3125E+01\n" >> temp.dat
  printf "# unit := ml/ml\n" >> temp.dat
  dft2img -scanner=HR+ -zoom=2 -dim=32 temp.dat correct_dv.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  esetstrt correct_dv.v 2005-07-25 09:49:00
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  img2tif -s -rb correct_dv.v correct_dv.tif
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2dft -p correct_dv.v dv.roi correct_dv.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  dft2res correct_dv.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  printf "\n ok \n\n"
fi



if [ ! -f dynamic2.v ] || [ ! -f dynamic2.dft ]; then
  rm -f dvorigf2.dft
  printf "Making dynamic2.v for testing\n"
  printf "This contains only TACs which can be well fitted with Logan.\n"
  tacadd dvorigf2.dft dvorigf.dft 1 
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd dvorigf2.dft dvorigf.dft 12 
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd dvorigf2.dft dvorigf.dft 13 
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd dvorigf2.dft dvorigf.dft 26 
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd dvorigf2.dft dvorigf.dft 27 
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd dvorigf2.dft dvorigf.dft 28 
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd dvorigf2.dft dvorigf.dft 31 
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  dft2img -scanner=HR+ -zoom=2 -dim=16 dvorigf2.dft dynamic2.v dv2.roi
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgunit -u=kBq/ml dynamic2.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  esetstrt dynamic2.v 2005-07-25 09:49:00
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgdecay -i=C-11 -dc dynamic2.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  img2tif -s -rb dynamic2.v dynamic2.tif
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2dft -p dynamic2.v dv.roi dynamic2.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tac2svg dynamic2.svg -l dynamic2.dft plasma.dat
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  printf "\n ok \n\n"
fi

if [ ! -f correct_dv2.v ] || [ ! -f correct_dv2.dft ] || [ ! -f correct_dv2.res ]; then
  rm -f temp2.dat
  printf "0 " > temp2.dat
  printf "2.0000E+00 1.2000E+00 4.0000E+00 1.2500E+00 6.2500E-01 " >> temp2.dat
  printf "1.1000E+01 1.2000E+01\n" >> temp2.dat
  printf "# unit := ml/ml\n" >> temp2.dat
  dft2img -scanner=HR+ -zoom=2 -dim=16 temp2.dat correct_dv2.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  esetstrt correct_dv2.v 2005-07-25 09:49:00
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  img2tif -s -rb correct_dv2.v correct_dv2.tif
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2dft -p correct_dv2.v dv2.roi correct_dv2.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  dft2res correct_dv2.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  printf "\n ok \n\n"
fi



if [ ! -f dynamic3.v ] || [ ! -f dynamic3.dft ] || [ ! -f refer.dft ]; then
  printf "Making dynamic3.v for testing reference input\n"

  rm -f orig.dft
  p2t_3c -nosub --silent plasma.dat 0.3 0.15 0.00 0    0 0 tis.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent orig.dft tis.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub --silent plasma.dat 0.4 0.2  0.01 0.1  0 0 tis.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent orig.dft tis.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub --silent plasma.dat 0.2 0.1  0.05 0.1  0 0 tis.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent orig.dft tis.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub --silent plasma.dat 0.4 0.2  0.10 0.05 0 0 tis.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent orig.dft tis.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub --silent plasma.dat 1.2 0.6  4.00 0.20 0 0 tis.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent orig.dft tis.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub --silent plasma.dat 0.4 0.2  0.50 0.1  0 0 tis.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent orig.dft tis.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  simframe --silent orig.dft frames.dat origf.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  dft2img -scanner=HR+ -zoom=2 -dim=8 origf.dft dynamic3.v dv3.roi
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  esetstrt dynamic3.v 2005-07-25 09:49:00
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  img2dft -p dynamic3.v dv3.roi dynamic3.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd -ovr refer.dft dynamic3.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

fi 


printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n 1.0.0 \n"
printf " Test case: No command line options or arguments. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt
$PROGRAM &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Usage"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "See also"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.0.1 \n"
printf " Test case: Unknown option. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt
$PROGRAM -stupidoption plasma.dat dynamic.v 30 output.v &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid option '-stupidoption'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.0.2 \n"
printf " Test case: Too many arguments. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt
$PROGRAM plasma.dat dynamic.v 30 output.v extra &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid argument 'extra'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.0.3 \n"
printf " Test case: Missing argument. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt
$PROGRAM dynamic.v 30 output.v &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f stdout.txt
$PROGRAM plasma.dat dynamic.v output.v &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f stdout.txt
$PROGRAM plasma.dat dynamic.v 30  &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"





printf "\n===================================================================\n"
printf "   Basic tests \n"
printf "===================================================================\n"


printf "\n 2.0.0 \n"
printf " Test case 1: Dynamic ECAT7 image, starting fit from 45 min. \n"
printf " Test case 2: Some TACs cannot be well modeled with Logan. \n"
printf " Expected result: Similar results as with regional Logan. \n\n"

rm -f output.v output.dft output.res

$PROGRAM plasma.dat dynamic.v 45 output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2tif -s -rb output.v output_200.tif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft -P --silent output.v dv.roi output.dft 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
dft2res output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"


printf "\n comparing to regionally calculated results \n\n"
logan --silent -p -sd=n -svg=regional.svg dynamic.dft plasma.dat 45 999 logan.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
resmatch -res=1 -roughly logan.res output.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.0.1 \n"
printf " Test case 1: Dynamic ECAT7 image, starting fit from 45 min. \n"
printf " Test case 2: All TACs can be reasonably well modeled with Logan. \n"
printf " Expected result: Results are close to correct ones. \n\n"

rm -f output2.v

$PROGRAM plasma.dat dynamic2.v 45 output2.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
printf "\n comparing computed Vt image to correct Vt image \n\n"
imgmatch -frames=n -abs=0.005 -rel=0.1 correct_dv2.v output2.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n 2.1.0 \n"
printf " Test case 1: Dynamic ECAT7 image, automatic fit start time. \n"
printf " Test case 2: Some TACs cannot be well modeled with Logan. \n"
printf " Expected result: Similar results as with regional Logan. \n\n"

rm -f output.v output.dft output.res

$PROGRAM plasma.dat dynamic.v 0 output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2tif -s -rb output.v output_210.tif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft -P --silent output.v dv.roi output.dft 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
dft2res output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"


printf "\n comparing to regionally calculated results \n\n"
logan --silent -p -sd=n dynamic.dft plasma.dat 60 999 logan.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
resmatch -res=1 -roughly logan.res output.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.1.1 \n"
printf " Test case 1: Dynamic ECAT7 image, automatic fit start time. \n"
printf " Test case 2: All TACs can be reasonably well modeled with Logan. \n"
printf " Expected result: Results are close to correct ones. \n\n"

rm -f output2.v

$PROGRAM plasma.dat dynamic2.v 0 output2.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
printf "\n comparing computed Vt image to correct Vt image \n\n"
imgmatch -frames=n -abs=0.002 -rel=0.02 correct_dv2.v output2.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n===================================================================\n"
printf "   Other image formats \n"
printf "===================================================================\n"


printf "\n 3.0.0 \n"
printf " Test case: Dynamic NIfTI image with SIF. \n"
printf " Expected result: Results are close to correct ones. \n\n"

rm -f nifti/*
ecat2nii -o=nifti -sif dynamic2.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM plasma.dat nifti/dynamic2 45 nifti/dv2
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -frames=n -abs=0.005 -rel=0.1 correct_dv2.v nifti/dv2
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 3.0.1 \n"
printf " Test case: Dynamic NIfTI image without SIF. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt nifti/*.sif

$PROGRAM plasma.dat nifti/dynamic2 45 nifti/dv2 &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error in reading data" "image frame times not available."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 3.1.0 \n"
printf " Test case: Dynamic Analyze image with SIF. \n"
printf " Expected result: Results are close to correct ones. \n\n"

rm -f ana/*
ecat2ana -o=ana -sif dynamic2.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM plasma.dat ana/dynamic2 45 ana/dv2
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -frames=n -abs=0.005 -rel=0.1 correct_dv2.v ana/dv2
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 3.1.1 \n"
printf " Test case: Dynamic Analyze image without SIF. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt ana/*.sif

$PROGRAM plasma.dat ana/dynamic2 45 ana/dv2 &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error in reading data" "image frame times not available."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n 3.2.0 \n"
printf " Test case: Dynamic ECAT6 image, automatic fit start time. \n"
printf " Expected result: Results are close to correct ones. \n\n"

rm -f dynamic2.img output2.img
e7to63 dynamic2.v dynamic2.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

$PROGRAM plasma.dat dynamic2.img 0 output2.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
printf "\n comparing computed Vt image to correct Vt image \n\n"
imgmatch -frames=n -abs=0.002 -rel=0.02 correct_dv2.v output2.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n===================================================================\n"
printf "   DVR with reference input \n"
printf "===================================================================\n"

printf "\n 4.0.0 \n"
printf " Test case 1: DVR image with reference input. \n"
printf " Test case 2: Reference k2 is given as option. \n"
printf " Expected result: Results are similar to regionally calculated ones. \n\n"

rm -f output.v output.dft output.res
logan -k2=0.15 -svg=loganref.svg -sd=n dynamic3.dft 1 60 999 loganref.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM -k2=0.15 refer.dft dynamic3.v 60 output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft -p output.v dv3.roi output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
dft2res output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
resdel output.res 1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

resmatch -res=1 -roughly loganref.res output.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 4.0.1 \n"
printf " Test case 1: DVR image with reference input. \n"
printf " Test case 2: Reference k2 is not given as option. \n"
printf " Expected result: Results are similar to regionally calculated ones. \n\n"

rm -f output2.v output2.dft output2.res
logan -sd=n dynamic3.dft 1 60 999 loganref2.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM refer.dft dynamic3.v 60 output2.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft -p output2.v dv3.roi output2.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
dft2res output2.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
resdel output2.res 1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

resmatch -res=1 -roughly loganref2.res output2.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"





rm -f ana/* nifti/*

printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

