#!/bin/bash
#: Title      : test_imgki
#: Date       : 2019-09-18
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../imgki$EXT;

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"


if [ ! -f plasma.dat ] || [ ! -f frames.dat ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi

printf "\n making test data \n"


if [ ! -f dynamic.v ] || [ ! -f dynamic.img ] || [ ! -f dynamic.dft ]; then
  PLANE=1
  p2t_3c -nosub plasma.dat 0.05 0.03 0.001 0 0 0 tis1.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.05 0.10 0.001 0 0 0 tis2.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.05 0.25 0.001 0 0 0 tis3.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.05 0.03 0.005 0 0 0 tis4.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.05 0.10 0.005 0 0 0 tis5.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.05 0.25 0.005 0 0 0 tis6.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.05 0.03 0.01 0 0 0 tis7.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.05 0.10 0.01 0 0 0 tis8.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.05 0.25 0.01 0 0 0 tis9.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent -ovr plane$PLANE.dft tis1.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent      plane$PLANE.dft tis2.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent      plane$PLANE.dft tis3.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent      plane$PLANE.dft tis4.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent      plane$PLANE.dft tis5.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent      plane$PLANE.dft tis6.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent      plane$PLANE.dft tis7.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent      plane$PLANE.dft tis8.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent      plane$PLANE.dft tis9.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  simframe plane$PLANE.dft frames.dat plane$PLANE'f.dft' F-18
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacren plane$PLANE'f.dft' 0 r#
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  dft2img -scanner=HR+ -zoom=2 -dim=8 plane$PLANE'f.dft' plane$PLANE.v plane$PLANE'.roi'
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  PLANE=2
  p2t_3c -nosub plasma.dat 0.20 0.05 0 0 0 0 tis1.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.20 0.20 0 0 0 0 tis2.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.20 0.80 0 0 0 0 tis3.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.20 0.05 0.002 0 0 0 tis4.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.20 0.20 0.002 0 0 0 tis5.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.20 0.80 0.002 0 0 0 tis6.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.20 0.05 0.01 0 0 0 tis7.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.20 0.20 0.01 0 0 0 tis8.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.20 0.80 0.01 0 0 0 tis9.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent -ovr plane$PLANE.dft tis1.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent      plane$PLANE.dft tis2.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent      plane$PLANE.dft tis3.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent      plane$PLANE.dft tis4.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent      plane$PLANE.dft tis5.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent      plane$PLANE.dft tis6.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent      plane$PLANE.dft tis7.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent      plane$PLANE.dft tis8.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent      plane$PLANE.dft tis9.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  simframe plane$PLANE.dft frames.dat plane$PLANE'f.dft' F-18
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacren plane$PLANE'f.dft' 0 r#
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  dft2img -scanner=HR+ -zoom=2 -dim=8 plane$PLANE'f.dft' plane$PLANE.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  PLANE=3
  p2t_3c -nosub plasma.dat 0.60 0.10 0.005 0 0 0 tis1.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.60 0.40 0.005 0 0 0 tis2.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.60 1.60 0.005 0 0 0 tis3.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.60 0.10 0.02 0 0 0 tis4.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.60 0.40 0.02 0 0 0 tis5.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.60 1.60 0.02 0 0 0 tis6.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.60 0.10 0.1 0 0 0 tis7.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.60 0.40 0.1 0 0 0 tis8.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.60 1.60 0.1 0 0 0 tis9.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent -ovr plane$PLANE.dft tis1.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent      plane$PLANE.dft tis2.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent      plane$PLANE.dft tis3.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent      plane$PLANE.dft tis4.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent      plane$PLANE.dft tis5.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent      plane$PLANE.dft tis6.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent      plane$PLANE.dft tis7.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent      plane$PLANE.dft tis8.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent      plane$PLANE.dft tis9.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  simframe plane$PLANE.dft frames.dat plane$PLANE'f.dft' F-18
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacren plane$PLANE'f.dft' 0 r#
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  dft2img -scanner=HR+ -zoom=2 -dim=8 plane$PLANE'f.dft' plane$PLANE.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  imgadd dynamic.v plane1.v plane2.v plane3.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgunit -u=kBq/ml dynamic.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  esetstrt dynamic.v 2007-08-07 12:15:34
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgdecay -i=F-18 -dc dynamic.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  e7to63 dynamic.v dynamic.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  img2tif -s -rb dynamic.v dynamic.tif
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2dft -p dynamic.v plane1.roi dynamic.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tac2svg dynamic.svg -l dynamic.dft plasma.dat
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  printf "\n ok \n\n"
fi



if [ ! -f correct_ki.v ]; then
  rm -f temp.dat
  PLANE=1
  printf "0 0.001923077 0.00049505 0.000199203 0.008333333 0.002380952 0.000980392 0.014285714 0.004545455 0.001923077\n" > temp.dat
  printf "# unit := 1/min\n" >> temp.dat
  dft2img -scanner=HR+ -zoom=2 -dim=8 temp.dat correct_plane$PLANE.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  PLANE=2
  printf "0 0 0 0 0.007692308 0.001980198 0.000498753 0.033333333 0.00952381 0.002469136\n" > temp.dat
  printf "# unit := 1/min\n" >> temp.dat
  dft2img -scanner=HR+ -zoom=2 -dim=8 temp.dat correct_plane$PLANE.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  PLANE=3
  printf "0 0.028571429 0.007407407 0.001869159 0.1 0.028571429 0.007407407 0.3 0.12 0.035294118\n" > temp.dat
  printf "# unit := 1/min\n" >> temp.dat
  dft2img -scanner=HR+ -zoom=2 -dim=8 temp.dat correct_plane$PLANE.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  imgadd correct_ki.v correct_plane1.v correct_plane2.v correct_plane3.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  esetstrt correct_ki.v 2007-08-07 12:15:34
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  img2tif -s -rb correct_ki.v correct_ki.tif
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2dft -p correct_ki.v plane1.roi correct_ki.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  printf "\n ok \n\n"
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n 1.0.0 \n"
printf " Test case: No command line options or arguments. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt
$PROGRAM &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Usage"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "See also"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.0.1 \n"
printf " Test case: Unknown option. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt
$PROGRAM -stupidoption plasma.dat dynamic.v 30 output.v &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid option '-stupidoption'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.0.2 \n"
printf " Test case: Too many arguments. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt
$PROGRAM plasma.dat dynamic.v 30 output.v extra &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid argument 'extra'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.0.3 \n"
printf " Test case: Missing argument. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt
$PROGRAM dynamic.v 30 output.v &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f stdout.txt
$PROGRAM plasma.dat dynamic.v output.v &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f stdout.txt
$PROGRAM plasma.dat dynamic.v 30  &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"





printf "\n===================================================================\n"
printf "   Basic tests \n"
printf "===================================================================\n"


printf "\n 2.0.0 \n"
printf " Test case 1: Dynamic ECAT7 image, starting fit from 30 min. \n"
printf " Expected result: Correct result. \n\n"

rm -f output.v output.dft output.res stdout.txt

$PROGRAM plasma.dat dynamic.v 30 output.v &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2tif -s -rb output.v output_200.tif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft -P output.v plane1.roi output.dft 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"


printf "\n comparing to regionally calculated results \n\n"
patlak -sd=n dynamic.dft plasma.dat 30 9999 patlak.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
dft2res output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"
resmatch -res=1 -abs=0.0005 patlak.res output.res

printf "\n comparing computed ki image to correct ki image \n\n"
imgmatch -frames=n -abs=0.005 -rel=10 correct_ki.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 2.0.1 \n"
printf " Test case: Dynamic ECAT6 image. \n"
printf " Expected result: Correct result. \n\n"

rm -f output.img output.dft output.res stdout.txt

$PROGRAM plasma.dat dynamic.img 30 output.img &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft -P output.img plane1.roi output.dft 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
dft2res output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
resmatch -res=1 -abs=0.0005 patlak.res output.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n-----------------------------------------------------------------\n\n"


printf "\n 2.1.0 \n"
printf " Test case: Calculation of MR image. \n"
printf " Expected result: Correct result. \n\n"

rm -f output2.v output2.dft output2.res stdout.txt

$PROGRAM -d2 -ca=4,2 -density=1,01 -LC=0,8 plasma.dat dynamic.v 30 output2.v &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "LC" "0.8"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "density" "1.01"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Ca" "4.2"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

img2tif -s -rb output2.v output_201.tif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft -P output2.v plane1.roi output2.dft 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"


printf "\n comparing to regionally calculated results \n\n"
patlak -sd=n -ca=4,2 -density=1,01 -LC=0,8 dynamic.dft plasma.dat 30 9999 mr.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
dft2res output2.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
resmatch -res=1 -abs=0.05 mr.res output2.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n-----------------------------------------------------------------\n\n"



printf "\n 2.2.0 \n"
printf " Test case: Dynamic ECAT7 image, automatic fit start time. \n"
printf " Expected result 1: Results are close to correct. \n\n"
printf " Expected result 2: Nr of points in fit can be saved in image. \n\n"

rm -f output.v output.dft output.res nr.v nr.dft nr.res stdout.txt

$PROGRAM -n=nr.v plasma.dat dynamic.v 0 output.v &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2tif -s -rb output.v output_210.tif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2tif -s -rb nr.v nr_210.tif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft -P output.v plane1.roi output.dft 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft -P nr.v plane1.roi nr.dft 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=n -y=y -abs=0.002 -rel=1 correct_ki.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n-----------------------------------------------------------------\n\n"



printf "\n 2.3.0 \n"
printf " Test case 1: Dynamic ECAT7 image, starting fit from 30 min. \n"
printf " Test case 2: Option -noneg sets negative values to zero. \n"
printf " Expected result: Correct result. \n\n"

rm -f output.v output.dft output.res stdout.txt

$PROGRAM -noneg plasma.dat dynamic.v 30 output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

img2dft -P output.v plane1.roi output.dft 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
dftmax -min -x=y -y=y output.dft > stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "overall_min_value" 0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n comparing computed ki image to correct ki image \n\n"
imgmatch -frames=n -abs=0.005 -rel=10 correct_ki.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"
printf "   Other image formats \n"
printf "===================================================================\n"


printf "\n 4.0.0 \n"
printf " Test case: Ki from dynamic NIfTI image with SIF. \n"
printf " Expected result: Results are correct, when units in kBq/mL. \n\n"

rm -f nifti/*
ecat2nii -o=nifti -sif dynamic.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM plasma.dat nifti/dynamic 30 nifti/ki
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -frames=n -abs=0.005 -rel=10 correct_ki.v nifti/ki
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 4.0.1 \n"
printf " Test case: Ki from NIfTI image without SIF. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt nifti/*.sif

$PROGRAM plasma.dat nifti/dynamic 30 nifti/ki &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error in reading data" "image frame times not available."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n--------------------------------------------------------------\n\n"

printf "\n 4.1.0 \n"
printf " Test case: Ki from dynamic Analyze image with SIF. \n"
printf " Expected result: Results are correct, when units in kBq/mL. \n\n"

rm -f ana/*
ecat2ana -o=ana -sif dynamic.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM plasma.dat ana/dynamic 30 ana/ki
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -frames=n -abs=0.005 -rel=10 correct_ki.v ana/ki
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 4.1.1 \n"
printf " Test case: Ki from Analyze image without SIF. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt ana/*.sif

$PROGRAM plasma.dat ana/dynamic 30 ana/ki &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error in reading data" "image frame times not available."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"






rm -f ana/* nifti/*

printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

