#!/bin/bash
#: Title      : test_logan
#: Date       : 2020-05-26
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../logan$EXT;

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

echo ""
printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"
echo ""

printf "\n verifying that required data exists \n"


if [ ! -f plasma.dat ] || [ ! -f frames.dat ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi


echo Simulating tissue curves for logan and yokoi
p2t_3c -nosub --silent plasma.dat 0.3 0.15 0.00 0    0 0 ref.dft
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
p2t_3c -nosub --silent plasma.dat 0.4 0.2  0.01 0.1  0 0 tis1.dft
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
p2t_3c -nosub --silent plasma.dat 0.2 0.1  0.05 0.1  0 0 tis2.dft
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
p2t_3c -nosub --silent plasma.dat 0.4 0.2  0.10 0.05 0 0 tis3.dft
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
p2t_3c -nosub --silent plasma.dat 1.2 0.6  4.00 0.20 0 0 tis4.dft
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
p2t_3c -nosub --silent plasma.dat 0.4 0.2  0.50 0.1  0 0 tis5.dft
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
tacadd -ovr --silent temp.dft ref.dft 1
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
tacadd --silent temp.dft tis1.dft 1
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
tacadd --silent temp.dft tis2.dft 1
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
tacadd --silent temp.dft tis3.dft 1
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
tacadd --silent temp.dft tis4.dft 1
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
tacadd --silent temp.dft tis5.dft 1
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
rm -f ref.dft tis1.dft tis2.dft tis3.dft tis4.dft tis5.dft
simframe --silent temp.dft frames.dat logan.dft C-11
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
tacren --silent logan.dft 1 ref_0_Pl01
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
tacren --silent logan.dft 2 tis1_22_Pl01
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
tacren --silent logan.dft 3 tis2_30_Pl01
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
tacren --silent logan.dft 4 tis3_60_Pl01
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
tacren --silent logan.dft 5 tis4_420_Pl01
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
tacren --silent logan.dft 6 tis5_1200_Pl01
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
tacstudy -force logan.dft test1 
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi


printf "\n\n Make also PMOD format files\n\n"
tacformat -f=pmod logan.dft logan.tac
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
tacformat -f=pmod plasma.dat plasma.bld
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi

printf "\n\n=================================================================\n"
printf "testing %s\n" $PROGRAM
printf "==================================================================\n"


printf "\n 1.0.0 \n\n"

printf "\n Testing Logan with simulated data and plasma input\n\n"
printf "Correct DVs: ref= 2,    tis1=2.2,   tis2=3.0, \n"
printf "             tis3=6.0,  tis4=42,    tis5=12   \n\n"

$PROGRAM -sd=n -svg=loganpr.svg -plotdata=loganpr.htm logan.dft plasma.dat 30 120 loganpr.res 
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n passed. \n"
resmatch -header=y -param=y -regions=y -roughly -errors=n -res=1-2 correct_loganpr.res loganpr.res
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n passed. \n\n\n"


printf "\n 1.0.1 \n\n"

$PROGRAM -sd=n -p -plotdata=loganpp.htm logan.dft plasma.dat 30 120 loganpp.res
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n passed. \n"
resmatch -header=y -param=y -regions=y -roughly -errors=n -res=1-2 correct_loganpp.res loganpp.res
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n passed. \n\n\n"


printf "\n 1.0.2 \n\n"

$PROGRAM -sd=n -c -plotdata=loganpc.htm logan.dft plasma.dat 30 120 loganpc.res
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n passed. \n"
resmatch -header=y -param=y -regions=y -roughly -errors=n -res=1-2 correct_loganpc.res loganpc.res
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n passed. \n\n\n"

printf "\n 1.0.3 \n\n"

$PROGRAM -sd=n -m -plotdata=loganpm.htm logan.dft plasma.dat 30 120 loganpm.res
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n passed. \n"
resmatch -header=y -param=y -regions=y -roughly -errors=n -res=1-2 correct_loganpm.res loganpm.res
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n passed. \n\n\n"




printf "\n=================================================================\n"

printf "\n 2.0.0 \n\n"

printf "\n Now testing automatic determination of fit start time\n\n"
printf "Correct DVs: ref= 2,    tis1=2.2,   tis2=3.0, \n"
printf "             tis3=6.0,  tis4=42,    tis5=12   \n\n"

$PROGRAM -r -sd=n -svg=loganprx.svg -plotdata=loganprx.htm logan.dft plasma.dat 0  120 loganprx.res 
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n passed. \n"
resmatch -header=y -param=y -regions=y -roughly -errors=n -res=1-2 correct_loganprx.res loganprx.res
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n passed. \n\n\n"

printf "\n 2.0.1 \n\n"

$PROGRAM -c -sd=n -svg=loganpcx.svg -plotdata=loganpcx.htm logan.dft plasma.dat 0  120 loganpcx.res
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n passed. \n"
resmatch -header=y -param=y -regions=y -roughly -errors=n -res=1-2 correct_loganpcx.res loganpcx.res
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n passed. \n\n\n"




printf "\n=================================================================\n"

printf "\n 3.0.0 \n\n"

printf "\n Testing Logan with simulated data and plasma input \n\n"
printf "  calculating also DVR, BPnd, or BPp \n"

$PROGRAM -sd=n -c -dvr=ref logan.dft plasma.dat 30 120 loganpc_dvr.res
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n passed. \n"
resmatch -header=y -param=y -regions=y -roughly -errors=n -res=1-4 correct_loganpc_dvr.res loganpc_dvr.res
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n passed. \n\n\n"

printf "\n 3.0.1 \n\n"

$PROGRAM -sd=n -c -BPnd=ref logan.dft plasma.dat 30 120 loganpc_bpnd.res
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n passed. \n"
resmatch -header=y -param=y -regions=y -roughly -errors=n -res=1-4 correct_loganpc_bpnd.res loganpc_bpnd.res
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n passed. \n\n\n"

printf "\n 3.0.2 \n\n"

$PROGRAM -sd=n -c -BPp=ref logan.dft plasma.dat 30 120 loganpc_bpp.res
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n passed. \n"
resmatch -header=y -param=y -regions=y -roughly -errors=n -res=1-4 correct_loganpc_bpp.res loganpc_bpp.res
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n passed. \n\n\n"




printf "\n=================================================================\n"

printf "\n 4.0.0 \n\n"

printf "\n Testing Logan with simulated data and ref input \n\n"
printf " Correct DVRs: ref= - ,   tis1=1.1,   tis2=1.5, \n"
printf "               tis3=3.0,  tis4=21,    tis5=6 \n\n"


$PROGRAM -k2=0.15 -bw -svg=loganrr.svg -plotdata=loganrr.htm logan.dft ref 60 120 loganrr.res
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n passed. \n"
resmatch -header=y -param=y -regions=y -roughly -errors=n -res=1-2 correct_loganrr.res loganrr.res
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n passed. \n\n\n"


printf "\n 4.0.1 \n\n"

printf "\n BPnd is reported instead of DVR with reference input \n\n"

$PROGRAM -k2=0,15 -BPnd logan.dft ref 60 120 loganrr_bpnd.res
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n passed. \n"
resmatch -header=y -param=y -regions=y -roughly -errors=n -res=1-2 correct_loganrr_bpnd.res loganrr_bpnd.res
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n passed. \n\n\n"

printf "\n 4.0.2 \n\n"

printf "\n Repeating some tests with PMOD format \n\n"
rm -f loganpr_pmod.res

$PROGRAM --verbose -sd=n logan.tac plasma.bld 30 120 loganpr_pmod.res
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n passed. \n"
resmatch -header=y -param=y -regions=y -roughly -errors=n -res=1-2 correct_loganpr_pmod.res loganpr_pmod.res
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n passed. \n\n\n"


printf "==================================================================\n\n"
printf "==================================================================\n"
#exit 0
rm -f stdout.* stderr.*
printf "\n==================================================================\n"
printf "  All passed.\n"
printf "\n==================================================================\n"
exit 0
