#!/bin/bash
#: Title      : test_regfur
#: Date       : 2014-10-05
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../regfur$EXT;

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

if [ ! -f plasma.dat ] || [ ! -f frames.dat ] ; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f correct_fur_50.dft ] || [ ! -f correct_fur_50b.dft ] ; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f correct_fur_60.dft ] || [ ! -f correct_fur_50.res ] ; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f correct_mr_50.dft ] ; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi


if [ ! -f dynamic.dft ] || [ ! -f dynamic.dat ]; then
  printf "\n making dynamic.dft for testing \n\n"
  PLANE=1
  p2t_3c -nosub plasma.dat 0.05 0.03 0.001 0 0 0 tis1.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.05 0.10 0.001 0 0 0 tis2.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.05 0.25 0.001 0 0 0 tis3.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.05 0.03 0.005 0 0 0 tis4.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.05 0.10 0.005 0 0 0 tis5.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.05 0.25 0.005 0 0 0 tis6.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.05 0.03 0.01 0 0 0 tis7.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.05 0.10 0.01 0 0 0 tis8.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.05 0.25 0.01 0 0 0 tis9.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent -ovr plane$PLANE.dft tis1.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent      plane$PLANE.dft tis2.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent      plane$PLANE.dft tis3.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent      plane$PLANE.dft tis4.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent      plane$PLANE.dft tis5.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent      plane$PLANE.dft tis6.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent      plane$PLANE.dft tis7.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent      plane$PLANE.dft tis8.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent      plane$PLANE.dft tis9.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  simframe plane$PLANE.dft frames.dat plane$PLANE'f.dft' F-18
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacren plane$PLANE'f.dft' 0 @_@_Pl00$PLANE
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  PLANE=2
  p2t_3c -nosub plasma.dat 0.20 0.05 0 0 0 0 tis1.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.20 0.20 0 0 0 0 tis2.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.20 0.80 0 0 0 0 tis3.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.20 0.05 0.002 0 0 0 tis4.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.20 0.20 0.002 0 0 0 tis5.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.20 0.80 0.002 0 0 0 tis6.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.20 0.05 0.01 0 0 0 tis7.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.20 0.20 0.01 0 0 0 tis8.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.20 0.80 0.01 0 0 0 tis9.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent -ovr plane$PLANE.dft tis1.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent      plane$PLANE.dft tis2.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent      plane$PLANE.dft tis3.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent      plane$PLANE.dft tis4.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent      plane$PLANE.dft tis5.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent      plane$PLANE.dft tis6.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent      plane$PLANE.dft tis7.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent      plane$PLANE.dft tis8.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent      plane$PLANE.dft tis9.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  simframe plane$PLANE.dft frames.dat plane$PLANE'f.dft' F-18
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacren plane$PLANE'f.dft' 0 @_@_Pl00$PLANE
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  PLANE=3
  p2t_3c -nosub plasma.dat 0.60 0.10 0.005 0 0 0 tis1.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.60 0.40 0.005 0 0 0 tis2.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.60 1.60 0.005 0 0 0 tis3.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.60 0.10 0.02 0 0 0 tis4.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.60 0.40 0.02 0 0 0 tis5.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.60 1.60 0.02 0 0 0 tis6.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.60 0.10 0.1 0 0 0 tis7.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.60 0.40 0.1 0 0 0 tis8.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.60 1.60 0.1 0 0 0 tis9.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent -ovr plane$PLANE.dft tis1.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent      plane$PLANE.dft tis2.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent      plane$PLANE.dft tis3.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent      plane$PLANE.dft tis4.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent      plane$PLANE.dft tis5.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent      plane$PLANE.dft tis6.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent      plane$PLANE.dft tis7.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent      plane$PLANE.dft tis8.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent      plane$PLANE.dft tis9.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  simframe plane$PLANE.dft frames.dat plane$PLANE'f.dft' F-18
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacren plane$PLANE'f.dft' 0 @_@_Pl00$PLANE
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  tacadd -ovr dynamic.dft plane1f.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd dynamic.dft plane2f.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd dynamic.dft plane3f.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacunit -yset=kBq/ml -xset=min dynamic.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  tacformat -mid -hdr=no -f=simple dynamic.dft dynamic.dat
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  tac2svg dynamic.svg -l dynamic.dft plasma.dat
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  printf "ok\n"
fi


printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n 1.0.0 \n"
printf " Test case: No command line options or arguments. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt
$PROGRAM &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Usage"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "See also"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.0.1 \n"
printf " Test case: Unknown option. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt
$PROGRAM -stupidoption plasma.dat dynamic.dft 0 0 output.res &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid option '-stupidoption'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.0.2 \n"
printf " Test case: Too many arguments. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt
$PROGRAM plasma.dat dynamic.dft 0 0 output.dft extra &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid argument 'extra'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.0.3 \n"
printf " Test case: Missing argument. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt
$PROGRAM plasma.dat dynamic.dft 0 0 &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n-----------------------------------------------------------------\n\n"


printf "\n 1.1.0 \n"
printf " Test case: Substrate concentration given with option -ca. \n"
printf " Expected result 1: Concentration is read correctly. \n"
printf " Expected result 2: Warning that default density and LC are used. \n\n"

rm -f stdout.txt
$PROGRAM -d2 -ca=5.2 plasma.dat dynamic.dft 0 0 output.res &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Ca" "5.2"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Warning "LC not set, using default 1"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Warning "tissue density not set, using default 1"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.1 \n"
printf " Test case: Invalid use of option -ca. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt
$PROGRAM -d2 -ca= plasma.dat dynamic.dft 0 0 output.res &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

rm -f stdout.txt
$PROGRAM -d2 -ca plasma.dat dynamic.dft 0 0 output.res &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n-----------------------------------------------------------------\n\n"


printf "\n 1.2.0 \n"
printf " Test case: Lumped constant given with option -lc. \n"
printf " Expected result: LC is read correctly. \n"

rm -f stdout.txt
$PROGRAM -d2 -Ca=5,2 -LC=0.82 plasma.dat dynamic.dft 0 0 output.res &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "LC" "0.82"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Ca" "5.2"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Warning "tissue density not set, using default 1"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.2.1 \n"
printf " Test case: Lumped constant given with option -lc, without -ca. \n"
printf " Expected result: Warning that LC will not ge used. \n\n"
rm -f stdout.txt
$PROGRAM -d2 -LC=0.82 plasma.dat dynamic.dft 0 0 output.res &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Warning "LC was set but is not used."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.2.2 \n"
printf " Test case: Invalid use of option -lc. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt
$PROGRAM -d2 -lc= plasma.dat dynamic.dft 0 0 output.res &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

rm -f stdout.txt
$PROGRAM -d2 -lc plasma.dat dynamic.dft 0 0 output.res &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n-----------------------------------------------------------------\n\n"


printf "\n 1.3.0 \n"
printf " Test case: Density given with option -density. \n"
printf " Expected result: Density is read correctly. \n"

rm -f stdout.txt
$PROGRAM -d2 -Ca=5.2 -density=1,06 plasma.dat dynamic.dft 0 0 output.res &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "density" "1.06"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Ca" "5.2"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Warning "LC not set, using default 1"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.3.1 \n"
printf " Test case: Density given with option, without -ca. \n"
printf " Expected result: Warning that density will not ge used. \n\n"
rm -f stdout.txt
$PROGRAM -d2 -density=1.02 plasma.dat dynamic.dft 0 0 output.res &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Warning "tissue density was set but is not used."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.3.2 \n"
printf " Test case: Invalid use of option -density. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt
$PROGRAM -d2 -density= plasma.dat dynamic.dft 0 0 output.res &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

rm -f stdout.txt
$PROGRAM -d2 -density plasma.dat dynamic.dft 0 0 output.res &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n===================================================================\n"
printf "   Data formats \n"
printf "===================================================================\n"


printf "\n 2.0.0 \n"
printf " Test case 1: Simple plasma data with some header information. \n"
printf " Test case 2: Tissue data with frame start and end times. \n"
printf " Expected result: Correct result. \n\n"

rm -f stdout.txt output.dft test_fur.dft

dftinteg --silent -avg dynamic.dft 40 20 mean_40_60.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
auc=$(interpol -i -x=50 -header=no plasma.dat)
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "AUC := %s\n" $auc
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
taccalc --silent mean_40_60.dft : $auc test_fur.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM plasma.dat dynamic.dft 40 60 output.dft &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.000001 -rel=0.1 -x=y -xunit=y -yunit=n test_fur.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.0.1 \n"
printf " Test case 1: Simple plasma data without any header information. \n"
printf " Test case 2: Tissue data with frame start and end times. \n"
printf " Expected result: Correct result. \n\n"

sed '/^#/ d' < plasma.dat > temp.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

rm -f stdout.txt output.dft

$PROGRAM temp.dat dynamic.dft 40 60 output.dft &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.000001 -rel=0.1 -x=y -xunit=y -yunit=y correct_fur_50.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 2.0.2 \n"
printf " Test case 1: Simple plasma data with some header information. \n"
printf " Test case 2: Tissue data with frame middle times. \n"
printf " Test case 3: Output in simple TAC format. \n"
printf " Expected result: Correct result. \n\n"

sed '/^#/ d' < dynamic.dat > temp.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

tacformat -mid -hdr=no -format=simple correct_fur_50.dft correct_fur_50.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
sed '/^#/ d' < correct_fur_50.dat > temp2.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi


rm -f stdout.txt output.dat

$PROGRAM plasma.dat temp.dat 40 60 output.dat &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.00001 -rel=0.5 -x=y -y=y -xunit=y -yunit=y temp2.dat output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 2.0.3 \n"
printf " Test case 1: Simple plasma data with some header information. \n"
printf " Test case 2: Tissue data in DFT format. \n"
printf " Test case 3: Output in CSV format. \n"
printf " Expected result: Correct result. \n\n"


rm -f stdout.txt output.csv

$PROGRAM plasma.dat dynamic.dft 40 60 output.csv &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.00001 -rel=0.5 -x=y -y=y -xunit=n -yunit=n correct_fur_50.dat output.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.0.4 \n"
printf " Test case 1: Simple plasma data with some header information. \n"
printf " Test case 2: Tissue data in DFT format. \n"
printf " Test case 3: Output in RES format. \n"
printf " Expected result: Correct result. \n\n"


rm -f stdout.txt output.res

$PROGRAM plasma.dat dynamic.dft 40 60 output.res &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
resmatch -abs=0.0001 -param=y -regions=n -errors=n correct_fur_50.res output.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n===================================================================\n"
printf "   Data units \n"
printf "===================================================================\n"


printf "\n 3.0.0 \n"
printf " Test case: MR is calculated. \n"
printf " Expected result: Correct result. \n\n"

rm -f output.dft output2.dft

$PROGRAM plasma.dat dynamic.dft 40 60 output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
# taccalc output.dft x 750 correct_mr_50.dft

$PROGRAM --silent -Ca=6.3 -LC=0.8 -density=1.05 -curve=fur2.dft plasma.dat dynamic.dft 40 60 output2.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.00001 -rel=0.5 -x=y -y=y -xunit=y -yunit=y correct_mr_50.dft output2.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n-------------------------------------------------------------\n\n"

printf "\n 3.1.0 \n"
printf " Test case: TTAC in Bq/cc, PTAC in kBq/ml. \n"
printf " Expected result: Correct result. \n\n"

rm -f output.dft
cp -f dynamic.dft temp.dft
tacunit -yconv=Bq/cc temp.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM plasma.dat temp.dft 40 60 output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.000001 -rel=0.1 -x=y -xunit=y -yunit=y correct_fur_50.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 3.1.1 \n"
printf " Test case: TTAC in kBq/ml, PTAC in Bq/ml. \n"
printf " Expected result: Correct result. \n\n"

rm -f output.dft
cp -f plasma.dat temp.dat
tacunit -yconv=Bq/cc temp.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM temp.dat dynamic.dft 40 60 output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.000001 -rel=0.1 -x=y -xunit=y -yunit=y correct_fur_50.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n-------------------------------------------------------------\n\n"

printf "\n 3.2.0 \n"
printf " Test case: TTAC in sec, PTAC in min. \n"
printf " Expected result: Correct result. \n\n"

rm -f output.dft
cp -f dynamic.dft temp.dft
tacunit -xconv=sec temp.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM plasma.dat temp.dft 40 60 output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.000001 -rel=0.1 -x=y -xunit=y -yunit=y correct_fur_50.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 3.2.1 \n"
printf " Test case: TTAC in min, PTAC in sec. \n"
printf " Expected result: Correct result. \n\n"

rm -f output.dft
cp -f plasma.dat temp.dat
tacunit -xconv=sec temp.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM temp.dat dynamic.dft 40 60 output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.000001 -rel=0.1 -x=y -xunit=y -yunit=y correct_fur_50.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"
printf "   Playing with times \n"
printf "===================================================================\n"


printf "\n 4.0.0 \n"
printf " Test case: Option -it=time. \n"
printf " Expected result: Correct result. \n\n"

rm -f stdout.txt output.dft

$PROGRAM -it=40 plasma.dat dynamic.dft 40 60 output.dft &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.000001 -rel=0.1 -x=y -xunit=y -yunit=y correct_fur_50b.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n-------------------------------------------------------------\n\n"

printf "\n 4.1.0 \n"
printf " Test case: User enters the same start and end time. \n"
printf " Expected result: Correct result. \n\n"

rm -f stdout.txt output.dft
# dftinteg --silent -avg dynamic.dft 59.5 1 mean_60.dft
# taccalc --silent mean_60.dft : 548.5 correct_fur_60.dft

$PROGRAM -curve=fur3.dft plasma.dat dynamic.dft 60 60 output.dft &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.000001 -rel=0.1 -x=y -xunit=y -yunit=y correct_fur_60.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n-------------------------------------------------------------\n\n"

printf "\n 4.2.0 \n"
printf " Test case: TTAC does not extend to the calculation range. \n"
printf " Expected result: Error. \n\n"

rm -f short.dft stdout.txt output.dft
taccut dynamic.dft 0 30 short.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM plasma.dat short.dft 40 60 output.dft &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ -f output.dft ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "integration time range oversteps data range."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 4.2.1 \n"
printf " Test case: PTAC does not extend to the calculation range. \n"
printf " Expected result: Error. \n\n"

rm -f short.dat stdout.txt output.dft
taccut plasma.dat 0 15 short.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM -curve=fur4.dft short.dat dynamic.dft 40 60 output.dft &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ -f output.dft ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error (1)" "integration time range oversteps data range"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 4.2.2 \n"
printf " Test case: PTAC and TTAC do not extend to the calculation range. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt output.dft

$PROGRAM -curve=fur5.dft short.dat short.dft 40 60 output.dft &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ -f output.dft ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "integration time range oversteps data range."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n-------------------------------------------------------------\n\n"

printf "\n 4.3.0 \n"
printf " Test case: FUR from static data, user gives zeroes as time range. \n"
printf " Expected result: Correct result. \n\n"

rm -f output.dft
dftinteg --silent -avg dynamic.dft 40 20 mean_40_60.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

$PROGRAM -curve=fur6.dft plasma.dat mean_40_60.dft 0 0 output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.000001 -rel=0.1 -x=y -xunit=y -yunit=y correct_fur_50.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 4.3.1 \n"
printf " Test case: FUR from static data, user gives mid time as time range. \n"
printf " Expected result: Error. \n\n"

rm -f output.dft
$PROGRAM -curve=fur6.dft plasma.dat mean_40_60.dft 50 50 output.dft
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 4.3.2 \n"
printf " Test case: FUR from static data, user gives correct time range. \n"
printf " Expected result: Correct result. \n\n"

rm -f output.dft
$PROGRAM -curve=fur6.dft plasma.dat mean_40_60.dft 40 60 output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.000001 -rel=0.1 -x=y -xunit=y -yunit=y correct_fur_50.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 4.3.3 \n"
printf " Test case: FUR from static data, user gives a bit wider time range. \n"
printf " Expected result: Error. \n\n"

rm -f output.dft
$PROGRAM -curve=fur6.dft plasma.dat mean_40_60.dft 35 70 output.dft
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 4.3.4 \n"
printf " Test case: FUR from static data, containing only frame mid time. \n"
printf " Expected result: Correct result. \n\n"

rm -f output.dft

tacformat -mid -hdr=no -format=DFT mean_40_60.dft mean_40_60.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM -curve=fur7.dft plasma.dat mean_40_60.dat 0 00 output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.000001 -rel=0.1 -x=n -xunit=y -yunit=y correct_fur_50.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

