#!/bin/bash
#: Title      : test_ecat2nii
#: Date       : 2016-11-30
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../ecat2nii$EXT;
echo ""
echo ===============================================================================
echo "testing "$PROGRAM
echo ===============================================================================
echo ""
if [ -f image2.i ]; then
echo "Test data seems to exist, thus not created now."
else 
echo ===============================================================================
echo "creating test data"
echo ===============================================================================
echo ""

asc2flat image1.dat image1.bin
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
flat2img -scanner=HRRT -inf=image1.inf image1.bin image1.v
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
eframe image1.v image1.fra
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
imgdecay -i=C-11 image1.v
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
esetstrt image1.v 2013-03-23 15:22:02
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
img2tif -rb image1.v image1.tif
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi

asc2flat image2.dat image2.bin
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
flat2img -scanner=HR+ -inf=image2.inf image2.bin image2.v
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
eframe image2.v image2.fra
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
imgdecay -i=F-18 image2.v
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
esetstrt image2.v 2013-03-23 15:21:59
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
img2tif -rb image2.v image2.tif
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
e7to63 image2.v image2.img
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi

flat2img -scanner=HR+ -inf=image2.inf image2.bin image2.i
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
eframe image2.i image2.fra
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
imgdecay -i=F-18 image2.i
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
esetstrt image2.i 2006-06-20 12:01:59

fi
echo ===============================================================================
echo ""
echo ===============================================================================
echo "1.1.1: No command line options or arguments. Error with user info."
if [ -f stdout.txt ] ; then rm stdout.txt ; fi
$PROGRAM &> stdout.txt
if [ $? -eq 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed.
iftisval stdout.txt "See also"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
iftisval stdout.txt "Keywords"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed. ; echo ""
echo ===============================================================================
echo "1.1.2: Unknown option."
if [ -f stderr.txt ] ; then rm stderr.txt ; fi
$PROGRAM -stupidoption image1.v 2> stderr.txt
if [ $? -eq 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed.
iftisval stderr.txt Error "invalid option '-stupidoption'"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed. ; echo ""
echo ===============================================================================
echo "1.1.3: Extra argument."
echo "       NOT APPLICABLE"
echo ===============================================================================
echo ""
echo ===============================================================================
echo "1.2.1: option -h print user info"
if [ -f stdout.txt ] ; then rm stdout.txt ; fi
$PROGRAM -h > stdout.txt
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed.
iftisval stdout.txt "See also"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
iftisval stdout.txt "Keywords"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed. ; echo ""
echo ===============================================================================
echo "1.2.2: option --help print user info"
if [ -f stdout.txt ] ; then rm stdout.txt ; fi
$PROGRAM --help > stdout.txt
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed.
iftisval stdout.txt "See also"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
iftisval stdout.txt "Keywords"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed. ; echo ""
echo ===============================================================================
echo ""
echo ===============================================================================
echo "1.5.1: option -dual; without it"
if [ -f stdout.txt ] ; then rm stdout.txt ; fi
if [ -f image1.nii ] ; then rm image1.nii ; fi
$PROGRAM -d2 image1.v > stdout.txt
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed.
iftisval stdout.txt fileformat "1S"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed. ; echo ""
if [ -f image1.nii ] ; then rm image1.nii; else echo Failed!; exit 1 ; fi
echo passed. ; echo ""
echo ===============================================================================
echo "1.5.2: option -dual; with it"
if [ -f stdout.txt ] ; then rm stdout.txt ; fi
if [ -f image1.hdr ] ; then rm image1.hdr ; fi
if [ -f image1.img ] ; then rm image1.img ; fi
$PROGRAM -d2 -dual image1.v > stdout.txt
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed.
iftisval stdout.txt fileformat "1D"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed. ; echo ""
if [ -f image1.hdr ] ; then rm image1.hdr; else echo Failed!; exit 1 ; fi
if [ -f image1.img ] ; then rm image1.img; else echo Failed!; exit 1 ; fi
echo passed. ; echo ""
echo ===============================================================================
echo ""
echo ===============================================================================
echo "1.6.1: option -big and -little; options not implemented yet"
echo ===============================================================================
echo ""
echo ===============================================================================
echo "1.7.1: option -o; without it"
if [ -f stdout.txt ] ; then rm stdout.txt ; fi
$PROGRAM -d2 image1.v > stdout.txt
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed.
iftisval stdout.txt outputdir ""
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed. ; echo ""
echo ===============================================================================
echo "1.7.2: option -o; with it"
if [ -f stdout.txt ] ; then rm stdout.txt ; fi
$PROGRAM -d2 -o=newdir image1.v > stdout.txt
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed.
iftisval stdout.txt outputdir "newdir"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed. ; echo ""
if [ -f newdir/image1.nii ] ; then rm newdir/image1.nii; else echo Failed!; exit 1 ; fi
echo passed. ; echo ""
echo ===============================================================================
echo "1.7.3: option -o= without path"
if [ -f temp.v ] ; then rm temp.v ; fi
cp -f image1.v temp.v
if [ -f temp.hdr ] ; then rm temp.hdr ; fi
if [ -f temp.img ] ; then rm temp.img ; fi
if [ -f stdout.txt ] ; then rm stdout.txt ; fi
$PROGRAM -d2 -dual -o= temp.v > stdout.txt
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed.
iftisval stdout.txt outputdir "."
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed. ; echo ""
if [ -f temp.hdr ] ; then rm temp.hdr; else echo Failed!; exit 1 ; fi
if [ -f temp.img ] ; then rm temp.img; else echo Failed!; exit 1 ; fi
echo passed. ; echo ""
echo ===============================================================================
echo "1.7.4: Check that original ECAT6 file is not overwritten by dual NIfTI"
if [ -f stdout.txt ] ; then rm stdout.txt ; fi
if [ -f stderr.txt ] ; then rm stderr.txt ; fi
if [ -f temp.img ] ; then rm temp.img ; fi
if [ -f temp.hdr ] ; then rm temp.hdr ; fi
if [ -f temp2.v ] ; then rm temp2.v ; fi
if [ -f temp2.img ] ; then rm temp2.img ; fi
if [ -f temp2.hdr ] ; then rm temp2.hdr ; fi
e7to63 image1.v temp.img
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
cp -f image1.v temp2.v
$PROGRAM -d2 -dual -o= temp.img temp2.v > stdout.txt 2> stderr.txt
if [ $? -eq 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed.
iftisval stderr.txt Error "./temp.img would be overwritten."
if [ $? -ne 0 ] ; then 
  iftisval stderr.txt Error ".\temp.img would be overwritten."
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi
printf "\n Passed. \n\n"
echo "check that next file was still processed ok"
if [ -f temp2.hdr ] ; then rm temp2.hdr; else echo Failed!; exit 1 ; fi
if [ -f temp2.img ] ; then rm temp2.img; else echo Failed!; exit 1 ; fi
echo passed. ; echo ""
echo ===============================================================================
echo "1.7.5: Output path and NIfTI files exist: overwritten"
if [ -f temp.img ] ; then rm temp.img ; fi
if [ -f temp.v ] ; then rm temp.v ; fi
e7to63 image1.v temp.img
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
cp -f image2.v temp.v
rm -f temp/* temp2/*
rmdir temp temp2
echo passed. ; echo ""

$PROGRAM -d3 -dual -o=temp -sif temp.img
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed. ; echo ""
# cti2sif temp.img temp/temp.sif
# cif [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
# echo passed. ; echo ""
nii2ecat -d2 -o=temp2 temp/temp
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed. ; echo ""
imgmatch -abs=0.1 -rel=1 image1.v temp2/temp.v
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed. ; echo ""

echo Trying also with Ecat7
echo ""
$PROGRAM -d6 -dual -o=temp -sif temp.v
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed. ; echo ""
# cti2sif temp.v temp/temp.sif
# if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
# echo passed. ; echo ""
nii2ecat -d2 -o=temp2 temp/temp
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed. ; echo ""
imgmatch -abs=0.1 -rel=1 image2.v temp2/temp.v
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed. ; echo ""
echo ===============================================================================
echo "1.7.6: ECAT63 can be converted in place without options"
rm -f temp/*
e7to63 image1.v temp/temp.img
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
cd temp
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
../$PROGRAM temp.img
if [ $? -ne 0 ] ; then echo Failed! ; cd ..; exit 1 ; fi
cd ..
if [ -f temp/temp.nii ] ; then rm temp/temp.nii; else echo Failed!; exit 1 ; fi
rm -f temp/*
echo passed. ; echo ""
echo ===============================================================================
echo ""
echo ===============================================================================
echo "2.1.1: Input file name not given"
if [ -f stderr.txt ] ; then rm stderr.txt ; fi
$PROGRAM -d2 -o=temp 2> stderr.txt
if [ $? -eq 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed.
iftisval stderr.txt Error "no ECAT files were specified."
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed. ; echo ""
echo ===============================================================================
echo "2.2.1: non-existing input file"
if [ -f stderr.txt ] ; then rm stderr.txt ; fi
$PROGRAM -d2 nonexisting.v 2> stderr.txt
if [ $? -eq 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed.
iftisval stderr.txt Error "file nonexisting.v does not exist"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed. ; echo ""
echo ===============================================================================
echo "2.3.1: format not ECAT image"
if [ -f stderr.txt ] ; then rm stderr.txt ; fi
$PROGRAM -d2 image1.bin 2> stderr.txt
if [ $? -eq 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed.;
iftisval stderr.txt Error "unsupported file type"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed.; echo ""

if [ -f stderr.txt ] ; then rm stderr.txt ; fi
$PROGRAM -d2 image1.dat 2> stderr.txt
if [ $? -eq 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed.;
iftisval stderr.txt Error "unsupported file type"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed.; echo ""
echo ===============================================================================
echo "2.3.2: ECAT 7 3D: ok"
rm -f temp/* temp2/*
rmdir temp temp2
$PROGRAM -d2 -o=temp -sif image2.v 2> stderr.txt
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed.;
nii2ecat -o=temp2 temp/image2
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed. ; echo ""
imgmatch -abs=0.1 -rel=1 image2.v temp2/image2.v
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed. ; echo ""
echo ===============================================================================
echo "2.3.3: ECAT 7 2D: ok"
if [ -f stderr.txt ] ; then rm stderr.txt ; fi
rm -f temp/* temp2/*
rmdir temp temp2
$PROGRAM -d2 -o=temp -sif image2.i 2> stderr.txt
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed.;
nii2ecat -o=temp2 temp/image2
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed. ; echo ""
imgmatch -abs=0.1 -rel=1 image2.i temp2/image2.v
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed. ; echo ""
echo ===============================================================================
echo "2.3.4: ECAT 6.3: ok"
if [ -f stderr.txt ] ; then rm stderr.txt ; fi
rm -f temp/* temp2/*
rmdir temp temp2
e7to63 image2.v image2.img
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
$PROGRAM -d2 -o=temp -sif image2.img 2> stderr.txt
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed.;
nii2ecat -o=temp2 temp/image2
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed. ; echo ""
imgmatch -abs=0.1 -rel=1 image2.v temp2/image2.v
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed. ; echo ""
echo ===============================================================================
echo "2.4.1: ECAT file contains discontinuous frame or plane numbers"
if [ -f stderr.txt ] ; then rm stderr.txt ; fi
if [ -f temp.img ] ; then rm temp.img ; fi
rm -f temp/* temp2/*
rmdir temp temp2
e7to63 image2.v image2.img
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
esplit image2.img 2 3-4 temp.img
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
$PROGRAM -d2 -o=temp -sif temp.img 2> stderr.txt
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed.;
nii2ecat -o=temp2 temp/temp
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed. ; echo ""
imgmatch -frames=n -planes=n -abs=0.1 -rel=1 temp.img temp2/temp.v
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed. ; echo ""
echo ===============================================================================
echo "2.5.1: More than one ECAT files as command-line arguments"
echo "dual file format"
if [ -f stderr.txt ] ; then rm stderr.txt ; fi
rm -f temp/* temp2/*
rmdir temp temp2
$PROGRAM -d2 -dual -o=temp image1.v image2.v 2> stderr.txt
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed.;
if [ -f temp/image1.hdr ] ; then rm temp/image1.hdr; else echo Failed!; exit 1 ; fi
if [ -f temp/image1.img ] ; then rm temp/image1.img; else echo Failed!; exit 1 ; fi
if [ -f temp/image2.hdr ] ; then rm temp/image2.hdr; else echo Failed!; exit 1 ; fi
if [ -f temp/image2.img ] ; then rm temp/image2.img; else echo Failed!; exit 1 ; fi
echo passed. ; echo ""
echo "single file format"
if [ -f stderr.txt ] ; then rm stderr.txt ; fi
rm -f temp/* temp2/*
rmdir temp temp2
$PROGRAM -d2 -o=temp image1.v image2.v 2> stderr.txt
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed.;
if [ -f temp/image1.nii ] ; then rm temp/image1.nii; else echo Failed!; exit 1 ; fi
if [ -f temp/image2.nii ] ; then rm temp/image2.nii; else echo Failed!; exit 1 ; fi
echo passed. ; echo ""
echo ===============================================================================
echo "2.5.2: More than one ECAT files given with wildcards"
if [ -f stderr.txt ] ; then rm stderr.txt ; fi
rm -d2 temp/* temp2/*
rmdir temp temp2
$PROGRAM -d2 -dual -o=temp image?.v 2> stderr.txt
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed.;
if [ -f temp/image1.hdr ] ; then rm temp/image1.hdr; else echo Failed!; exit 1 ; fi
if [ -f temp/image1.img ] ; then rm temp/image1.img; else echo Failed!; exit 1 ; fi
if [ -f temp/image2.hdr ] ; then rm temp/image2.hdr; else echo Failed!; exit 1 ; fi
if [ -f temp/image2.img ] ; then rm temp/image2.img; else echo Failed!; exit 1 ; fi
echo passed. ; echo ""
echo ===============================================================================
echo "2.5.3: More than one ECAT files, one leads to error, others ok"
if [ -f stderr.txt ] ; then rm stderr.txt ; fi
rm -f temp/* temp2/*
rmdir temp temp2
if [ -f temp.v ] ; then rm temp.v ; fi
cp -f image2.bin temp.v
$PROGRAM -d2 -o=temp image1.v temp.v image2.v 2> stderr.txt
if [ $? -eq 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed.;
iftisval stderr.txt Error "unsupported file type"
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
echo passed.; echo ""
if [ -f temp/image1.nii ] ; then rm temp/image1.nii; else echo Failed!; exit 1 ; fi
if [ -f temp/image2.nii ] ; then rm temp/image2.nii; else echo Failed!; exit 1 ; fi
echo passed. ; echo ""
echo ===============================================================================
echo ""
echo ===============================================================================
echo "3.1.1: Validation of image flipping"
echo "NOT APPLIED"
echo ===============================================================================
echo "3.2.1: Byte order is set correctly"
echo "NOT APPLIED"
echo ===============================================================================
echo ===============================================================================
echo "3.3.1: Quantitation is preserved after conversion from"
echo "       ECAT 6.3 to Analyze and back"
echo "Tested already in 2.3.4"
echo ===============================================================================
echo "3.3.2: Quantitation is preserved after conversion from"
echo "       ECAT 7 to Analyze and back"
echo "Tested already in 2.3.2 and 2.3.3"


#exit 0
echo ""
echo ===============================================================================
echo ""
echo "All passed!"
echo ""
echo ===============================================================================
exit 0
