#!/bin/bash
#: Title      : test_dftdblf
#: Date       : 2019-12-20
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the exit status of a pipeline to the exit status of failed, not the last command in the pipeline
set -o pipefail

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi

PROGRAM=../../dftdblf$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"

if [ ! -f test.dft ] || [ ! -f frame.sif ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f true_output1.dft ] || [ ! -f true_output2.dft ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi

if [ ! -f testf.dft ]; then
  printf "\n make testf.dft \n"
  cp -f test.dft testf.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacframe testf.dft frame.sif
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n"
fi


printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n 1.0.0 \n"
printf " Test case 1: Normal use with default settings. \n"
printf " Test case 2: Input file contains only frame mid times. \n"
printf " Expected result: Output TAC file with correct contents is made. \n\n"

rm -f output1.dft

$PROGRAM test.dft output1.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.0001 -rel=0.0001 -x=y -y=y -xunit=y -yunit=y true_output1.dft output1.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.0 \n"
printf " Test case 1: Input file contains frame start and end times. \n"
printf " Test case 2: Option -mid is used to use frame mid times. \n"
printf " Expected result: Output TAC file with correct contents is made. \n\n"

rm -f output11.dft

$PROGRAM -mid testf.dft output11.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.0001 -rel=0.0001 -x=y -y=y -xunit=y -yunit=y true_output1.dft output11.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.2.0 \n"
printf " Test case 1: Input file contains frame start and end times. \n"
printf " Test case 2: Option -mid is NOT used. \n"
printf " Expected result: Output TAC file with correct contents is made. \n\n"

rm -f output12.dft

$PROGRAM testf.dft output12.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.0001 -rel=0.0001 -x=y -y=y -xunit=y -yunit=y true_output2.dft output12.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

