#!/bin/bash
#: Title      : test_tac2svg
#: Date       : 2020-05-25
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi

PROGRAM=../../tac2svg$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi



printf "\n verifying that required data exists \n"


if [ ! -f test001.dat ] || [ ! -f test002.dat ] || [ ! -f test003.dat ] || [ ! -f test004.dat ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f test011.dat ] || [ ! -f test012.dat ] || [ ! -f test013.dat ] || [ ! -f test014.dat ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f test015.dat ] || [ ! -f test021.dat ] || [ ! -f test022.dat ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f test023.dat ] || [ ! -f test031.dat ] || [ ! -f test032.dat ] || [ ! -f test041.dat ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f test042.dat ] || [ ! -f test043.dat ] || [ ! -f test044.dat ] || [ ! -f test045.dat ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f test046.dat ] || [ ! -f test047.dat ] || [ ! -f test048.dat ] || [ ! -f test_notitle.dat ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f test100.dat ] || [ ! -f test101.dat ] || [ ! -f test102.dat ] || [ ! -f test200.dat ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f test300.dat ] || [ ! -f test300b.dat ] || [ ! -f test400.dat ] || [ ! -f test400b.dat ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi




printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

$PROGRAM -legend=a -mt="Main title set by user" test001.svg test001.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM -legend=a -xt="x axis title set by user" test002.svg test002.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM -legend=a -yt="y axis title set by user" test003.svg test003.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM -legend=a test004.svg test004.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM -legend=a test011.svg test011.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM -legend=a test012.svg test012.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM -legend=a test013.svg test013.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM -legend=a test014.svg test014.dat
echo Next one should give an error of insufficient data
printf "\n ok \n"
$PROGRAM -x1=0 -y1=0 -x2=1 -y2=1 test014b.svg test014.dat
if [ $? -eq 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM -legend=a test015.svg test015.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM -legend=a test021.svg test021.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM -legend=a test022.svg test022.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM -legend=a test023.svg test023.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM -legend=a test031.svg test031.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM -legend=a test032.svg test032.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM -legend=a test041.svg test041.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM -legend=a test042.svg test042.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM -legend=a test043.svg test043.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM -legend=a test044.svg test044.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM -legend=a test045.svg test045.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM -legend=a test046.svg test046.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM -legend=a test047.svg test047.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM -legend=a test048.svg test048.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM -legend=a -color test100.svg test100.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM -legend=a test100b.svg -s test100.dat -l test100.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM -legend=a test101.svg test101.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM -legend=a test102.svg test102.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM -legend=a -y1=-90 -y2=25 test200.svg test200.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM -legend=a -x1=25 -x2=357 test200b.svg test200.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM -legend=a test300.svg -s test300.dat -l test300b.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM -legend=a test400.svg test400.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM -legend=a test400b.svg test400.dat test400b.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"


$PROGRAM -bw -legend=y test100black-and-white.svg test100.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"




$PROGRAM -mt="Main title set by user" test001.xhtml test001.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM -xt="x axis title set by user" test002.xhtml test002.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM -yt="y axis title set by user" test003.xhtml test003.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM test004.xhtml test004.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM test011.xhtml test011.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM test012.xhtml test012.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM test013.xhtml test013.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM test014.xhtml test014.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM test015.xhtml test015.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM test021.xhtml test021.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM test022.xhtml test022.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM test023.xhtml test023.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM test031.xhtml test031.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM test032.xhtml test032.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM test041.xhtml test041.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM test042.xhtml test042.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM test043.xhtml test043.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM test044.xhtml test044.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM test045.xhtml test045.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM test046.xhtml test046.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM test047.xhtml test047.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM test048.xhtml test048.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM test100.xhtml test100.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM test101.xhtml test101.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM test102.xhtml test102.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM -y1=-90 -y2=25 test200.xhtml test200.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM -x1=25 -x2=357 test200b.xhtml test200.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM test300.xhtml -s test300.dat -l test300b.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM -legend=y test400.xhtml test400.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM -x1=0 -y1=0 test015_range1.svg test015.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM -x1=0 -y2=2 test015_range2.svg test015.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM test_notitle.svg test_notitle.dat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"


printf "=====================================================================\n"
printf "  All passed if plots look file\n"
printf "=====================================================================\n"
exit 0
