#!/bin/bash
#: Title      : test_tactime
#: Date       : 2014-08-21
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../tactime$EXT;

printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n0.1.0 Unknown option \n\n"

rm -f stdout.txt output.dft
$PROGRAM -stupidoption -decay -i=C-11 c11.dft +20.4 output.dft &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid option '-stupidoption'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n===================================================================\n"

printf "\n0.2.0 Extra argument \n\n"

rm -f stdout.txt output.dft
$PROGRAM -decay -i=C-11 c11.dft +20.4 output.dft extra &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid argument 'extra'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n===================================================================\n"

printf "\n0.3.0 Missing input filename \n\n"

rm -f stdout.txt output.dft
$PROGRAM -decay -i=C-11 +20.4 output.dft &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "file '+20.4' does not exist."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n0.3.1 Nonexisting input file \n\n"

rm -f stdout.txt output.dft
$PROGRAM -decay -i=C-11 nonexisting.dft +20.4 output.dft &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "file 'nonexisting.dft' does not exist."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n0.3.2 Wrong format input file \n\n"

rm -f stdout.txt output.dft
$PROGRAM -decay -i=C-11 $PROGRAM +20.4 output.dft &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error in reading '$PROGRAM'" "unknown file format"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n0.3.3 Missing time \n\n"

rm -f stdout.txt output.dft
$PROGRAM -decay -i=C-11 c11.dft output.dft &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid argument for time: 'output.dft'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n0.3.4 Time file does not exist \n\n"

rm -f stdout.txt output.dft
$PROGRAM -decay -i=C-11 c11.dft nonexistingfile.ift output.dft &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid argument for time: 'nonexistingfile.ift'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n0.3.5 Time file in wrong format \n\n"

rm -f stdout.txt output.dft
$PROGRAM -decay -i=C-11 c11.dft $PROGRAM output.dft &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid argument for time: '$PROGRAM'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n0.3.6 Time is ok, also with decimal comma \n\n"

rm -f stdout.txt output.dft
$PROGRAM -d1 -decay -i=C-11 c11.dft -30.5 output.dft &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt time_diff "-30.5"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f stdout.txt output.dft
$PROGRAM -d1 -decay -i=C-11 c11.dft 11,5 output.dft &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt time_diff "11.5"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n===================================================================\n"

printf "\n0.4.0 Missing output filename \n\n"

rm -f stdout.txt output.dft
$PROGRAM -decay -i=C-11 c11.dft +20.4  &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "undefined output file name."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n===================================================================\n"

printf "\n0.5.0 Invalid isotope code as option \n\n"

rm -f stdout.txt output.dft
$PROGRAM -decay -i=Hiili c11.dft +20.4 output.dft &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid isotope 'HIILI'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n0.5.1 Invalid isotope code in the file \n\n"

cp -f c11.dft c11_with_invalid_isotope.dft
printf "\n# isotope := Hiili\n" >> c11_with_invalid_isotope.dft
rm -f stdout.txt output.dft
$PROGRAM -decay c11_with_invalid_isotope.dft +20.4 output.dft &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid isotope 'Hiili' in 'c11_with_invalid_isotope.dft'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n0.5.2 Isotope missing in both file and as an option \n\n"

rm -f stdout.txt output.dft
$PROGRAM -decay c11.dft +20.4 output.dft &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "isotope not specified."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n0.5.3 Different isotope in input file and in option \n\n"
rm -f stdout.txt output.dft
$PROGRAM -decay -i=F-18 c11_with_isotope.dft +20.4 output.dft &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid isotope in 'c11_with_isotope.dft' or in command line."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"

printf "\n1.0.0 Correct result with i=C-11 \n\n"

rm -f stdout.txt output.dft
$PROGRAM -d1 -decay -i=C-11 c11.dft +20.4 output.dft &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Isotope "C-11"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.05 -rel=1 correct_c11_late.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n1.0.1 Correct result with i=F-18 \n\n"

rm -f stdout.txt output.dft
$PROGRAM -d1 -decay -i=F-18 f18.dft 109.8 output.dft &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Isotope "F-18"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.05 -rel=1 correct_f18_late.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n1.0.1 Correct result with i=O-15 \n\n"

rm -f stdout.txt output.dft
$PROGRAM -d1 -decay -i=O-15 o15.dft 123 output.dft &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Isotope "O-15"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.05 -rel=1 correct_o15_late.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n===================================================================\n"

printf "\n1.1.0 Correct result with C-11 in input file \n\n"

rm -f stdout.txt output.dft
$PROGRAM -d1 -decay c11_with_isotope.dft +20.4 output.dft &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Isotope "C-11"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.05 -rel=1 correct_c11_late.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n1.1.1 Correct result with F-18 in input file \n\n"

rm -f stdout.txt output.dft
$PROGRAM -d1 -decay f18_with_isotope.dft 109.8 output.dft &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Isotope "F-18"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.05 -rel=1 correct_f18_late.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n1.1.1 Correct result with O-15 in input file \n\n"

rm -f stdout.txt output.dft
$PROGRAM -d1 -decay o15_with_isotope.dft 123 output.dft &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Isotope "O-15"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.05 -rel=1 correct_o15_late.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n===================================================================\n"

printf "\n2.0.0 Change times 60 s forward, not changing decay correction. \n\n"

rm -f output.kbq
$PROGRAM o15blood.kbq 60 output.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.05 -rel=1 correct_o15blood_forw.kbq output.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n2.0.1 Change times 60 s backward, not changing decay correction. \n\n"

rm -f output2.kbq
$PROGRAM output.kbq -60 output2.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.05 -rel=1 o15blood.kbq output2.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n2.1.0 Change times is zero. \n\n"

rm -f stdout.txt output.kbq
$PROGRAM o15blood.kbq 0 output.kbq &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.05 -rel=1 o15blood.kbq output.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Warning" "time change is zero."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n2.1.0 Time changes are given in a file \n\n"
printf "\n      scan_start_time_difference, positive time, \n"
printf "\n      not including time unit \n\n"

rm -f test.dit output.dft
printf "\nscan_start_time_difference := 20.4\n" > test.dit
$PROGRAM -decay -i=C-11 c11.dft test.dit output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.05 -rel=1 correct_c11_late.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n2.1.1 Time changes are given in a file \n\n"
printf "\n      scan_start_time_difference, negative time, \n"
printf "\n      including time unit \n\n"

rm -f test.dit output2.dft
printf "\ntime_difference := -20,4 [min]\n" > test.dit
$PROGRAM -decay -i=C-11 output.dft test.dit output2.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.05 -rel=1 c11.dft output2.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n2.1.2 Time changes are given in a file \n\n"
printf "\n      scan_start_time_difference is zero, \n"
printf "\n      including time unit \n\n"

rm -f test.dit output.dft stdout.txt
printf "\nscan_start_time_difference := 0.0 [min]\n" > test.dit
$PROGRAM -decay -i=C-11 c11.dft test.dit output.dft &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.05 -rel=1 c11.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Warning" "time change is zero."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n2.2.0 start_time given in file, without unit \n\n"

rm -f test.dit temp.dft temp2.dft
printf "\nstart_time := 20.4\n" > test.dit
$PROGRAM c11.dft 20.4 temp.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM temp.dft test.dit temp2.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.05 -rel=1 c11.dft temp2.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n2.2.1 Ta given in file, without unit \n\n"

rm -f test.dit temp2.dft
printf "\nTa := 20.4\n" > test.dit
$PROGRAM temp.dft test.dit temp2.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.05 -rel=1 c11.dft temp2.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"


printf "\n3.0.0 Option -nogap prevents initial gap \n\n"
printf "\n      with frame start and end times\n\n"

rm -f output.dft
$PROGRAM -decay -i=C-11 -nogap c11.dft 20,4 output.dft 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.05 -rel=1 correct_c11_late_nogap.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n3.0.1 Option -nogap prevents initial gap \n\n"
printf "\n      with frame middle times\n\n"

rm -f output.kbq
$PROGRAM -nogap o15blood.kbq 60 output.kbq 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.05 -rel=1 correct_o15blood_forw_nogap.kbq output.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"


printf "\n4.0.0 Correction for decay and sample times \n\n"

cp -f c11.dft c11_sec.dft
cp -f correct_c11_late.dft correct_c11_late_sec.dft
tacunit -xconv=sec c11_sec.dft correct_c11_late_sec.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

rm -f output.dft
$PROGRAM -decay -i=C-11 c11_sec.dft 1224 output.dft 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.05 -rel=1 correct_c11_late_sec.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n4.0.1 Change times 1 half-life backward, changing also decay correction \n\n"

rm -f output.dft output2.dft
$PROGRAM -decay -i=C    c11.dft    +20.4 output.dft 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM -decay -i=C-11 output.dft -20.4 output2.dft 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.05 -rel=1 c11.dft output2.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n4.1.0 Option -keeptimes should not be used without -decay, \n"
printf "      because otherwise nothing would actually be done  \n\n"

rm -f output.dft stdout.txt
$PROGRAM -keeptimes -i=C-11 c11.dft 20.4 output.dft &> stdout.txt 
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "change in neither sample times or decay correction were requested."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n4.1.1 Change decay but not times 1 half-life forward \n"
printf "      Check also that injection_time is changed accordingly  \n\n"

rm -f output.dft stdout.txt
iftlist c11_with_injtime.dft
$PROGRAM -keeptimes -decay c11_with_injtime.dft +20.4 output.dft 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=no -y=yes -abs=0.05 -rel=1 correct_c11_late.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=yes -y=no -abs=0.05 -rel=1 c11.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.dft injection_time "2005-12-21 11:34:31"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n4.1.2 Change decay but not times 1 half-life backward \n"
printf "      Check also that injection_time is changed accordingly  \n\n"

rm -f output2.dft stdout.txt
iftlist output.dft
$PROGRAM -keeptimes -decay output.dft -20.4 output2.dft 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=yes -y=yes -abs=0.05 -rel=1 c11.dft output2.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output2.dft injection_time "2005-12-21 11:54:55"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n4.2.1 Change times 60 s backward, then again 60 s forward, \n"
printf "      not changing decay correction. With option -keepnegat, the result \n"
printf "      is the as the original data. \n\n"

rm -f output.kbq output2.kbq
$PROGRAM -keepnegat o15blood.kbq -60 output.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM -keepnegat output.kbq   +60 output2.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.05 -rel=1 output.kbq output2.kbq
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.05 -rel=1 o15blood.kbq output2.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n4.2.2 Change times 60 s backward, then again 60 s forward, \n"
printf "      not changing decay correction. Without option -keepnegat, \n"
printf "      the first 60 s is lost. \n\n"

rm -f output.kbq output2.kbq
$PROGRAM o15blood.kbq -60 output.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.05 -rel=1 correct_o15blood_pre.kbq output.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM output.kbq   +60 output2.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.05 -rel=1 correct_o15blood_corr.kbq output2.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

