#!/bin/bash
#: Title      : test_upet2e7
#: Date       : 2017-02-13
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../upet2e7$EXT;

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

if [ ! -f image.txt ]; then
  rm -f correct.v P100001.pet.img P100001.pet.img.hdr
  printf "# Plane 1 Frame 1 \n" > image.txt
  printf "# Plane 2 Frame 1 \n" >> image.txt
  printf "# Plane 3 Frame 1 \n" >> image.txt
  printf "# Plane 1 Frame 2 \n" >> image.txt
  printf "# Plane 2 Frame 2 \n" >> image.txt
  printf "# Plane 3 Frame 2 \n" >> image.txt

  printf "0 1 0 0 \n" >> image.txt
  printf "1 2 3 1 \n" >> image.txt
  printf "0 3 4 0 \n" >> image.txt
  printf "0 0 1 0 \n" >> image.txt

  printf "0 2 3 0 \n" >> image.txt
  printf "1 3 4 2 \n" >> image.txt
  printf "2 4 5 1 \n" >> image.txt
  printf "0 3 2 0 \n" >> image.txt

  printf "0 0 1 0 \n" >> image.txt
  printf "1 6 4 1 \n" >> image.txt
  printf "1 1 3 1 \n" >> image.txt
  printf "0 0 0 0 \n" >> image.txt

  printf "0 2 0 0 \n" >> image.txt
  printf "2 3 4 2 \n" >> image.txt
  printf "1 3 4 2 \n" >> image.txt
  printf "0 1 2 0 \n" >> image.txt

  printf "1 2 3 0 \n" >> image.txt
  printf "3 3 5 3 \n" >> image.txt
  printf "4 8 7 2 \n" >> image.txt
  printf "0 4 2 0 \n" >> image.txt

  printf "2 4 5 1 \n" >> image.txt
  printf "1 7 3 4 \n" >> image.txt
  printf "1 7 9 5 \n" >> image.txt
  printf "0 1 0 0 \n" >> image.txt
fi

if [ ! -f P100001.pet.img ] || [ ! -f P100001.pet.img.hdr ]; then
  asc2flat image.txt image.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  bigend
  if [ $? -ne 0 ] ; then 
    convend float image.bin P100001.pet.img
  else
    cp -f image.bin P100001.pet.img
  fi
  
  printf "# Header file for data file pet.img\n" > P100001.pet.img.hdr

  printf "# Version of header parameters (float)\n" >> P100001.pet.img.hdr
  printf "version 002.000\n" >> P100001.pet.img.hdr
  
  printf "# Scanner model number (integer)\n" >> P100001.pet.img.hdr
  printf "model 5001\n" >> P100001.pet.img.hdr

  printf "# Acquisition scanner modality (integer)\n" >> P100001.pet.img.hdr
  printf "modality 0\n" >> P100001.pet.img.hdr

  printf "# Scanner modality configuration number (integer)\n" >> P100001.pet.img.hdr
  printf "modality_configuration 5500\n" >> P100001.pet.img.hdr

  printf "# Institution identification (string)\n" >> P100001.pet.img.hdr
  printf "institution Turku PET Centre\n" >> P100001.pet.img.hdr

  printf "# Study type/description (string)\n" >> P100001.pet.img.hdr
  printf "study P100001\n" >> P100001.pet.img.hdr

  printf "# Data filename, possibly including path (string)\n" >> P100001.pet.img.hdr
  printf "file_name P100001.pet.img\n" >> P100001.pet.img.hdr

  printf "# Data file type (integer)\n" >> P100001.pet.img.hdr
  printf "file_type 5\n" >> P100001.pet.img.hdr

  printf "# Acquisition mode (integer)\n" >> P100001.pet.img.hdr
  printf "acquisition_mode 3\n" >> P100001.pet.img.hdr

  printf "# Number of frames in data file (integer)\n" >> P100001.pet.img.hdr
  printf "total_frames 2\n" >> P100001.pet.img.hdr
  printf "# Number of time frames in data file (integer)\n" >> P100001.pet.img.hdr
  printf "time_frames 2\n" >> P100001.pet.img.hdr

  printf "# Axial plane size, in cm (float)\n" >> P100001.pet.img.hdr
  printf "axial_plane_size 0.0796\n" >> P100001.pet.img.hdr

  printf "# Data type (integer)\n" >> P100001.pet.img.hdr
  printf "data_type 4\n" >> P100001.pet.img.hdr

  printf "number_of_dimensions 3\n" >> P100001.pet.img.hdr
  printf "x_dimension 4\n" >> P100001.pet.img.hdr
  printf "y_dimension 4\n" >> P100001.pet.img.hdr
  printf "z_dimension 3\n" >> P100001.pet.img.hdr

  printf "# Scan start date and time (string)\n" >> P100001.pet.img.hdr
  printf "scan_time Thu Oct 20 15:02:18 2016\n" >> P100001.pet.img.hdr

  printf "# Zoom applied to data set (float)\n" >> P100001.pet.img.hdr
  printf "zoom 1\n" >> P100001.pet.img.hdr

  printf "# Reconstructed pixel size, in cm (float)\n" >> P100001.pet.img.hdr
  printf "pixel_size 0.0776383\n" >> P100001.pet.img.hdr
  printf "pixel_size_x 0.776383\n" >> P100001.pet.img.hdr
  printf "pixel_size_y 0.776383\n" >> P100001.pet.img.hdr
  printf "pixel_size_z 0.796\n" >> P100001.pet.img.hdr

  printf "# Calibration units (integer)\n" >> P100001.pet.img.hdr
  printf "calibration_units 2\n" >> P100001.pet.img.hdr

  printf "# Calibration factor (float)\n" >> P100001.pet.img.hdr
  printf "calibration_factor 1.82015e+008\n" >> P100001.pet.img.hdr

  printf "# Isotope description (string)\n" >> P100001.pet.img.hdr
  printf "isotope F-18\n" >> P100001.pet.img.hdr
  printf "# Isotope half-life, in secs (float)\n" >> P100001.pet.img.hdr
  printf "isotope_half_life 6586.2\n" >> P100001.pet.img.hdr
  printf "# Isotope branching fraction (float)\n" >> P100001.pet.img.hdr
  printf "#   NOTE: Frame scale factor DOES NOT include\n" >> P100001.pet.img.hdr
  printf "#         isotope branching fraction.\n" >> P100001.pet.img.hdr
  printf "isotope_branching_fraction 0.967\n" >> P100001.pet.img.hdr

  printf "# Injection date and time (string)\n" >> P100001.pet.img.hdr
  printf "injection_time Thu Oct 20 15:03:00 2016\n" >> P100001.pet.img.hdr

  printf "# End of Header indicator \n" >> P100001.pet.img.hdr
  printf "end_of_header\n" >> P100001.pet.img.hdr

  printf "# Header for frame 0, detector_panel -1, event_type 4, energy_window -1, gate 0, bed 0.\n" >> P100001.pet.img.hdr
  printf "# Frame number (integer)\n" >> P100001.pet.img.hdr
  printf "frame 0\n" >> P100001.pet.img.hdr
  printf "# Data file offset to start of data (2 32-bit ints)\n" >> P100001.pet.img.hdr
  printf "data_file_pointer 0 0\n" >> P100001.pet.img.hdr
  printf "# Frame start time, in secs (float)\n" >> P100001.pet.img.hdr
  printf "frame_start 0\n" >> P100001.pet.img.hdr
  printf "# Frame duration, in secs (float)\n" >> P100001.pet.img.hdr
  printf "frame_duration 12\n" >> P100001.pet.img.hdr
  printf "# Scale factor for data set (float)\n" >> P100001.pet.img.hdr
  printf "scale_factor 0.0833333\n" >> P100001.pet.img.hdr
  printf "# Deadtime correction for data set (float)\n" >> P100001.pet.img.hdr
  printf "deadtime_correction 1\n" >> P100001.pet.img.hdr
  printf "# Global decay correction applied to data set (float)\n" >> P100001.pet.img.hdr
  printf "decay_correction 1.00063\n" >> P100001.pet.img.hdr
  printf "# Prompts count for data set (64-bit ints)\n" >> P100001.pet.img.hdr
  printf "prompts 4322083   62199   4374048\n" >> P100001.pet.img.hdr
  printf "# Delays count for data set (64-bit ints)\n" >> P100001.pet.img.hdr
  printf "delays 127874   52453   179786\n" >> P100001.pet.img.hdr
  printf "# Trues count for data set (64-bit ints)\n" >> P100001.pet.img.hdr
  printf "trues 4194209   9746   4194262\n" >> P100001.pet.img.hdr
  printf "# End of Header indicator \n" >> P100001.pet.img.hdr
  printf "end_of_header\n" >> P100001.pet.img.hdr

  printf "frame 1\n" >> P100001.pet.img.hdr
  printf "# 4*dimx*dimy*dimz*frame = 4*4*4*3*1=192\n" >> P100001.pet.img.hdr
  printf "data_file_pointer 0 192\n" >> P100001.pet.img.hdr
  printf "frame_start 12\n" >> P100001.pet.img.hdr
  printf "frame_duration 12\n" >> P100001.pet.img.hdr
  printf "scale_factor 0.0833333\n" >> P100001.pet.img.hdr
  printf "deadtime_correction 1.02299\n" >> P100001.pet.img.hdr
  printf "decay_correction 1.0019\n" >> P100001.pet.img.hdr
  printf "prompts 5361849   89618   5451480\n" >> P100001.pet.img.hdr
  printf "delays 184735   75963   260125\n" >> P100001.pet.img.hdr
  printf "trues 5177114   13655   5191355\n" >> P100001.pet.img.hdr
  printf "end_of_header\n" >> P100001.pet.img.hdr
  
fi

if [ ! -f correct.sif ]; then
  printf "20/10/2016 15:02:18 2 4 1 P100001 F-18\n" > correct.sif
  printf "0 12 0 0\n" >> correct.sif
  printf "12 24 0 0\n" >> correct.sif
fi

if [ ! -f correct.v ]; then
  flat2img -zoom=1 image.bin correct.v 3 2 4 4
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgcalc correct.v x 0.0833333 temp.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgcalc temp.v x 1.82015e+008 temp2.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgunit -u=Bq/cc temp2.v
  imgcalc temp2.v : 0.967 correct.v 
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  eframe correct.v correct.sif
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi


printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"




printf "\n 1.0.0 \n"
printf " Test case 1: Make ECAT7 image. \n"
printf " Test case 2: Base filename given. \n"
printf " Expected result: Correct image created. \n\n"

rm -f output.v
$PROGRAM P100001.pet output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.1 -rel=1 correct.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "passed.\n\n"



printf "\n 1.0.1 \n"
printf " Test case 1: Make ECAT7 image. \n"
printf " Test case 2: Header filename given. \n"
printf " Expected result: Correct image created. \n\n"

rm -f output.v
$PROGRAM P100001.pet.img.hdr output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.1 -rel=1 correct.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "passed.\n\n"


printf "\n 1.0.2 \n"
printf " Test case 1: Make ECAT7 image. \n"
printf " Test case 2: Image filename given. \n"
printf " Expected result: Correct image created. \n\n"

rm -f output.v
$PROGRAM P100001.pet.img output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.1 -rel=1 correct.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "passed.\n\n"






printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0


