#!/bin/bash
#: Title      : test_upet2sif
#: Date       : 2017-02-12
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../upet2sif$EXT;

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

if [ ! -f P107079.pet.img.hdr ] || [ ! -f correct.sif ]; then
  printf "Failed: test data do not exist.\n"
  exit 1
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"




printf "\n 1.0.0 \n"
printf " Test case 1: Make SIF from header file. \n"
printf " Test case 2: Header filename given. \n"
printf " Expected result: Correct SIF created. \n\n"

rm -f output.sif
$PROGRAM P107079.pet.img.hdr output.sif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

tacmatch -abs=0.0001 correct.sif output.sif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.1 \n"
printf " Test case 1: Make SIF from header file. \n"
printf " Test case 2: Filename given wo extension. \n"
printf " Expected result: Correct SIF created. \n\n"

rm -f output.sif
$PROGRAM P107079.pet output.sif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

tacmatch -abs=0.0001 correct.sif output.sif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"






printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0


