#!/bin/bash
#: Title      : test_abssfch
#: Date       : 2016-12-09
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi

PROGRAM=../../abssfch$EXT;

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

if [ ! -f ../data/us1328.bld ] || [ ! -f ../data/ep0152_blo.lis ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f ../data/t00061.alg ] || [ ! -f ../data/ME_ABSS09282_is731dy1.txt ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f ../data/us1321.bld ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi


printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"



printf "\n 1.0.0 \n"
printf " Test case: Calculate channel ratio from GEMS file. \n"
printf " Expected result 1: Original file not modified. \n"
printf " Expected result 2: Correct results printed. \n\n"

rm -f stdout.txt
cp -f ../data/us1328.bld test.bld

$PROGRAM test.bld > stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

tacmatch -abs=0.05 ../data/us1328.bld test.bld
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval -abs=0.001 stdout.txt Ch1/Ch2 1.007048
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.0.1 \n"
printf " Test case: Calculate channel ratio from Scanditronics file. \n"
printf " Expected result 1: Original file not modified. \n"
printf " Expected result 2: Correct results printed. \n\n"

rm -f stdout.txt
cp -f ../data/ep0152_blo.lis test_blo.lis

$PROGRAM test_blo.lis > stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

tacmatch -abs=0.05 ../data/ep0152_blo.lis test_blo.lis
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval -abs=0.001 stdout.txt Ch1/Ch2 0.797
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "=====================================================================\n"

printf "\n 1.1.0 \n"
printf " Test case: Fix dead channel in GEMS file. \n"
printf " Expected result 1: Original file not modified with option -o. \n"
printf " Expected result 2: Correct results saved. \n\n"

rm -f stdout.txt output.bld
cp -f ../data/us1321.bld test.bld

$PROGRAM -o=output.bld test.bld 1.081
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

tacmatch -abs=0.05 ../data/us1321.bld test.bld
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM output.bld > stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.002 stdout.txt Ch1/Ch2 1.081
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.1 \n"
printf " Test case: Fix dead channel in GEMS file. \n"
printf " Expected result 1: Original file modified. \n"
printf " Expected result 2: Correct results saved. \n\n"

rm -f stdout.txt output.bld
cp -f ../data/us1321.bld test.bld

$PROGRAM test.bld 0.9867
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

tacmatch -abs=0.01 ../data/us1321.bld test.bld
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM test.bld > stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.002 stdout.txt Ch1/Ch2 0.9867
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "=====================================================================\n"


printf "\n 1.2.0 \n"
printf " Test case: Fix dead channel in GEMS file. \n"
printf " Expected result 1: Dead channel is specified with -fix. \n"
printf " Expected result 2: Correct results saved. \n\n"

rm -f stdout.txt output.bld
cp -f ../data/us1321.bld test.bld

$PROGRAM -fix=1 test.bld 0.9867
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM test.bld > stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.002 stdout.txt Ch1/Ch2 0.9867
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.2.1 \n"
printf " Test case 1: Fix dead channel in GEMS file. \n"
printf " Test case 2: Wrong channel is specified with -fix. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt output.bld
cp -f ../data/us1321.bld test.bld

$PROGRAM -fix=2 test.bld 0.9867 &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "channel1 cannot be used to fix channel2."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "=====================================================================\n"


printf "\n 2.0.0 \n"
printf " Test case: Invalid option. \n"
printf " Expected result: Error. \n\n"

cp -f ../data/us1321.bld test.bld
rm -f stdout.txt

$PROGRAM -stupidoption test.bld &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid option '-stupidoption'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.0.1 \n"
printf " Test case: Extra argument. \n"
printf " Expected result: Error. \n\n"

cp -f ../data/us1321.bld test.bld
rm -f stdout.txt

$PROGRAM test.bld 1.10 extra &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "invalid argument 'extra'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.0.2 \n"
printf " Test case: Missing argument. \n"
printf " Expected result: Error. \n\n"

cp -f ../data/us1321.bld test.bld
rm -f stdout.txt

$PROGRAM -fix=2 test.bld &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "missing channel ratio."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.1.0 \n"
printf " Test case: Input file does not exist. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt
$PROGRAM nonexistingfile.dat &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "cannot open file"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 2.1.1 \n"
printf " Test case: Allogg format cannot be processed. \n"
printf " Expected result: Error. \n\n"

cp -f ../data/t00061.alg test.bld
rm -f stdout.txt

$PROGRAM test.bld &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "not applicable to provided ABSS system."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


cp -f ../data/ME_ABSS09282_is731dy1.txt test.bld
rm -f stdout.txt

$PROGRAM test.bld &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "not applicable to provided ABSS system."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

