#!/bin/bash
#: Title      : test_csvtrps
#: Date       : 2020-06-17
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../csvtrps$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for  %s\n" $PROGRAM
printf "=====================================================================\n"


if [ ! -f test1.csv ]; then
  printf "parameters,1,2,3,4\n"        > test1.csv
  printf "put_dx,1.0,2.0,3.0,4.0\n"   >> test1.csv
  printf "cau_dx,2.0,3.0,4.0,5.0\n"   >> test1.csv
  printf "put_sin,3.0,4.0,5.0,6.0\n"  >> test1.csv
  printf "cau_sin,4.0,5.0,6.0,7.0\n"  >> test1.csv
  printf "cereb,1.0,1.0,0.0,0.0\n"    >> test1.csv
fi

if [ ! -f test2.csv ]; then
  printf "parameters,put_dx,cau_dx,put_sin,cau_sin,cereb\n" > test2.csv
  printf "1,1.0,2.0,3.0,4.0,1.0\n"  >> test2.csv
  printf "2,2.0,3.0,4.0,5.0,1.0\n"  >> test2.csv
  printf "3,3.0,4.0,5.0,6.0,0.0\n"  >> test2.csv
  printf "4,4.0,5.0,6.0,7.0,0.0\n"  >> test2.csv
fi




printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n 1.0.0 \n"
printf " Test case: Transpose parameter file, and then transform that back. \n"
printf " Expected result: Correct CSVs saved. \n"

rm -f output.csv

$PROGRAM test1.csv output.csv
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
# cat output.csv
tacmatch test2.csv output.csv
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

$PROGRAM output.csv
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
# cat output.csv
parmatch test1.csv output.csv
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "=====================================================================\n"
printf "  All passed!\n"
printf "=====================================================================\n"
exit 0
