#!/bin/bash
#: Title      : test_dcmlhdr
#: Date       : 2019-05-02
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi

PROGRAM=../../dcmlhdr$EXT;


printf "\n====================================================================\n"
printf "verifying that required data exists for %s\n" $PROGRAM
printf "====================================================================\n"


if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

DCMFILE=../dicom/f170.dcm
if [ ! -f $DCMFILE ]; then
  printf "Failed: test file does not exist.\n"
  exit 1
fi

DCMFILE2=../dicom/Siemens_mMR.dcm
if [ ! -f $DCMFILE2 ]; then
  printf "Failed: test file does not exist.\n"
  exit 1
fi


printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n 1.0.0 \n"
printf " Test case: List DICOM header contents with default settings. \n"
printf " Expected result: Contents are listed. \n\n"

rm -f output.ift

$PROGRAM $DCMFILE > output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift "(0008,0080) Institution Name" "Turku PET Centre"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift "(0008,0022) Acquisition Date" "20161020"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f output2.ift

$PROGRAM $DCMFILE2 > output2.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output2.ift "(0008,0080) Institution Name" "Washington University"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output2.ift "(0008,0022) Acquisition Date" "20120620"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.0 \n"
printf " Test case: Option -tag=n to not list tags. \n"
printf " Expected result: Contents are listed without tags. \n\n"

rm -f output.ift

$PROGRAM -tag=n $DCMFILE > output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift "Institution Name" "Turku PET Centre"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift "Acquisition Date" "20161020"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.2.0 \n"
printf " Test case: Specific tag is listed. \n"
printf " Expected result: Required contents are listed. \n\n"

rm -f output.ift

$PROGRAM -group=0054 -element=1001 -tag=n $DCMFILE > output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift "Positron Emission Tomography Units" "BQML"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


rm -f output2.ift

$PROGRAM -group=0054 -element=1001 -tag=n $DCMFILE2 > output2.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output2.ift "Positron Emission Tomography Units" "BQML"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

