#!/bin/bash
#: Title      : test_rmcmnts
#: Date       : 2016-11-25
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi

PROGRAM=../../rmcmnts$EXT;

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

if [ ! -f nocomments.dat ]; then
  printf "line1 : value1\n"  > nocomments.dat
  printf "line2 : value2\n" >> nocomments.dat
  printf "line3 : value3\n" >> nocomments.dat
  printf "line4 : value4\n" >> nocomments.dat
fi

if [ ! -f comments.dat ]; then
  printf "# line1 : value1\n"  > comments.dat
  printf "line2 : value2\n"   >> comments.dat
  printf "; line3 : value3\n" >> comments.dat
  printf "line4 : value4\n"   >> comments.dat
fi


printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n 1.0.0 \n"
printf " Test case: Default settings, two files in one run. \n"
printf " Expected result: Correct results saved. \n\n"

cp -f nocomments.dat file1.ift
cp -f comments.dat file2.ift

$PROGRAM file?.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftmatch nocomments.dat file1.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval file2.ift line1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval file2.ift "; line3"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval file2.ift line2
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval file2.ift line4
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.1.0 \n"
printf " Test case: Remove all comment lines. \n"
printf " Expected result: Correct results saved. \n\n"

cp -f nocomments.dat file1.ift
cp -f comments.dat file2.ift

$PROGRAM -sharp=y -semicolon=y file?.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftmatch nocomments.dat file1.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval file2.ift line1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval file2.ift "; line3"
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval file2.ift line2
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval file2.ift line4
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

