#!/bin/bash
#: Title      : test_fit_disp
#: Date       : 2019-08-19
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None
#: ToDo       : Test options

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi

PROGRAM=../../fit_disp$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"
if [ ! -f rvlv1.tac ] || [ ! -f rvlv2.tac ]; then
  printf "Failed: required test data do not exist.\n"
  exit 1
fi

printf "\n creating data for testing \n"

if [ ! -f step.tac ] || [ ! -f step_dispersed5.tac ] || [ ! -f step_dispersed15.tac ]; then
  printf "time[seconds]\tstep[Bq/cc]\n"  > temp.tac
  printf "0.0\t0.0\n"  >> temp.tac
  printf "10.0\t0.0\n"  >> temp.tac
  printf "10.0\t100000.0\n"  >> temp.tac
  printf "40.0\t100000.0\n"  >> temp.tac
  printf "40.0\t0.0\n"  >> temp.tac
  printf "600.0\t0.0\n"  >> temp.tac

  rm -f step_dispersed5_delayed10.tac step_dispersed15_delayed20.tac

  interpol -c=0,180,1 temp.tac step.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  disp4dft ON step.tac 5 step_dispersed5.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  disp4dft ON step.tac 15 step_dispersed15.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f step_dispersed5_delayed10.tac ] || [ ! -f step_dispersed15_delayed20.tac ]; then
  tactime -nogap step_dispersed5.tac 10 step_dispersed5_delayed10.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tactime -nogap step_dispersed15.tac 20 step_dispersed15_delayed20.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi


printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n 1.0.0 \n"
printf " Test case: Test with simulated data with dispersion but no delay. \n"
printf " Expected result: Reasonable results. \n\n"

rm -f output1.svg output1.par output1.ift
$PROGRAM -svg=output1.svg step.tac step_dispersed5.tac output1.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f output1.svg ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

parformat -f=ift output1.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.05 output1.ift tau 5
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.05 output1.ift delay 0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


rm -f output2.svg output2.par output2.ift
$PROGRAM -svg=output2.svg step.tac step_dispersed15.tac output2.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f output2.svg ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

parformat -f=ift output2.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.05 output2.ift tau 15
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.05 output2.ift delay 0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.1.0 \n"
printf " Test case: Test with simulated data with dispersion and delay. \n"
printf " Expected result: Reasonable results. \n\n"

rm -f output1.svg output1.par output1.ift
$PROGRAM -svg=output1.svg step.tac step_dispersed5_delayed10.tac output1.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f output1.svg ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

parformat -f=ift output1.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.05 output1.ift tau 5
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.05 output1.ift delay 10
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


rm -f output2.svg output2.par output2.ift
$PROGRAM -svg=output2.svg step.tac step_dispersed15_delayed20.tac output2.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f output2.svg ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

parformat -f=ift output2.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.05 output2.ift tau 15
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.05 output2.ift delay 20
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"

printf "\n 2.0.0 \n"
printf " Test case: Real data from RV and LV cavity in radiowater PET. \n"
printf " Expected result: No errors. \n\n"

tacsplit --force -name=tacid rvlv1.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

rm -f rvlv1.svg rvlv1.par rvlv1.ift
$PROGRAM -svg=rvlv1.svg RV.tac LV.tac rvlv1.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f rvlv1.svg ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

parformat -f=ift rvlv1.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=2 rvlv1.ift tau 8
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=2 rvlv1.ift delay 4
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



tacsplit --force -name=tacid rvlv2.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

rm -f rvlv2.svg rvlv2.par rvlv2.ift
$PROGRAM -svg=rvlv2.svg RV.tac LV.tac rvlv2.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f rvlv2.svg ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

parformat -f=ift rvlv2.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=2 rvlv2.ift tau 5
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=2 rvlv2.ift delay 4
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

