#!/bin/bash
#: Title      : test_fit_wrlv
#: Date       : 2019-10-03
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi

PROGRAM=../../fit_wrlv$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"
if [ ! -f radiowater_rv.fit ] || [ ! -f wframes.sif ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f rvlv1.tac ] || [ ! -f rvlv2.tac ]; then
  printf "Failed: required test data do not exist.\n"
  exit 1
fi

printf "\n creating data for testing \n"

if [ ! -f simrvlv.tac ] || [ ! -f simrvlv.svg ]; then
  fit2dat -c=0,420,1 radiowater_rv.fit rv.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  simframe rv.tac wframes.sif rvf.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  disp4dft ON rv.tac 8 disp.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tactime -nogap disp.tac +5 lv.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacren lv.tac 1 LV
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  simframe lv.tac wframes.sif lvf.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd -ovr simrvlv.tac rvf.tac lvf.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tac2svg -mt="Simulated RV and LV cavity BTACs" -legend=y simrvlv.svg simrvlv.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi


printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"



printf "\n 1.0.0 \n"
printf " Test case: Test with simulated data. \n"
printf " Expected result: Resulting parameters reasonably close to true ones. \n\n"

rm -f output.svg output.par output.ift
$PROGRAM -svg=output.svg simrvlv.tac output.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f output.svg ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

parformat -f=ift output.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval output.ift tac_name RV
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval output.ift tac_name LV
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval -abs=2 output.ift Ta 35
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=2 output.ift Ti 20
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=5 output.ift A1 50
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.001 output.ift L1 0.001
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=10 output.ift A2 300
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.005 output.ift L2 0.05
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=1 output.ift dT 5
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=1.5 output.ift tau 8
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.1 \n"
printf " Test case: Weighted fit of simulated data. \n"
printf " Expected result: Resulting parameters reasonably close to true ones. \n\n"

rm -f output.svg output.par output.ift
$PROGRAM -wf -svg=outputw.svg simrvlv.tac output.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f outputw.svg ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

parformat -f=ift output.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval output.ift tac_name RV
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval output.ift tac_name LV
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval -abs=2 output.ift Ta 35
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=5 output.ift Ti 20
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=10 output.ift A1 50
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.002 output.ift L1 0.001
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=100 output.ift A2 300
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.03 output.ift L2 0.05
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=2 output.ift dT 5
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=3 output.ift tau 8
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n 2.0.0 \n"
printf " Test case 1: Test with real data. \n"
printf " Test case 2: Parameters saved in FIT format. \n"
printf " Expected result: Simulated BTACs are reasonably close to the original. \n\n"

rm -f output1.svg output1.fit output1.tac
$PROGRAM rvlv1.tac output1.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

fit2dat -a=420 output1.fit output1.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg output1.svg -s rvlv1.tac -l output1.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

fit2dat -f=rvlv1.tac output1.fit output1.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=12000 -rel=15 rvlv1.tac output1.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n 2.0.1 \n"
printf " Test case: Test with another real data. \n"
printf " Expected result: Simulated BTACs are reasonably close to the original. \n\n"

rm -f output2.svg output2.fit output2.tac
$PROGRAM rvlv2.tac output2.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

fit2dat -a=420 output2.fit output2.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg output2.svg -s rvlv2.tac -l output2.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

fit2dat -f=rvlv2.tac output2.fit output2.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=10000 -rel=20 rvlv2.tac output2.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

