/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpcabss.h"
/*****************************************************************************/

/*****************************************************************************/
int test_abssIdFromFName(
  int verbose
) {
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  ABSS_DEVICE id;

  if(verbose>1) printf("empty string\n");
  id=abssIdFromFName("");
  if(id!=ABSS_UNKNOWN) return(11);

  if(verbose>1) printf("too short string\n");
  id=abssIdFromFName("a.b");
  if(id!=ABSS_UNKNOWN) return(12);

  if(verbose>1) printf("unknown extension\n");
  id=abssIdFromFName("blaa.exe");
  if(id!=ABSS_UNKNOWN) return(13);

  if(verbose>1) printf("known extensions\n");
  id=abssIdFromFName("blaa.lis");
  if(id!=ABSS_SCANDITRONICS) return(21);
  id=abssIdFromFName("blaa.bld");
  if(id!=ABSS_GEMS) return(22);
  id=abssIdFromFName("blaa.alg");
  if(id!=ABSS_ALLOGG_OLD) return(23);
  id=abssIdFromFName("blaa.txt");
  if(id!=ABSS_ALLOGG) return(24);

  if(verbose>1) printf("including path\n");
  id=abssIdFromFName("/s/data/blaa.lis");
  if(id!=ABSS_SCANDITRONICS) return(31);
  id=abssIdFromFName("S:\\data\blaa.alg");
  if(id!=ABSS_ALLOGG_OLD) return(32);

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_abssWrite(
  int verbose
) {
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int ret;
  FILE *fp=NULL;
  TPCSTATUS status; statusInit(&status);
  statusSet(&status, __func__, __FILE__, __LINE__, TPCERROR_OK);
  status.verbose=verbose-3;


  if(verbose>1) printf("NULL input should fail\n");
  ret=abssWrite(NULL, NULL, NULL);
  if(ret==TPCERROR_OK) {return 1;}


  if(verbose>1) 
    printf("\nRead, write, and re-read ABSS files and compare contents:\n");

  char filename1[256], filename2[256];

  if(verbose>1) printf("\nScanditronics ABSS\n");
  {
  strcpy(filename1, "tcal040511_blo.lis");
  TAC tac1; tacInit(&tac1);
  if(verbose>2) printf("reading %s\n", filename1);
  ret=tacRead(&tac1, filename1, &status);
  if(ret!=TPCERROR_OK) {return(101);}
  if(tac1.format!=TAC_FORMAT_ABSS_SCANDITRONICS) {tacFree(&tac1); return(102);}
  strcpy(filename2, "output_blo.lis");
  if(verbose>2) printf("writing %s\n", filename2);
  fp=fopen(filename2, "w");
  ret=abssWrite(&tac1, fp, &status); fclose(fp);
  if(ret!=TPCERROR_OK) {tacFree(&tac1); return(103);}
  TAC tac2; tacInit(&tac2);
  if(verbose>2) printf("reading %s\n", filename2);
  ret=tacRead(&tac2, filename2, &status);
  if(ret!=TPCERROR_OK) {
    fprintf(stderr, "Error: %s\n", errorMsg(status.error));
    tacFree(&tac1); tacFree(&tac2); return(104);
  }
  if(tac2.format!=TAC_FORMAT_ABSS_SCANDITRONICS) {
    tacFree(&tac1); tacFree(&tac2); return(105);}
  if(verbose>2) printf("comparing\n");
  ret=tacCompareConc(&tac1, &tac2, -1, 1.0E-06, 1.0E-03, &status);
  if(ret==0) ret=tacCompareTimes(&tac1, &tac2, 1.0E-06, 1.0E-03, &status);
  if(ret==0) ret=tacCompareNames(&tac1, &tac2, -1, &status);
  if(ret!=0) {tacFree(&tac1); tacFree(&tac2); return(106);}
  tacFree(&tac1); tacFree(&tac2);
  }

  if(verbose>1) printf("\nGEMS ABSS\n");
  {
  strcpy(filename1, "ua2019.bld");
  TAC tac1; tacInit(&tac1);
  if(verbose>2) printf("reading %s\n", filename1);
  ret=tacRead(&tac1, filename1, &status);
  if(ret!=TPCERROR_OK) {return(201);}
  if(tac1.format!=TAC_FORMAT_ABSS_GEMS) {tacFree(&tac1); return(202);}
  strcpy(filename2, "output.bld");
  if(verbose>2) printf("writing %s\n", filename2);
  fp=fopen(filename2, "w");
  ret=abssWrite(&tac1, fp, &status); fclose(fp);
  if(ret!=TPCERROR_OK) {tacFree(&tac1); return(203);}
  TAC tac2; tacInit(&tac2);
  if(verbose>2) printf("reading %s\n", filename2);
  ret=tacRead(&tac2, filename2, &status);
  if(ret!=TPCERROR_OK) {
    fprintf(stderr, "Error: %s\n", errorMsg(status.error));
    tacFree(&tac1); tacFree(&tac2); return(204);
  }
  if(tac2.format!=TAC_FORMAT_ABSS_GEMS) {
    tacFree(&tac1); tacFree(&tac2); return(205);}
  if(verbose>2) printf("comparing\n");
  ret=tacCompareConc(&tac1, &tac2, -1, 1.0E-06, 1.0E-03, &status);
  if(ret==0) ret=tacCompareTimes(&tac1, &tac2, 1.0E-06, 1.0E-03, &status);
  if(ret==0) ret=tacCompareNames(&tac1, &tac2, -1, &status);
  if(ret!=0) {tacFree(&tac1); tacFree(&tac2); return(206);}
  tacFree(&tac1); tacFree(&tac2);
  }

  if(verbose>1) printf("\nGEMS ABSS with date but no time in header\n");
  {
  strcpy(filename1, "ua2019_wotime.bld");
  TAC tac1; tacInit(&tac1);
  if(verbose>2) printf("reading %s\n", filename1);
  ret=tacRead(&tac1, filename1, &status);
  if(ret!=TPCERROR_OK) {return(211);}
  if(tac1.format!=TAC_FORMAT_ABSS_GEMS) {tacFree(&tac1); return(212);}
  strcpy(filename2, "output_wotime.bld");
  if(verbose>2) printf("writing %s\n", filename2);
  fp=fopen(filename2, "w");
  ret=abssWrite(&tac1, fp, &status); fclose(fp);
  if(ret!=TPCERROR_OK) {tacFree(&tac1); return(213);}
  TAC tac2; tacInit(&tac2);
  if(verbose>2) printf("reading %s\n", filename2);
  ret=tacRead(&tac2, filename2, &status);
  if(ret!=TPCERROR_OK) {
    fprintf(stderr, "Error: %s\n", errorMsg(status.error));
    tacFree(&tac1); tacFree(&tac2); return(214);
  }
  if(tac2.format!=TAC_FORMAT_ABSS_GEMS) {
    tacFree(&tac1); tacFree(&tac2); return(215);}
  if(verbose>2) printf("comparing\n");
  ret=tacCompareConc(&tac1, &tac2, -1, 1.0E-06, 1.0E-03, &status);
  if(ret==0) ret=tacCompareTimes(&tac1, &tac2, 1.0E-06, 1.0E-03, &status);
  if(ret==0) ret=tacCompareNames(&tac1, &tac2, -1, &status);
  if(ret!=0) {tacFree(&tac1); tacFree(&tac2); return(216);}
  tacFree(&tac1); tacFree(&tac2);
  }

  if(verbose>1) printf("\nGEMS ABSS without header lines\n");
  {
  strcpy(filename1, "ua0273.bld");
  TAC tac1; tacInit(&tac1);
  if(verbose>2) printf("reading %s\n", filename1);
  ret=tacRead(&tac1, filename1, &status);
  if(ret==TPCERROR_OK) {
    if(verbose>0) {printf("  format=%d\n", tac1.format); fflush(stdout);}
    if(tac1.format==TAC_FORMAT_ABSS_GEMS || 
       tac1.format==TAC_FORMAT_ABSS_SCANDITRONICS)
    {
      tacFree(&tac1); return(221);
    }
  } else {
    if(verbose>1) {
      fflush(stdout);
      fprintf(stderr, "we should see error...\n");
      fprintf(stderr, "Error: %s\n", errorMsg(status.error));
      fflush(stderr);
    }
  }
  tacFree(&tac1);
  }



  if(verbose>1) {printf("\nAllogg1 ABSS\n"); fflush(stdout);}
  {
  strcpy(filename1, "t00061.alg");
  TAC tac1; tacInit(&tac1);
  if(verbose>2) {printf("reading %s\n", filename1); fflush(stdout);}
  ret=tacRead(&tac1, filename1, &status);
  if(ret!=TPCERROR_OK) {
    fprintf(stderr, "Error: %s\n", errorMsg(status.error));
    return(301);
  }
  if(tac1.format!=TAC_FORMAT_ABSS_ALLOGG_OLD) {tacFree(&tac1); return(302);}
  strcpy(filename2, "output.alg");
  if(verbose>2) {printf("writing %s\n", filename2); fflush(stdout);}
  fp=fopen(filename2, "w");
  ret=abssWrite(&tac1, fp, &status); fclose(fp);
  if(ret!=TPCERROR_OK) {tacFree(&tac1); return(303);}
  TAC tac2; tacInit(&tac2);
  if(verbose>2) printf("reading %s\n", filename2);
  ret=tacRead(&tac2, filename2, &status);
  if(ret!=TPCERROR_OK) {
    fprintf(stderr, "Error: %s\n", errorMsg(status.error));
    tacFree(&tac1); tacFree(&tac2); return(304);
  }
  if(tac2.format!=TAC_FORMAT_ABSS_ALLOGG_OLD) {
    tacFree(&tac1); tacFree(&tac2); return(305);}
  if(verbose>2) printf("comparing\n");
  ret=tacCompareConc(&tac1, &tac2, -1, 1.0E-06, 1.0E-03, &status);
  if(ret==0) ret=tacCompareTimes(&tac1, &tac2, 1.0E-06, 1.0E-03, &status);
  if(ret==0) ret=tacCompareNames(&tac1, &tac2, -1, &status);
  if(ret!=0) {tacFree(&tac1); tacFree(&tac2); return(306);}
  tacFree(&tac1); tacFree(&tac2);
  }

  if(verbose>1) {printf("\nAllogg ABSS\n"); fflush(stdout);}
  {
  strcpy(filename1, "ME_ABSS09282_is731dy1.txt");
  TAC tac1; tacInit(&tac1);
  if(verbose>2) {printf("reading %s\n", filename1); fflush(stdout);}
  ret=tacRead(&tac1, filename1, &status);
  if(ret!=TPCERROR_OK) {
    fprintf(stderr, "Error: %s\n", errorMsg(status.error));
    return(401);
  }
  if(tac1.format!=TAC_FORMAT_ABSS_ALLOGG) {tacFree(&tac1); return(402);}
  strcpy(filename2, "output_allogg.txt");
  if(verbose>2) {printf("writing %s\n", filename2); fflush(stdout);}
  fp=fopen(filename2, "w");
  ret=abssWrite(&tac1, fp, &status); fclose(fp);
  if(ret!=TPCERROR_OK) {tacFree(&tac1); return(403);}
  TAC tac2; tacInit(&tac2);
  if(verbose>2) printf("reading %s\n", filename2);
  ret=tacRead(&tac2, filename2, &status);
  if(ret!=TPCERROR_OK) {
    fprintf(stderr, "Error: %s\n", errorMsg(status.error));
    tacFree(&tac1); tacFree(&tac2); return(404);
  }
  if(tac2.format!=TAC_FORMAT_ABSS_ALLOGG) {
    tacFree(&tac1); tacFree(&tac2); return(405);}
  if(verbose>2) printf("comparing\n");
  ret=tacCompareConc(&tac1, &tac2, -1, 1.0E-06, 1.0E-03, &status);
  if(ret==0) ret=tacCompareTimes(&tac1, &tac2, 1.0E-06, 1.0E-03, &status);
  if(ret==0) ret=tacCompareNames(&tac1, &tac2, -1, &status);
  if(ret!=0) {tacFree(&tac1); tacFree(&tac2); return(406);}
  tacFree(&tac1); tacFree(&tac2);
  }

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
