/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpccm.h"
/*****************************************************************************/

/*****************************************************************************/
int test_convolve1D(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int ret;

  if(verbose>1) printf("\n testing with NULL input\n");
  ret=convolve1D(NULL, 16, NULL, 16, NULL);
  if(ret==0) return(1);

  int i, n, m;
  double a[100], b[100], r[100], correct_b[100];

  
  if(verbose>1) printf("\n testing with decent input\n");
  n=16, m=5;
  for(i=0; i<n; i++) a[i]=b[i]=correct_b[i]=0.0;
  for(i=0; i<m; i++) r[i]=0.0;
  r[0]=r[1]=r[2]=1.0;
  a[3]=1.0; a[4]=a[5]=2.0; a[6]=1.0;
  correct_b[3]=1.0; correct_b[4]=3.0; correct_b[5]=correct_b[6]=5.0; correct_b[7]=3.0; correct_b[8]=1.0;
  ret=convolve1D(a, n, r, m, b);
  if(ret!=0) return(11);
  if(verbose>2) printf("\na\tb\tcorrect_b\n");
  for(i=0; i<n; i++) {
    if(verbose>2) printf("%g\t%g\t%g\n", a[i], b[i], correct_b[i]);
    if(!doubleMatch(correct_b[i], b[i], 1.0E-08)) return(12);
  }

  if(verbose>1) printf("\n testing with decent input, but m>n\n");
  n=14, m=20;
  for(i=0; i<n; i++) a[i]=b[i]=correct_b[i]=0.0;
  for(i=0; i<m; i++) r[i]=0.0;
  r[0]=r[1]=r[2]=1.0;
  a[3]=1.0; a[4]=a[5]=2.0; a[6]=1.0;
  correct_b[3]=1.0; correct_b[4]=3.0; correct_b[5]=correct_b[6]=5.0; correct_b[7]=3.0; correct_b[8]=1.0;
  ret=convolve1D(a, n, r, m, b);
  if(ret!=0) return(21);

  if(verbose>2) printf("\na\tb\tcorrect_b\n");
  for(i=0; i<n; i++) {
    if(verbose>2) printf("%g\t%g\t%g\n", a[i], b[i], correct_b[i]);
    if(!doubleMatch(correct_b[i], b[i], 1.0E-08)) return(22);
  }


  if(verbose>1) printf("\n testing with data that has no zero padding\n");
  // SageMath: convolution([3, 4, 5], [2, 1]) -> [6, 11, 14, 5]
  n=3; m=2;
  a[0]=3.0; a[1]=4.0; a[2]=5.0;
  r[0]=2.0; r[1]=1.0;
  correct_b[0]=6.0; correct_b[1]=11.0; correct_b[2]=14.0;
  ret=convolve1D(a, n, r, m, b);
  if(ret!=0) return(31);
  if(verbose>2) printf("\na\tb\tcorrect_b\n");
  for(i=0; i<n; i++) {
    if(verbose>2) printf("%g\t%g\t%g\n", a[i], b[i], correct_b[i]);
    if(!doubleMatch(correct_b[i], b[i], 1.0E-08)) return(32);
  }

  if(verbose>1) printf("\n same but kernel has zeroes so that m==n\n");
  n=3; m=3;
  a[0]=3.0; a[1]=4.0; a[2]=5.0;
  r[0]=2.0; r[1]=1.0; r[2]=0.0;
  correct_b[0]=6.0; correct_b[1]=11.0; correct_b[2]=14.0;
  ret=convolve1D(a, n, r, m, b);
  if(ret!=0) return(41);
  if(verbose>2) printf("\na\tb\tcorrect_b\n");
  for(i=0; i<n; i++) {
    if(verbose>2) printf("%g\t%g\t%g\n", a[i], b[i], correct_b[i]);
    if(!doubleMatch(correct_b[i], b[i], 1.0E-08)) return(42);
  }

  if(verbose>1) printf("\n same but zero padding to data too\n");
  n=5; m=3;
  a[0]=3.0; a[1]=4.0; a[2]=5.0; a[3]=0.0; a[4]=0.0;
  r[0]=2.0; r[1]=1.0; r[2]=0.0;
  correct_b[0]=6.0; correct_b[1]=11.0; correct_b[2]=14.0; correct_b[3]=5.0; correct_b[4]=0.0;
  ret=convolve1D(a, n, r, m, b);
  if(ret!=0) return(51);
  if(verbose>2) printf("\na\tb\tcorrect_b\n");
  for(i=0; i<n; i++) {
    if(verbose>2) printf("%g\t%g\t%g\n", a[i], b[i], correct_b[i]);
    if(!doubleMatch(correct_b[i], b[i], 1.0E-08)) return(52);
  }

  if(verbose>1) printf("\n ok \n");

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_simIsSteadyInterval(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int ret;

  if(verbose>1) printf("\n testing with NULL input\n");
  ret=simIsSteadyInterval(NULL, 0, NULL);
  if(ret!=0) return(1);
  ret=simIsSteadyInterval(NULL, 10, NULL);
  if(ret!=0) return(2);

  int n=0;
  double x[100], f;

  if(verbose>1) printf("\n testing with zero input\n");
  ret=simIsSteadyInterval(x, 0, &f);
  if(ret!=0) return(3);

  if(verbose>1) printf("\n testing with n=1\n");
  n=1; x[0]=1.0;
  ret=simIsSteadyInterval(x, n, &f);
  if(ret!=0) return(11);
  n=1; x[0]=0.0;
  ret=simIsSteadyInterval(x, n, &f);
  if(ret!=0) return(12);
  n=1; x[0]=-1.0;
  ret=simIsSteadyInterval(x, n, &f);
  if(ret!=0) return(13);
  n=1; x[0]=nan("");
  ret=simIsSteadyInterval(x, n, &f);
  if(ret!=0) return(14);

  if(verbose>1) printf("\n testing with n=2\n");
  n=2; x[0]=1.0; x[1]=2.0;
  ret=simIsSteadyInterval(x, n, &f);
  if(ret!=0 || !doubleMatch(f, 1.0, 1.0E-10)) return(21);
  n=2; x[0]=0.0; x[1]=1.0;
  ret=simIsSteadyInterval(x, n, &f);
  if(ret!=0 || !doubleMatch(f, 1.0, 1.0E-10)) return(22);
  n=2; x[0]=-1.0; x[1]=1.0;
  ret=simIsSteadyInterval(x, n, &f);
  if(ret!=0) return(23);
  n=2; x[0]=0.0; x[1]=nan(""); 
  ret=simIsSteadyInterval(x, n, &f);
  if(ret!=0) return(24);
  n=2; x[0]=nan(""); x[1]=1.0; 
  ret=simIsSteadyInterval(x, n, &f);
  if(ret!=0) return(25);
  n=2; x[0]=0.5; x[1]=1.5;
  ret=simIsSteadyInterval(x, n, &f);
  if(ret==0 || !doubleMatch(f, 1.0, 1.0E-10)) return(26);
  n=2; x[0]=1.5; x[1]=2.5;
  ret=simIsSteadyInterval(x, n, &f);
  if(ret!=0 || !doubleMatch(f, 1.0, 1.0E-10)) return(27);

  if(verbose>1) printf("\n testing with n>2\n");
  n=20;
  for(int i=0; i<n; i++) x[i]=0.5+(double)i;
  ret=simIsSteadyInterval(x, n, &f);
  if(ret==0 || !doubleMatch(f, 1.0, 1.0E-10)) return(31);
  x[n-1]=x[n-2]+2.0;
  ret=simIsSteadyInterval(x, n, &f);
  if(ret!=0 || !doubleMatch(f, 1.0, 1.0E-10)) return(32);
  x[n-1]=x[n-2]+0.5;
  ret=simIsSteadyInterval(x, n, &f);
  if(ret!=0 || !doubleMatch(f, 0.5, 1.0E-10)) return(33);

  for(int i=0; i<n; i++) x[i]=(double)(i+1);
  ret=simIsSteadyInterval(x, n, &f);
  if(verbose>2) printf("  ret=%d freq=%g\n", ret, f);
  if(ret!=0 || !doubleMatch(f, 1.0, 1.0E-10)) return(34);
  x[0]=0.0;
  ret=simIsSteadyInterval(x, n, &f);
  if(verbose>2) printf("  ret=%d freq=%g\n", ret, f);
  if(ret!=0 || !doubleMatch(f, 1.0, 1.0E-10)) return(35);

  for(int i=0; i<n; i++) x[i]=1.005+2.01*(double)i;
  ret=simIsSteadyInterval(x, n, &f);
  if(ret==0 || !doubleMatch(f, 2.01, 1.0E-10)) return(36);


  if(verbose>1) printf("\n ok \n");

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
