/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpccm.h"
/*****************************************************************************/

/*****************************************************************************/
int test_simC1DI(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  int ret;

  if(verbose>1) printf("\n testing with empty data \n");
  ret=simC1DI(NULL, NULL, NULL, 0, 0.0, 0.0, 0.0, NULL);
  if(verbose>2) printf("did not segfault, that is good.\n");
  if(ret==0) return(1);
  if(verbose>2) printf("\n more testing with empty data \n");
  ret=simC1DI(NULL, NULL, NULL, 100, 0.2, 0.4, 0.5, NULL);
  if(verbose>2) printf("did not segfault, that is good.\n");
  if(ret==0) return(2);

  TAC input, sim;
  tacInit(&input); tacInit(&sim);

  if(verbose>2) printf("\n more testing with empty data \n");
  ret=simC1DI(input.x, input.x, input.x, 0, 0.2, 0.4, 0.5, NULL);
  if(verbose>2) printf("did not segfault, that is good.\n");
  if(ret==0) return(3);

  statusSet(status, __func__, __FILE__, __LINE__, 0);

  if(verbose>1) printf("\n testing with data made in spreadsheet \n");
  ret=tacRead(&input, "di1tcm.tac", status);
  if(ret!=TPCERROR_OK) {
    printf("Error: cannot read test data; run test in 'test' directory.\n");
    tacFree(&input); tacFree(&sim);; return(10);
  }
  tacDuplicate(&input, &sim);
  ret=simC1DI(input.x, input.c[0].y, input.c[1].y, input.sampleNr, 0.2, 0.4, 0.6, sim.c[2].y);
  if(ret!=0) {
    tacFree(&input); tacFree(&sim); return(11);
  }
  ret=tacCompareConc(&input, &sim, 0, 0.001, 0.001, status);
  if(ret!=0) {
    tacFree(&input); tacFree(&sim); return(12);
  }

  tacFree(&input); tacFree(&sim);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_simC3DIvs(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_simC4DIvp(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_simC4DIvs(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
