/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpccsv.h"
/*****************************************************************************/

/*****************************************************************************/
int test_csvInit(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  CSV csv;
  csvInit(&csv);
  csvInit((CSV*)NULL);
  
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_csvFree(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  CSV csv;
  csvInit(&csv);
  csvFree(&csv);
  
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_csvAllocate(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  CSV csv;
  int n, ret;
  csvInit(&csv);

  n=0;
  ret=csvAllocate(&csv, n);
  if(ret!=TPCERROR_OK || csv._item_nr!=0) {csvFree(&csv); return 1;}
  
  n=10;
  ret=csvAllocate(&csv, n);
  if(ret!=TPCERROR_OK || csv._item_nr!=10) {csvFree(&csv); return 2;}
  
  n=5;
  ret=csvAllocate(&csv, n);
  if(ret!=TPCERROR_OK || csv._item_nr!=10) {csvFree(&csv); return 3;}
  
  n=15;
  ret=csvAllocate(&csv, n);
  if(ret!=TPCERROR_OK || csv._item_nr!=15) {csvFree(&csv); return 4;}
  
  csvFree(&csv);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_csvDuplicate(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  CSV csv1; csvInit(&csv1);
  CSV csv2; csvInit(&csv2);

  if(verbose>1) {printf("\n testing with empty data \n"); fflush(stdout);}
  if(csvDuplicate(NULL, NULL)==TPCERROR_OK) return(1);
  if(csvDuplicate(&csv1, &csv2)==TPCERROR_OK) return(2);

  if(verbose>1) {printf("\n testing with data \n"); fflush(stdout);}

  csv1.separator=',';
  double v;
  v=1.0; csvPutDouble(&csv1, v, 0, 0);
  v=2.0; csvPutDouble(&csv1, v, 0, 0);
  v=3.0; csvPutDouble(&csv1, v, 0, 0);
  v=3.0; csvPutDouble(&csv1, v, 0, 0);
  v=1.0E-03; csvPutDouble(&csv1, v, 1, 0);
  v=2.0E-03; csvPutDouble(&csv1, v, 0, 0);
  v=3.0E-03; csvPutDouble(&csv1, v, 0, 0);

  if(verbose>2) {printf("\n duplicate \n"); fflush(stdout);}
  if(verbose>3) csvWrite(&csv1, 1, stdout, NULL);
  if(csvDuplicate(&csv1, &csv2)!=TPCERROR_OK) {csvFree(&csv1); csvFree(&csv2); return(101);}
  if(verbose>3) csvWrite(&csv2, 1, stdout, NULL);
  if(verbose>2) {printf("\n check results \n"); fflush(stdout);}
  if(csv2.col_nr!=4 || csv2.row_nr!=2) {csvFree(&csv1); csvFree(&csv2); return(102);}
  if(csv2.nr!=8) {csvFree(&csv1); csvFree(&csv2); return(103);}
  if(!doubleMatch(1.0, atof(csvCell(&csv2, 0, 0)), 1.0E-10)) {csvFree(&csv1); csvFree(&csv2); return(111);}
  if(!doubleMatch(3.0, atof(csvCell(&csv2, 0, 3)), 1.0E-10)) {csvFree(&csv1); csvFree(&csv2); return(112);}
  if(!doubleMatch(3.0E-03, atof(csvCell(&csv2, 1, 2)), 1.0E-10)) {csvFree(&csv1); csvFree(&csv2); return(113);}
  if(!csvIsRegular(&csv2)) {csvFree(&csv1); csvFree(&csv2); return(120);}

  v=4.0E-03; csvPutDouble(&csv1, v, 0, 0);
  if(verbose>2) {printf("\n duplicate \n"); fflush(stdout);}
  if(csvDuplicate(&csv1, &csv2)!=TPCERROR_OK) {csvFree(&csv1); csvFree(&csv2); return(201);}
  if(verbose>2) {printf("\n check results \n"); fflush(stdout);}
  if(csv2.col_nr!=4 || csv2.row_nr!=2) {csvFree(&csv1); csvFree(&csv2); return(202);}
  if(csv2.nr!=8) {csvFree(&csv1); csvFree(&csv2); return(203);}
  if(!doubleMatch(1.0, atof(csvCell(&csv2, 0, 0)), 1.0E-10)) {csvFree(&csv1); csvFree(&csv2); return(211);}
  if(!doubleMatch(3.0, atof(csvCell(&csv2, 0, 3)), 1.0E-10)) {csvFree(&csv1); csvFree(&csv2); return(212);}
  if(!doubleMatch(3.0E-03, atof(csvCell(&csv2, 1, 2)), 1.0E-10)) {csvFree(&csv1); csvFree(&csv2); return(213);}
  if(!doubleMatch(4.0E-03, atof(csvCell(&csv2, 1, 3)), 1.0E-10)) {csvFree(&csv1); csvFree(&csv2); return(214);}
  if(!csvIsRegular(&csv2)) {csvFree(&csv1); csvFree(&csv2); return(220);}

  csvFree(&csv1); csvFree(&csv2);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_csvPutString(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  CSV csv;
  int ret;
  char str[256];

  csvInit(&csv);

  strcpy(str, "eka"); if(verbose>1) printf("'%s' on line 1\n", str);
  ret=csvPutString(&csv, str, 0);
  if(verbose>2)
    printf("  -> ret=%d nr=%d space=%d\n", ret, csv.nr, csv._item_nr);
  if(ret!=TPCERROR_OK || csv.nr!=1 || strcmp(csv.c[csv.nr-1].content, str)!=0) {
    csvFree(&csv); return 1;
  }
  
  strcpy(str, "toka"); printf("'%s' on line 1\n", str);
  ret=csvPutString(&csv, str, 0);
  if(ret!=TPCERROR_OK || csv.nr!=2 || strcmp(csv.c[csv.nr-1].content, str)!=0) {
    csvFree(&csv); return 2;
  }
  
  strcpy(str, ""); printf("'%s' on line 1\n", str);
  ret=csvPutString(&csv, str, 0);
  if(ret!=TPCERROR_OK || csv.nr!=3 || strcmp(csv.c[csv.nr-1].content, str)!=0) {
    csvFree(&csv); return 3;
  }
  
  strcpy(str, ""); printf("'%s' on line 1\n", "NULL");
  ret=csvPutString(&csv, NULL, 0);
  if(ret!=TPCERROR_OK || csv.nr!=4 || strcmp(csv.c[csv.nr-1].content, str)!=0) {
    csvFree(&csv); return 4;
  }
  
  strcpy(str, "2nd line"); printf("'%s' on line 2\n", str);
  ret=csvPutString(&csv, str, 1);
  if(ret!=TPCERROR_OK || csv.nr!=5 || strcmp(csv.c[csv.nr-1].content, str)!=0) {
    csvFree(&csv); return 5;
  }
  
  strcpy(str, " "); printf("'%s' on line 2\n", str);
  ret=csvPutString(&csv, str, 0);
  if(ret!=TPCERROR_OK || csv.nr!=6 || strcmp(csv.c[csv.nr-1].content, str)!=0) {
    csvFree(&csv); return 6;
  }

  if(verbose>2) printf("  row_nr=%d\n  col_nr=%d\n", csv.row_nr, csv.col_nr);
  if(csv.row_nr!=2 || csv.col_nr!=4) {csvFree(&csv); return 10;}  

  csvFree(&csv);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_csvPutDouble(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  CSV csv;
  int ret;
  double v;

  csvInit(&csv);
  csv.separator=',';

  v=1.0; ret=csvPutDouble(&csv, v, 0, 0);
  if(ret!=TPCERROR_OK) {csvFree(&csv); return 1;}
  v=2.0; ret=csvPutDouble(&csv, v, 0, 0);
  if(ret!=TPCERROR_OK) {csvFree(&csv); return 1;}
  v=3.0; ret=csvPutDouble(&csv, v, 0, 0);
  if(ret!=TPCERROR_OK) {csvFree(&csv); return 1;}
  v=3.0; ret=csvPutDouble(&csv, v, 0, 0);
  if(ret!=TPCERROR_OK) {csvFree(&csv); return 1;}
  v=1.0E-03; ret=csvPutDouble(&csv, v, 1, 0);
  if(ret!=TPCERROR_OK) {csvFree(&csv); return 1;}
  v=2.0E-03; ret=csvPutDouble(&csv, v, 0, 0);
  if(ret!=TPCERROR_OK) {csvFree(&csv); return 1;}
  v=3.0E-03; ret=csvPutDouble(&csv, v, 0, 0);
  if(ret!=TPCERROR_OK) {csvFree(&csv); return 1;}
  v=3.0E-03; ret=csvPutDouble(&csv, v, 0, 0);
  if(ret!=TPCERROR_OK) {csvFree(&csv); return 1;}

  if(verbose>2) printf("  row_nr=%d\n  col_nr=%d\n", csv.row_nr, csv.col_nr);
  if(csv.row_nr!=2 || csv.col_nr!=4) {csvFree(&csv); return 10;}  

  csvFree(&csv);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_csvPutInt(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  CSV csv;
  int ret;
  int v;

  csvInit(&csv);
  csv.separator=',';

  v=1; ret=csvPutInt(&csv, v, 0);
  if(ret!=TPCERROR_OK) {csvFree(&csv); return 1;}
  v=2; ret=csvPutInt(&csv, v, 0);
  if(ret!=TPCERROR_OK) {csvFree(&csv); return 1;}
  v=-3; ret=csvPutInt(&csv, v, 1);
  if(ret!=TPCERROR_OK) {csvFree(&csv); return 1;}

  if(verbose>2) printf("  row_nr=%d\n  col_nr=%d\n", csv.row_nr, csv.col_nr);
  if(csv.row_nr!=2 || csv.col_nr!=2) {csvFree(&csv); return 10;}
  if(strcmp(csv.c[0].content, "1")!=0) {csvFree(&csv); return 11;} 
  if(strcmp(csv.c[1].content, "2")!=0) {csvFree(&csv); return 12;} 
  if(strcmp(csv.c[2].content, "-3")!=0) {csvFree(&csv); return 13;} 

  csvFree(&csv);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_csvRowLength(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  
  int n, r, ret;
  CSV csv; csvInit(&csv);
  
  /* just checking that does not crash */
  n=csvRowLength(NULL, 0);
  if(n!=0) return(1);
  n=csvRowLength(&csv, 0);
  if(n!=0) return(2);
  
  csv.separator=',';
  double v;
  v=1.0; ret=csvPutDouble(&csv, v, 0, 0);
  if(ret!=TPCERROR_OK) {csvFree(&csv); return 1;}
  v=2.0; ret=csvPutDouble(&csv, v, 0, 0);
  if(ret!=TPCERROR_OK) {csvFree(&csv); return 1;}
  v=3.0; ret=csvPutDouble(&csv, v, 0, 0);
  if(ret!=TPCERROR_OK) {csvFree(&csv); return 1;}
  v=3.0; ret=csvPutDouble(&csv, v, 0, 0);
  if(ret!=TPCERROR_OK) {csvFree(&csv); return 1;}
  v=1.0E-03; ret=csvPutDouble(&csv, v, 1, 0);
  if(ret!=TPCERROR_OK) {csvFree(&csv); return 1;}
  v=2.0E-03; ret=csvPutDouble(&csv, v, 0, 0);
  if(ret!=TPCERROR_OK) {csvFree(&csv); return 1;}
  v=3.0E-03; ret=csvPutDouble(&csv, v, 0, 0);
  if(ret!=TPCERROR_OK) {csvFree(&csv); return 1;}

  r=0; n=csvRowLength(&csv, r); if(n!=4) {csvFree(&csv); return(11);}
  r=1; n=csvRowLength(&csv, r); if(n!=3) {csvFree(&csv); return(12);}
  r=2; n=csvRowLength(&csv, r); if(n!=0) {csvFree(&csv); return(13);}

  if(verbose>2) printf("  ok\n");
  csvFree(&csv);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_csvSetDimensions(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  
  /* just checking that does not crash */
  if(csvSetDimensions(NULL)==TPCERROR_OK) return(1);

  CSV csv; csvInit(&csv);
  if(csvSetDimensions(&csv)!=TPCERROR_OK) return(2);
  if(csv.col_nr!=0 || csv.row_nr!=0) return(3);
  csv.col_nr=100; csv.row_nr=1000;
  if(csvSetDimensions(&csv)!=TPCERROR_OK) return(4);
  if(csv.col_nr!=0 || csv.row_nr!=0) return(5);

  if(verbose>1) printf("\n make test data \n");
  if(csvAllocate(&csv, 30)!=TPCERROR_OK) return(100);
  csv.col_nr=6; csv.row_nr=5;
  csv.separator=',';
  int i=0; csv.c[i].row=2; csv.c[i].col=3; csv.c[i].content=strdup("cell34");
  i=1; csv.c[i].row=2; csv.c[i].col=4; csv.c[i].content=strdup("cell35");
  i=2; csv.c[i].row=3; csv.c[i].col=3; csv.c[i].content=strdup("cell44");
  i=3; csv.c[i].row=3; csv.c[i].col=4; csv.c[i].content=strdup("cell45");
  csv.nr=1+i;
  if(verbose>3) csvWrite(&csv, 1, stdout, NULL);
  if(csvSetDimensions(&csv)!=TPCERROR_OK) return(101);
  if(csv.col_nr!=5 || csv.row_nr!=4) return(102);

  i=4; csv.c[i].row=4; csv.c[i].col=5; csv.c[i].content=strdup("cell56");
  csv.nr=1+i;
  if(verbose>3) csvWrite(&csv, 1, stdout, NULL);
  if(csvSetDimensions(&csv)!=TPCERROR_OK) return(111);
  if(csv.col_nr!=6 || csv.row_nr!=5) return(112);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_csvIsRegular(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  
  int ret;
  CSV csv; csvInit(&csv);
  
  /* just checking that does not crash */
  ret=csvIsRegular(NULL);
  if(ret!=0) return(1);
  ret=csvIsRegular(&csv);
  if(ret!=1) return(2);
  
  csv.separator=',';
  double v;
  v=1.0; ret=csvPutDouble(&csv, v, 0, 0);
  if(ret!=TPCERROR_OK) {csvFree(&csv); return 1;}
  v=2.0; ret=csvPutDouble(&csv, v, 0, 0);
  if(ret!=TPCERROR_OK) {csvFree(&csv); return 1;}
  v=3.0; ret=csvPutDouble(&csv, v, 0, 0);
  if(ret!=TPCERROR_OK) {csvFree(&csv); return 1;}
  v=3.0; ret=csvPutDouble(&csv, v, 0, 0);
  if(ret!=TPCERROR_OK) {csvFree(&csv); return 1;}
  v=1.0E-03; ret=csvPutDouble(&csv, v, 1, 0);
  if(ret!=TPCERROR_OK) {csvFree(&csv); return 1;}
  v=2.0E-03; ret=csvPutDouble(&csv, v, 0, 0);
  if(ret!=TPCERROR_OK) {csvFree(&csv); return 1;}
  v=3.0E-03; ret=csvPutDouble(&csv, v, 0, 0);
  if(ret!=TPCERROR_OK) {csvFree(&csv); return 1;}

  if(csvIsRegular(&csv)) {csvFree(&csv); return(11);}

  v=4.0E-03; ret=csvPutDouble(&csv, v, 0, 0);
  if(ret!=TPCERROR_OK) {csvFree(&csv); return 1;}

  if(!csvIsRegular(&csv)) {csvFree(&csv); return(12);}

  csvFree(&csv);

  v=1.0; ret=csvPutDouble(&csv, v, 0, 0);
  if(ret!=TPCERROR_OK) {csvFree(&csv); return 1;}
  v=2.0; ret=csvPutDouble(&csv, v, 1, 0);
  if(ret!=TPCERROR_OK) {csvFree(&csv); return 1;}
  v=3.0; ret=csvPutDouble(&csv, v, 1, 0);
  if(ret!=TPCERROR_OK) {csvFree(&csv); return 1;}
  v=3.0; ret=csvPutDouble(&csv, v, 1, 0);
  if(ret!=TPCERROR_OK) {csvFree(&csv); return 1;}

  if(!csvIsRegular(&csv)) {csvFree(&csv); return(13);}


  csvFree(&csv);

  v=1.0; ret=csvPutDouble(&csv, v, 0, 0);
  if(ret!=TPCERROR_OK) {csvFree(&csv); return 1;}
  v=2.0; ret=csvPutDouble(&csv, v, 0, 0);
  if(ret!=TPCERROR_OK) {csvFree(&csv); return 1;}
  v=3.0; ret=csvPutDouble(&csv, v, 0, 0);
  if(ret!=TPCERROR_OK) {csvFree(&csv); return 1;}
  v=3.0; ret=csvPutDouble(&csv, v, 0, 0);
  if(ret!=TPCERROR_OK) {csvFree(&csv); return 1;}

  if(!csvIsRegular(&csv)) {csvFree(&csv); return(14);}

  csvFree(&csv);

  if(verbose>2) printf("  ok\n");
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_csvTrimRight(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  
  int ret;
  CSV csv; csvInit(&csv);
  
  /* just checking that does not crash */
  ret=csvTrimRight(NULL); if(ret==TPCERROR_OK) return(1);
  ret=csvTrimRight(&csv); if(ret==TPCERROR_OK) return(2);
  if(verbose>2) printf("  ok\n");
  
  csv.separator=',';
  double v;
  v=1.0; ret=csvPutDouble(&csv, v, 0, 0);
  if(ret!=TPCERROR_OK) {csvFree(&csv); return 1;}
  v=2.0; ret=csvPutDouble(&csv, v, 0, 0);
  if(ret!=TPCERROR_OK) {csvFree(&csv); return 1;}
  v=3.0; ret=csvPutDouble(&csv, v, 0, 0);
  if(ret!=TPCERROR_OK) {csvFree(&csv); return 1;}
  v=3.0; ret=csvPutDouble(&csv, v, 0, 0);
  if(ret!=TPCERROR_OK) {csvFree(&csv); return 1;}
  v=1.0E-03; ret=csvPutDouble(&csv, v, 1, 0);
  if(ret!=TPCERROR_OK) {csvFree(&csv); return 1;}
  v=2.0E-03; ret=csvPutDouble(&csv, v, 0, 0);
  if(ret!=TPCERROR_OK) {csvFree(&csv); return 1;}
  v=3.0E-03; ret=csvPutDouble(&csv, v, 0, 0);
  if(ret!=TPCERROR_OK) {csvFree(&csv); return 1;}

  if(csvIsRegular(&csv)) {csvFree(&csv); return(11);}
  if(csvTrimRight(&csv)) {csvFree(&csv); return(12);}
  if(csvIsRegular(&csv)) {csvFree(&csv); return(13);}

  v=4.0E-03; ret=csvPutDouble(&csv, v, 0, 0);
  if(ret!=TPCERROR_OK) {csvFree(&csv); return 1;}
  if(!csvIsRegular(&csv)) {csvFree(&csv); return(21);}
  if(csvTrimRight(&csv)) {csvFree(&csv); return(22);}
  if(!csvIsRegular(&csv)) {csvFree(&csv); return(23);}

  csvFree(&csv);

  if(verbose>1) printf("\n data with empty columns \n");
  csv.separator=',';
  csvPutString(&csv, "r1c1", 0);
  csvPutString(&csv, "r1c2", 0);
  csvPutString(&csv, "r2c1", 1);
  csvPutString(&csv, "r2c2", 0);
  csvPutString(&csv, "", 0);
  csvPutString(&csv, NULL, 0);
  csvPutString(&csv, "r3c1", 1);
  csvPutString(&csv, NULL, 0);
  csvPutString(&csv, "r4c1", 1);
  csvPutString(&csv, "r4c2", 0);
  csvPutString(&csv, "# r4c2", 0);
  if(verbose>3) csvWrite(&csv, 1, stdout, NULL);
  if(csvIsRegular(&csv)) {csvFree(&csv); return(100);}
  if(csvTrimRight(&csv)!=TPCERROR_OK) {csvFree(&csv); return(101);}
  if(verbose>3) {printf("\n-->\n"); csvWrite(&csv, 1, stdout, NULL);}
  if(!csvIsRegular(&csv)) {csvFree(&csv); return(102);}
  if(verbose>1) printf("  ok\n");

  csvFree(&csv);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_csvCell(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  
  CSV csv; csvInit(&csv);
  char *cptr;
  
  /* just checking that does not crash */
  cptr=csvCell(NULL, 0, 0);
  if(cptr!=NULL) return(1);
  cptr=csvCell(&csv, 0, 0);
  if(cptr!=NULL) return(2);
  
  csv.separator=',';

  /* Fill CVS with strings */
  char temp[64];
  int ret, ci, ri, colnr=6, rownr=4;  
  for(ri=0; ri<rownr; ri++) {
    for(ci=0; ci<colnr; ci++) {
      sprintf(temp, "row%dcol%d", ri+1, ci+1);
      if(ri>0 && ci==0) ret=csvPutString(&csv, temp, 1);
      else ret=csvPutString(&csv, temp, 0);
      if(ret!=TPCERROR_OK) break;
    }
  }

  ci=0; ri=0;
  if(verbose>1) printf("reading cell[%d][%d]:\n", ci, ri);
  cptr=csvCell(&csv, ri, ci);
  if(verbose>1) printf("  %s\n", cptr);
  if(cptr==NULL || strcmp(cptr, "row1col1")) {csvFree(&csv); return(11);}

  ci=3; ri=2;
  if(verbose>1) printf("reading cell[%d][%d]:\n", ci, ri);
  cptr=csvCell(&csv, ri, ci);
  if(verbose>1) printf("  %s\n", cptr);
  if(cptr==NULL || strcmp(cptr, "row3col4")) {csvFree(&csv); return(12);}

  ci=30; ri=20;
  if(verbose>1) printf("reading cell[%d][%d]:\n", ci, ri);
  cptr=csvCell(&csv, ri, ci);
  if(cptr!=NULL) {csvFree(&csv); return(13);}
  if(verbose>1) printf("  NULL\n");
  
  if(verbose>2) printf("  ok\n");
  csvFree(&csv);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_csvCellReplace(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  
  CSV csv; csvInit(&csv);
  int ret=0;
  
  if(verbose>1) printf("\nTest with stupid input\n");
  ret=csvCellReplace(NULL, 0, 0, NULL);
  if(ret!=TPCERROR_FAIL) return(1);
  ret=csvCellReplace(&csv, 0, 0, NULL);
  if(ret==TPCERROR_OK) return(2);
  
  csv.separator=',';

  /* Fill CVS with strings */
  char temp[64];
  int ci, ri, colnr=6, rownr=4;  
  for(ri=0; ri<rownr; ri++) {
    for(ci=0; ci<colnr; ci++) {
      sprintf(temp, "row%dcol%d", ri+1, ci+1);
      if(ri>0 && ci==0) ret=csvPutString(&csv, temp, 1);
      else ret=csvPutString(&csv, temp, 0);
      if(ret!=TPCERROR_OK) break;
    }
  }

  if(verbose>1) printf("\nTest valid replacements\n");
  char *cptr;

  ci=0; ri=0;
  if(verbose>2) printf("reading cell[%d][%d]:\n", ci, ri);
  cptr=csvCell(&csv, ri, ci);
  if(verbose>1) printf("  %s\n", cptr);
  if(verbose>2) printf("replace it with 'meh'\n");
  ret=csvCellReplace(&csv, ri, ci, "meh");
  if(ret!=TPCERROR_OK) {csvFree(&csv); return(11);}
  if(verbose>1) printf("reading cell[%d][%d]:\n", ci, ri);
  cptr=csvCell(&csv, ri, ci);
  if(verbose>1) printf("  -> %s\n", cptr);
  if(cptr==NULL || strcmp(cptr, "meh")) {csvFree(&csv); return(12);}


  ci=3; ri=2;
  if(verbose>2) printf("reading cell[%d][%d]:\n", ci, ri);
  cptr=csvCell(&csv, ri, ci);
  if(verbose>1) printf("  %s\n", cptr);
  if(verbose>2) printf("set it to empty value\n");
  ret=csvCellReplace(&csv, ri, ci, NULL);
  if(ret!=TPCERROR_OK) {csvFree(&csv); return(21);}
  if(verbose>1) printf("reading cell[%d][%d]:\n", ci, ri);
  cptr=csvCell(&csv, ri, ci);
  if(verbose>1) printf("  -> %s\n", cptr);
  if(cptr==NULL || strlen(cptr)>0) {csvFree(&csv); return(22);}


  ci=5; ri=3;
  if(verbose>2) printf("reading cell[%d][%d]:\n", ci, ri);
  cptr=csvCell(&csv, ri, ci);
  if(verbose>1) printf("  %s\n", cptr);
  if(verbose>2) printf("set it to empty value\n");
  ret=csvCellReplace(&csv, ri, ci, "");
  if(ret!=TPCERROR_OK) {csvFree(&csv); return(31);}
  if(verbose>1) printf("reading cell[%d][%d]:\n", ci, ri);
  cptr=csvCell(&csv, ri, ci);
  if(verbose>1) printf("  -> %s\n", cptr);
  if(cptr==NULL || strlen(cptr)>0) {csvFree(&csv); return(32);}


  if(verbose>1) printf("\nTest with cell that does not exist\n");
  ci=6; ri=4;
  ret=csvCellReplace(&csv, ri, ci, "hehe");
  if(ret!=TPCERROR_MISSING_DATA) {csvFree(&csv); return(41);}
  
  if(verbose>1) printf("  ok\n");
  csvFree(&csv);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_csvRemoveItem(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  
  CSV csv; csvInit(&csv);
  
  if(verbose>1) printf("\nTest with stupid input\n");
  if(csvRemoveItem(NULL, 0)==TPCERROR_OK) return(1);
  if(csvRemoveItem(&csv, 0)==TPCERROR_OK) return(2);
  if(csvRemoveItem(&csv, 1)==TPCERROR_OK) return(3);
  if(verbose>1) printf("  ok\n");

  csvPutString(&csv, "test", 0);
  if(csvRemoveItem(&csv, 1)==TPCERROR_OK) {csvFree(&csv); return(11);}
  if(verbose>1) printf("  ok\n");
  if(csvRemoveItem(&csv, 0)!=TPCERROR_OK) {csvFree(&csv); return(12);}
  if(csv.nr!=0) {csvFree(&csv); return(12);}
  if(verbose>1) printf("  ok\n");

  csvPutString(&csv, "i1", 0);
  csvPutString(&csv, "i2", 0);
  csvPutString(&csv, "i3", 0);
  if(csvRemoveItem(&csv, 1)!=TPCERROR_OK) {csvFree(&csv); return(21);}
  if(csv.nr!=2) {csvFree(&csv); return(22);}
  if(strcmp("i1", csv.c[0].content)) {csvFree(&csv); return(23);}
  if(strcmp("i3", csv.c[1].content)) {csvFree(&csv); return(24);}
  if(verbose>1) printf("  ok\n");

  csvFree(&csv);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_csvRemoveEmptyRows(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  
  CSV csv; csvInit(&csv);
  
  if(verbose>1) printf("\nTest with stupid input\n");
  if(csvRemoveEmptyRows(NULL)==TPCERROR_OK) return(1);
  if(csvRemoveEmptyRows(&csv)==TPCERROR_OK) return(2);
  if(verbose>1) printf("  ok\n");
  
  if(verbose>1) printf("\n make test data \n");
  if(csvAllocate(&csv, 30)!=TPCERROR_OK) return(100);
  csv.col_nr=6; csv.row_nr=5;
  csv.separator=',';
  int i=0; csv.c[i].row=2; csv.c[i].col=3; csv.c[i].content=strdup("cell34");
  i=1; csv.c[i].row=2; csv.c[i].col=4; csv.c[i].content=strdup("cell35");
  i=2; csv.c[i].row=3; csv.c[i].col=3; csv.c[i].content=strdup("cell44");
  i=3; csv.c[i].row=3; csv.c[i].col=4; csv.c[i].content=strdup("cell45");
  csv.nr=1+i;
  if(verbose>3) csvWrite(&csv, 1, stdout, NULL);

  CSV csv2; csvInit(&csv2); 

  if(verbose>1) printf("\n data with empty rows \n");
  csvDuplicate(&csv, &csv2); if(verbose>3) csvWrite(&csv2, 1, stdout, NULL);
  if(csvRemoveEmptyRows(&csv2)!=TPCERROR_OK) {csvFree(&csv); csvFree(&csv2); return(101);}
  if(verbose>1) printf("  ok\n");
  if(verbose>3) csvWrite(&csv2, 1, stdout, NULL);
  if(csv2.row_nr!=2 && csv2.col_nr!=csv.col_nr) {csvFree(&csv); csvFree(&csv2); return(102);}
  if(strcmp(csvCell(&csv, 2, 3), csvCell(&csv2, 0, 3))) {csvFree(&csv); csvFree(&csv2); return(110);}
  if(strcmp(csvCell(&csv, 3, 4), csvCell(&csv2, 1, 4))) {csvFree(&csv); csvFree(&csv2); return(111);}
  if(verbose>1) printf("  ok\n");

  if(verbose>1) printf("\n data with comment \n");
  i=csv.nr; csv.c[i].row=1; csv.c[i].col=5; csv.c[i].content=strdup("# cell26");
  csv.nr=1+i;
  csvDuplicate(&csv, &csv2); if(verbose>3) csvWrite(&csv2, 1, stdout, NULL);
  if(csvRemoveEmptyRows(&csv2)!=TPCERROR_OK) {csvFree(&csv); csvFree(&csv2); return(201);}
  if(verbose>1) printf("  ok\n");
  if(verbose>3) csvWrite(&csv2, 1, stdout, NULL);
  if(csv2.row_nr!=2 && csv2.col_nr!=csv.col_nr) {csvFree(&csv); csvFree(&csv2); return(202);}
  if(strcmp(csvCell(&csv, 2, 3), csvCell(&csv2, 0, 3))) {csvFree(&csv); csvFree(&csv2); return(210);}
  if(strcmp(csvCell(&csv, 3, 4), csvCell(&csv2, 1, 4))) {csvFree(&csv); csvFree(&csv2); return(211);}
  if(verbose>1) printf("  ok\n");


  csvFree(&csv); csvFree(&csv2);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_csvRemoveComments(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  
  CSV csv; csvInit(&csv);
  
  if(verbose>1) printf("\nTest with stupid input\n");
  if(csvRemoveComments(NULL)==TPCERROR_OK) return(1);
  if(csvRemoveComments(&csv)==TPCERROR_OK) return(2);
  if(verbose>1) printf("  ok\n");
  
  if(verbose>1) printf("\n make test data \n");
  if(csvAllocate(&csv, 30)!=TPCERROR_OK) return(100);
  csv.col_nr=6; csv.row_nr=5;
  csv.separator=',';
  int i=0; csv.c[i].row=2; csv.c[i].col=3; csv.c[i].content=strdup("cell34");
  i=1; csv.c[i].row=2; csv.c[i].col=4; csv.c[i].content=strdup("cell35");
  i=2; csv.c[i].row=3; csv.c[i].col=3; csv.c[i].content=strdup("cell44");
  i=3; csv.c[i].row=3; csv.c[i].col=4; csv.c[i].content=strdup("cell45");
  csv.nr=1+i;
  if(verbose>3) csvWrite(&csv, 1, stdout, NULL);

  CSV csv2; csvInit(&csv2); 
  if(csvDuplicate(&csv, &csv2)!=TPCERROR_OK) {csvFree(&csv); csvFree(&csv2); return(110);}
  if(verbose>3) csvWrite(&csv2, 1, stdout, NULL);

  if(verbose>1) printf("\nTest with data containing no comments\n");
  if(csvRemoveComments(&csv2)!=TPCERROR_OK) {csvFree(&csv); csvFree(&csv2); return(111);}
  if(verbose>4) csvWrite(&csv2, 1, stdout, NULL);
  if(csv.nr!=4) {csvFree(&csv); csvFree(&csv2); return(112);}
  if(verbose>1) printf("  ok\n");

  if(verbose>1) printf("\nTest with data containing empty cells and no comments\n");
  if(csvCellReplace(&csv2, 2, 3, "#cell34")!=TPCERROR_OK) {csvFree(&csv); csvFree(&csv2); return(120);}
  if(csvCellReplace(&csv2, 3, 3, "")!=TPCERROR_OK) {csvFree(&csv); csvFree(&csv2); return(121);}
  int cnr=csv2.nr;
  if(verbose>3) csvWrite(&csv2, 1, stdout, NULL);
  if(csvRemoveComments(&csv2)!=TPCERROR_OK) {csvFree(&csv); csvFree(&csv2); return(123);}
  if(verbose>3) csvWrite(&csv2, 1, stdout, NULL);
  if(csv2.nr!=cnr-1) {csvFree(&csv); csvFree(&csv2); return(124);}
  if(verbose>1) printf("  ok\n");

  csvFree(&csv); csvFree(&csv2);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_csvReorg(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  
  CSV csv; csvInit(&csv);
  
  if(verbose>1) printf("\nTest with stupid input\n");
  if(csvReorg(NULL, NULL)==TPCERROR_OK) return(1);
  if(csvReorg(&csv, NULL)==TPCERROR_OK) return(2);
  if(verbose>1) printf("  ok\n");
  
  if(verbose>1) printf("\n make test data with just one item\n");
  if(csvAllocate(&csv, 30)!=TPCERROR_OK) return(100);
  csv.col_nr=6; csv.row_nr=5;
  csv.separator=',';
  int i=0; csv.c[i].row=2; csv.c[i].col=3; csv.c[i].content=strdup("cell34");
  csv.nr=1+i;
  if(verbose>3) csvList(&csv, stdout);
  if(csvReorg(&csv, NULL)!=TPCERROR_OK) {csvFree(&csv); return(101);}
  if(verbose>3) {printf("->\n"); csvList(&csv, stdout);}
  if(csv.c[0].row!=2 || csv.c[0].col!=3 || strcmp(csv.c[0].content, "cell34")) {csvFree(&csv); return(102);}

  if(verbose>1) printf("\n make test data with two items in wrong order\n");
  i=1; csv.c[i].row=1; csv.c[i].col=3; csv.c[i].content=strdup("cell24");
  csv.nr=1+i;
  if(verbose>3) csvList(&csv, stdout);
  if(csvReorg(&csv, NULL)!=TPCERROR_OK) {csvFree(&csv); return(111);}
  if(verbose>3) {printf("->\n"); csvList(&csv, stdout);}
  i=0; if(csv.c[i].row!=1 || csv.c[i].col!=3 || strcmp(csv.c[i].content, "cell24")) {csvFree(&csv); return(112);}
  i=1; if(csv.c[i].row!=2 || csv.c[i].col!=3 || strcmp(csv.c[i].content, "cell34")) {csvFree(&csv); return(113);}

  if(verbose>1) printf("\n make test data with three items in wrong order\n");
  i=2; csv.c[i].row=1; csv.c[i].col=2; csv.c[i].content=strdup("cell23");
  csv.nr=1+i;
  if(verbose>3) csvList(&csv, stdout);
  if(csvReorg(&csv, NULL)!=TPCERROR_OK) {csvFree(&csv); return(121);}
  if(verbose>3) {printf("->\n"); csvList(&csv, stdout);}
  i=0; if(csv.c[i].row!=1 || csv.c[i].col!=2 || strcmp(csv.c[i].content, "cell23")) {csvFree(&csv); return(122);}
  i=1; if(csv.c[i].row!=1 || csv.c[i].col!=3 || strcmp(csv.c[i].content, "cell24")) {csvFree(&csv); return(123);}
  i=2; if(csv.c[i].row!=2 || csv.c[i].col!=3 || strcmp(csv.c[i].content, "cell34")) {csvFree(&csv); return(124);}

  if(verbose>1) printf("\n make test data with four items in wrong order\n");
  i=3; csv.c[i].row=1; csv.c[i].col=5; csv.c[i].content=strdup("cell26");
  csv.nr=1+i;
  if(verbose>3) csvList(&csv, stdout);
  if(csvReorg(&csv, NULL)!=TPCERROR_OK) {csvFree(&csv); return(131);}
  if(verbose>3) {printf("->\n"); csvList(&csv, stdout);}
  i=0; if(csv.c[i].row!=1 || csv.c[i].col!=2 || strcmp(csv.c[i].content, "cell23")) {csvFree(&csv); return(132);}
  i=1; if(csv.c[i].row!=1 || csv.c[i].col!=3 || strcmp(csv.c[i].content, "cell24")) {csvFree(&csv); return(133);}
  i=2; if(csv.c[i].row!=1 || csv.c[i].col!=5 || strcmp(csv.c[i].content, "cell26")) {csvFree(&csv); return(134);}
  i=3; if(csv.c[i].row!=2 || csv.c[i].col!=3 || strcmp(csv.c[i].content, "cell34")) {csvFree(&csv); return(135);}

  csvFree(&csv);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_csvTranspose(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  
  CSV csv; csvInit(&csv);
  
  if(verbose>1) printf("\nTest with stupid input\n");
  if(csvTranspose(NULL)==TPCERROR_OK) return(1);
  if(csvTranspose(&csv)==TPCERROR_OK) return(2);
  if(verbose>1) printf("  ok\n");
  
  if(verbose>1) printf("\n make test data with just one item\n");
  if(csvAllocate(&csv, 30)!=TPCERROR_OK) return(100);
  csv.col_nr=6; csv.row_nr=5;
  csv.separator=',';
  int i=0; csv.c[i].row=2; csv.c[i].col=3; csv.c[i].content=strdup("cell34");
  csv.nr=1+i;
  if(verbose>3) csvList(&csv, stdout);
  if(csvTranspose(&csv)!=TPCERROR_OK) {csvFree(&csv); return(101);}
  if(verbose>3) {printf("->\n"); csvList(&csv, stdout);}
  if(csv.c[0].row!=3 || csv.c[0].col!=2 || strcmp(csv.c[0].content, "cell34")) {csvFree(&csv); return(102);}
  csvFree(&csv);
  if(verbose>1) printf("  ok\n");

  if(verbose>1) printf("\n make test data with several items\n");
  if(csvAllocate(&csv, 30)!=TPCERROR_OK) return(200);
  csv.col_nr=6; csv.row_nr=5;
  csv.separator='\t';
  i=0; csv.c[i].row=2; csv.c[i].col=3; csv.c[i].content=strdup("cell34");
  i=1; csv.c[i].row=2; csv.c[i].col=4; csv.c[i].content=strdup("cell35");
  i=2; csv.c[i].row=4; csv.c[i].col=1; csv.c[i].content=strdup("cell52");
  i=3; csv.c[i].row=4; csv.c[i].col=5; csv.c[i].content=strdup("cell56");
  i=4; csv.c[i].row=0; csv.c[i].col=0; csv.c[i].content=strdup("cell11");
  csv.nr=1+i;
  if(verbose>3) csvWrite(&csv, 1, stdout, NULL);
  if(csvTranspose(&csv)!=TPCERROR_OK) {csvFree(&csv); return(201);}
  if(verbose>3) {printf("->\n"); csvWrite(&csv, 1, stdout, NULL);}
  if(verbose>3) csvList(&csv, stdout);
  i=0; if(csv.c[i].row!=0 || csv.c[i].col!=0 || strcmp(csv.c[i].content, "cell11")) {csvFree(&csv); return(202);}
  i=1; if(csv.c[i].row!=1 || csv.c[i].col!=4 || strcmp(csv.c[i].content, "cell52")) {csvFree(&csv); return(203);}
  i=2; if(csv.c[i].row!=3 || csv.c[i].col!=2 || strcmp(csv.c[i].content, "cell34")) {csvFree(&csv); return(204);}
  i=3; if(csv.c[i].row!=4 || csv.c[i].col!=2 || strcmp(csv.c[i].content, "cell35")) {csvFree(&csv); return(205);}
  i=4; if(csv.c[i].row!=5 || csv.c[i].col!=4 || strcmp(csv.c[i].content, "cell56")) {csvFree(&csv); return(206);}
  csvFree(&csv);
  if(verbose>1) printf("  ok\n");

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
