/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpcdcm.h"
/*****************************************************************************/

/*****************************************************************************/
int test_dcmfileInit(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  DCMFILE dcm;

  if(verbose>1) printf("\ntry with NULL input...\n");
  dcmfileInit(NULL);
  if(verbose>2) printf("  did not crash, good.\n");

  if(verbose>1) printf("\ntry with correct input...\n");
  dcmfileInit(&dcm);
  if(verbose>2) printf("  did not crash, good.\n");

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_dcmfileFree(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  DCMFILE dcm;

  if(verbose>1) printf("\ntry with NULL input...\n");
  dcmfileFree(NULL);
  if(verbose>2) printf("  did not crash, good.\n");

  if(verbose>1) printf("\ntry with correct but empty input...\n");
  dcmfileInit(&dcm);
  dcmfileFree(&dcm);
  if(verbose>2) printf("  did not crash, good.\n");

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_dcmitemMaxDepth(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  unsigned short int n;

  if(verbose>1) printf("\nTry with NULL input...\n");
  n=dcmitemMaxDepth(NULL);
  if(verbose>2) printf("  did not crash, good.\n");
  if(n!=0) return(1);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_dcmfileMaxDepth(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  unsigned short int n;

  if(verbose>1) printf("\nTry with NULL input...\n");
  n=dcmfileMaxDepth(NULL);
  if(verbose>2) printf("  did not crash, good.\n");
  if(n!=0) return(1);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_dcmitemParentNr(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  unsigned short int n;

  if(verbose>1) printf("\ntry with NULL input...\n");
  n=dcmitemParentNr(NULL);
  if(verbose>2) printf("  did not crash, good.\n");
  if(n!=0) return(1);

  DCMFILE dcm; dcmfileInit(&dcm);

  if(verbose>1) printf("\ntry with empty data...\n");
  n=dcmitemParentNr(dcm.item);
  if(n!=0) return(2);


  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_dcmValueString(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  char *s;

  if(verbose>1) printf("\ntry with NULL input...\n");
  s=dcmValueString(NULL);
  if(verbose>2) printf("  did not crash, good.\n");
  if(s!=NULL) return(1);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_dcmitemGetInt(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  long int i;

  if(verbose>1) printf("\ntry with NULL input...\n");
  i=dcmitemGetInt(NULL);
  if(verbose>2) printf("  did not crash, good.\n");
  if(i!=0) return(1);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_dcmitemGetReal(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  double f;

  if(verbose>1) printf("\ntry with NULL input...\n");
  f=dcmitemGetReal(NULL);
  if(verbose>2) printf("  did not crash, good.\n");
  if(fabs(f)>1.0E-10) return(1);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_dcmFindTag(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  if(verbose>1) printf("\ntry with NULL input...\n");
  if(dcmFindTag(NULL, 0, NULL, verbose)!=NULL) return(1);
  if(verbose>2) printf("  did not crash, good.\n");

  DCMFILE dcm; dcmfileInit(&dcm);
  DCMTAG tag;

  if(verbose>1) printf("\ntry with empty data...\n");
  if(dcmFindTag(dcm.item, 0, &tag, verbose)!=NULL) return(2);
  if(verbose>2) printf("  did not crash, good.\n");

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
