/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpcdcm.h"
/*****************************************************************************/

/*****************************************************************************/
int test_dcmDictSize(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  if(dcmDictSize()<10) return(1);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_dcmDictIndexTag(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int ret;

  if(verbose>1) printf("\ntry with NULL input...\n");
  ret=dcmDictIndexTag(0, NULL, NULL);
  if(verbose>2) printf("  ret := %d\n", ret);
  if(ret!=0) return(1);

  if(verbose>1) printf("\ntry with too high index...\n");
  ret=dcmDictIndexTag(dcmDictSize(), NULL, NULL);
  if(verbose>2) printf("  ret := %d\n", ret);
  if(ret==0) return(2);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_dcmDictIndexVR(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  char *cptr;

  if(verbose>1) printf("\ntry with 0 input...\n");
  cptr=dcmDictIndexVR(0);
  if(cptr==NULL) return(1);
  if(verbose>2) printf("  VR := %s\n", cptr);

  if(verbose>1) printf("\ntry with too high index...\n");
  cptr=dcmDictIndexVR(dcmDictSize());
  if(cptr!=NULL) return(2);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_dcmDictIndexType(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  char *cptr;

  if(verbose>1) printf("\ntry with 0 input...\n");
  cptr=dcmDictIndexType(0);
  if(cptr==NULL) return(1);
  if(verbose>2) printf("  Tagtype := %s\n", cptr);

  if(verbose>1) printf("\ntry with too high index...\n");
  cptr=dcmDictIndexType(dcmDictSize());
  if(cptr!=NULL) return(2);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_dcmDictIndexDescr(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  char *cptr;

  if(verbose>1) printf("\ntry with 0 input...\n");
  cptr=dcmDictIndexDescr(0);
  if(cptr==NULL) return(1);
  if(verbose>2) printf("  Description := %s\n", cptr);

  if(verbose>1) printf("\ntry with too high index...\n");
  cptr=dcmDictIndexDescr(1+dcmDictSize());
  if(cptr!=NULL) return(2);

  if(verbose>1) printf("\ntry with dictionary size...\n");
  cptr=dcmDictIndexDescr(dcmDictSize());
  if(strcasecmp(cptr, "Unknown")!=0) return(3);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_dcmDictFindTag(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  unsigned int i, n=dcmDictSize();
  DCMTAG tag, tag2;

  if(verbose>1) printf("\ntry with NULL input...\n");
  i=dcmDictFindTag(NULL);
  if(i!=n) return(1);
  if(verbose>2) printf(" -> %s\n", dcmDictIndexDescr(i));

  tag.group=0x0000; tag.element=0x0000;
  if(verbose>1)
    printf("\ntry with tag (0x%04X,0x%04X)...\n", tag.group, tag.element);
  i=dcmDictFindTag(&tag);
  if(i!=0) return(2);
  if(verbose>2) printf(" -> %s\n", dcmDictIndexDescr(i));

  tag.group=0x0002; tag.element=0x0010;
  if(verbose>1)
    printf("\ntry with tag (0x%04X,0x%04X)...\n", tag.group, tag.element);
  i=dcmDictFindTag(&tag);
  dcmDictIndexTag(i, &tag2.group, &tag2.element);
  if(tag.group!=tag2.group || tag.element!=tag2.element) return(3);
  if(verbose>2) printf(" -> %s\n", dcmDictIndexDescr(i));

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
