/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpcdcm.h"
/*****************************************************************************/

/*****************************************************************************/
int test_dcmTrUID(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  dcmtruid id;
  char buf[64];

  if(verbose>1) printf("\ntry with NULL input...\n");
  id=dcmTrUID(NULL);
  if(verbose>2) printf("  TrUID := %s\n", dcmTrUIDDescr(id));
  if(id!=DCM_TRUID_INVALID) return(1);

  strcpy(buf, "");
  id=dcmTrUID(buf);
  if(verbose>2) printf("  TrUID := %s\n", dcmTrUIDDescr(id));
  if(id!=DCM_TRUID_INVALID) return(2);

  if(verbose>1) printf("\ntry with stupid UID representation...\n");
  strcpy(buf, "__");
  id=dcmTrUID(buf);
  if(verbose>2) printf("  TrUID := %s\n", dcmTrUIDDescr(id));
  if(id!=DCM_TRUID_INVALID) return(3);

  if(verbose>1) printf("\ntry with unknown UID representation...\n");
  strcpy(buf, "2.2.1965.9999.4.5");
  id=dcmTrUID(buf);
  if(verbose>2) printf("  TrUID := %s\n", dcmTrUIDDescr(id));
  if(id!=DCM_TRUID_UNKNOWN) return(4);

  if(verbose>1) printf("\ntry to identify '1.2.840.10008.1.2.1'...\n");
  strcpy(buf, "1.2.840.10008.1.2.1");
  id=dcmTrUID(buf);
  if(verbose>2) printf("  TrUID := %s\n", dcmTrUIDDescr(id));
  if(id!=DCM_TRUID_LEE) return(5);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_dcmTrUIDDescr(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  dcmtruid id;
  char *cptr;

  if(verbose>1) printf("\ntry with 0 input...\n");
  cptr=dcmTrUIDDescr(0);
  if(cptr==NULL) return(1);
  if(verbose>2) printf("  TrUID Description := %s\n", cptr);

  if(verbose>1) printf("\ntry with too high index...\n");
  cptr=dcmTrUIDDescr(9999);
  if(cptr==NULL) return(2);
  if(verbose>2) printf("  TrUID Description := %s\n", cptr);

  if(verbose>1) printf("\ntry with valid id...\n");
  id=DCM_TRUID_LEE;
  cptr=dcmTrUIDDescr(id);
  if(verbose>2) printf("  TrUID Description := %s\n", cptr);
  if(strnlen(cptr, 10)<5) return(3);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_dcmTrUIDString(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  dcmtruid id;
  char *cptr;

  if(verbose>1) printf("\ntry with 0 input...\n");
  cptr=dcmTrUIDString(0);
  if(cptr==NULL) return(1);
  if(verbose>2) printf("  TrUID Description := %s\n", cptr);

  if(verbose>1) printf("\ntry with too high index...\n");
  cptr=dcmTrUIDString(9999);
  if(cptr==NULL) return(2);
  if(verbose>2) printf("  TrUID Description := %s\n", cptr);

  if(verbose>1) printf("\ntry with valid id...\n");
  id=DCM_TRUID_LEE;
  cptr=dcmTrUIDString(id);
  if(verbose>2) printf("  TrUID Description := %s\n", cptr);
  if(strnlen(cptr, 10)<5) return(3);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
