/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpcecat.h"
/*****************************************************************************/

/*****************************************************************************/
int test_ecatReadBlock(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  if(verbose>2) printf("ECATBLKSIZE := %d\n", ECATBLKSIZE);
  int ret;
  char fname[256];
  unsigned char buf[ECATBLKSIZE];

  if(verbose>1) printf("\ntry with NULL input...\n");

  ret=ecatReadBlock(NULL, NULL, 0, NULL);
  if(verbose>2) printf("  ret := %d\n", ret);
  if(ret==TPCERROR_OK) return(1);

  ret=ecatReadBlock(NULL, NULL, 0, buf);
  if(verbose>2) printf("  ret := %d\n", ret);
  if(ret==TPCERROR_OK) return(2);

  strcpy(fname, "");
  ret=ecatReadBlock(fname, NULL, 0, NULL);
  if(verbose>2) printf("  ret := %d\n", ret);
  if(ret==TPCERROR_OK) return(3);

  if(verbose>1) printf("\ntry with nonexisting file...\n");
  strcpy(fname, "nonexistingfile.v");
  ret=ecatReadBlock(fname, NULL, 0, buf);
  if(verbose>2) printf("  ret := %d\n", ret);
  if(ret!=TPCERROR_CANNOT_OPEN) return(11);

  if(verbose>1) printf("\ncreate a 2-block test file with ECAT 7 magic number...\n");
  strcpy(fname, "ecatreadblock.v");
  {
    char buf[ECATBLKSIZE];
    FILE *fp=fopen(fname, "wb"); if(fp==NULL) return(11);
    sprintf(buf, "MATRIX72v                    ");
    if(fwrite(buf, ECATBLKSIZE, 1, fp)<1) {fclose(fp); return(100);}
    sprintf(buf, "ABCDEFGHIJKLMNOPQRSTUVWXYZ   ");
    if(fwrite(buf, ECATBLKSIZE, 1, fp)<1) {fclose(fp); return(101);}
    fclose(fp);
  }

  if(verbose>1) printf("\n read blocks with file name \n");
  {
    ret=ecatReadBlock(fname, NULL, 0, buf);
    if(verbose>2) printf("  ret := %d\n", ret);
    if(ret!=TPCERROR_OK) return(111);
    if(verbose>2) printf("buf := '%12.12s'\n", buf);
    if(strncmp((char*)buf, "MATRIX72v", 9)!=0) return(112);

    ret=ecatReadBlock(fname, NULL, 2, buf);
    if(verbose>2) printf("  ret := %d\n", ret);
    if(ret!=TPCERROR_OK) return(113);
    if(verbose>2) printf("buf := '%12.12s'\n", buf);
    if(strncmp((char*)buf, "ABCDEFGHIJKLM", 9)!=0) return(114);

  }

  if(verbose>1) printf("\n read blocks with file pointer \n");
  {
    FILE *fp=fopen(fname, "rb"); if(fp==NULL) return(121);

    ret=ecatReadBlock(NULL, fp, 1, buf);
    if(verbose>2) printf("  ret := %d\n", ret);
    if(ret!=TPCERROR_OK) {fclose(fp); return(122);}
    if(verbose>2) printf("buf := '%12.12s'\n", buf);
    if(strncmp((char*)buf, "MATRIX72v", 9)!=0) {fclose(fp); return(123);}

    ret=ecatReadBlock(NULL, fp, 0, buf);
    if(verbose>2) printf("  ret := %d\n", ret);
    if(ret!=TPCERROR_OK) {fclose(fp); return(124);}
    if(verbose>2) printf("buf := '%12.12s'\n", buf);
    if(strncmp((char*)buf, "ABCDEFGHIJKLM", 9)!=0) {fclose(fp); return(125);}

    fclose(fp);
  }

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_ecatVerifyMagic(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int ret;
  char fname[256];

  if(verbose>1) printf("\ntry with NULL input...\n");
  ret=ecatVerifyMagic(NULL, NULL);
  if(verbose>2) printf("  ret := %d\n", ret);
  if(ret!=0) return(1);

  strcpy(fname, "");
  ret=ecatVerifyMagic(fname, NULL);
  if(verbose>2) printf("  ret := %d\n", ret);
  if(ret!=0) return(2);

  if(verbose>1) printf("\ntry with nonexisting file...\n");
  strcpy(fname, "nonexistingfile");
  ret=ecatVerifyMagic(fname, NULL);
  if(verbose>2) printf("  ret := %d\n", ret);
  if(ret!=0) return(3);

  if(verbose>1) printf("\ncreate 512 byte file with ECAT 7 magic number...\n");
  if(verbose>1) printf("ECATBLKSIZE := %d\n", ECATBLKSIZE);
  strcpy(fname, "ecatverifymagic1.v");
  {
    char buf[ECATBLKSIZE];
    FILE *fp=fopen(fname, "wb"); if(fp==NULL) return(11);
    sprintf(buf, "MATRIX72v                    ");
    if(fwrite(buf, ECATBLKSIZE, 1, fp)<1) {fclose(fp); return(12);}
    fclose(fp);
    if(verbose>2) printf("\n try with file name\n");
    if(ecatVerifyMagic(fname, NULL)!=7) {return(13);}
    if(verbose>2) printf("\n try with file pointer\n");
    fp=fopen(fname, "rb"); if(fp==NULL) return(14);
    if(ecatVerifyMagic(NULL, fp)!=7) {fclose(fp); return(15);}
    fclose(fp);
  }
  strcpy(fname, "ecatverifymagic2.v");
  {
    char buf[ECATBLKSIZE];
    FILE *fp=fopen(fname, "wb"); if(fp==NULL) return(21);
    sprintf(buf, "MATRIX7011                   ");
    if(fwrite(buf, ECATBLKSIZE, 1, fp)<1) {fclose(fp); return(22);}
    fclose(fp);
    if(verbose>2) printf("\n try with file name\n");
    if(ecatVerifyMagic(fname, NULL)!=7) {return(23);}
    if(verbose>2) printf("\n try with file pointer\n");
    fp=fopen(fname, "rb"); if(fp==NULL) return(24);
    if(ecatVerifyMagic(NULL, fp)!=7) {fclose(fp); return(25);}
    fclose(fp);
  }

  if(verbose>1) printf("\ncreate 512 byte file with empty magic number...\n");
  strcpy(fname, "ecatverifymagic1.img");
  {
    char buf[ECATBLKSIZE];
    FILE *fp=fopen(fname, "wb"); if(fp==NULL) return(31);
    sprintf(buf, "                             ");
    if(fwrite(buf, ECATBLKSIZE, 1, fp)<1) {fclose(fp); return(32);}
    fclose(fp);
    if(verbose>2) printf("\n try with file name\n");
    if(ecatVerifyMagic(fname, NULL)!=6) {return(33);}
    if(verbose>2) printf("\n try with file pointer\n");
    fp=fopen(fname, "rb"); if(fp==NULL) return(34);
    if(ecatVerifyMagic(NULL, fp)!=6) {fclose(fp); return(35);}
    fclose(fp);
  }

  if(verbose>1) printf("\ncreate 512 byte file with Interfile magic number...\n");
  strcpy(fname, "ecatverifymagic2.img");
  {
    char buf[ECATBLKSIZE];
    FILE *fp=fopen(fname, "wb"); if(fp==NULL) return(41);
    sprintf(buf, "!INTERFILE           ");
    if(fwrite(buf, ECATBLKSIZE, 1, fp)<1) {fclose(fp); return(42);}
    fclose(fp);
    if(verbose>2) printf("\n try with file name\n");
    if(ecatVerifyMagic(fname, NULL)!=0) {return(43);}
    if(verbose>2) printf("\n try with file pointer\n");
    fp=fopen(fname, "rb"); if(fp==NULL) return(44);
    if(ecatVerifyMagic(NULL, fp)!=0) {fclose(fp); return(45);}
    fclose(fp);
  }


  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
