/// @file tpcecat.h
/// @brief Header file for libtpcecat.
/// @author Vesa Oikonen
///
#ifndef _LIBTPCECAT_H
#define _LIBTPCECAT_H
/*****************************************************************************/

/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <stdint.h>
#include <stdlib.h>
#include <strings.h>
#include <ctype.h>
#include <float.h>
#include <unistd.h>
#include <locale.h>
#include <time.h>
/*****************************************************************************/
#include "tpcextensions.h"
#include "tpcift.h"
/*****************************************************************************/

/*****************************************************************************/
#ifndef BACKUP_EXTENSION
/** Backup file extension */
#define BACKUP_EXTENSION ".bak"
#endif 
/*****************************************************************************/

/*****************************************************************************/
/** ECAT matrix block size */
#define ECATBLKSIZE 512

/** ECAT matrix directory */
typedef struct {
  /** Matrix identifier (matnum). */
  unsigned int id;
  /** Start block. */
  unsigned int strtblk;
  /** End block. */
  unsigned int endblk;
  /** Matrix status (matstat); -1=deleted, 0=unfinished, 1=finished. */
  int status;
} ECAT_MATDIR;

/** ECAT matrix list */
typedef struct {
  /** Number of matrices in stored this list. */
  unsigned int matrixNr;
  /** Number of allocated matrices in this list. */
  unsigned int matrixSpace;
  /** Pointer to the list of matrices. */
  ECAT_MATDIR *matdir;
} ECAT_MATRIXLIST;

/** ECAT matrix values. */
typedef struct {
  /** Frame id; max 511 for ECAT7, 4095 for ECAT6. */
  unsigned int frame;
  /** Plane id; max 1023 for ECAT7, 255 for ECAT6. */
  unsigned int plane;
  /** Gate id; max 63 for ECAT7 and ECAT6. */
  unsigned int gate;
  /** Data id; max 7 for ECAT7, 3 for ECAT6. */
  unsigned int data;
  /** Bed id; max 15 for ECAT7 and ECAT6. */
  unsigned int bed;
} ECAT_MATVAL;
/*****************************************************************************/

/*****************************************************************************/
/* ECAT 7.x */

/// @cond
#define ECAT7V_MAGICNR "MATRIX72v"
#define ECAT7S_MAGICNR "MATRIX7011"
#define ECAT7_SW_VERSION 72
/// @endcond

/*****************************************************************************/

/*****************************************************************************/
/* ECAT 6.3 */




/*****************************************************************************/

/*****************************************************************************/
/* ecatio.c */
int ecatReadBlock(
  const char *filename, FILE *fp, const unsigned int blocknumber, unsigned char *data);
int ecatVerifyMagic(const char *filename, FILE *fp);
/* ecatheader.c */
int ecatWriteMainheader(IFT *ift, unsigned char *buf, TPCSTATUS *status);
int ecatReadMainheader(const unsigned char *buf, IFT *ift, TPCSTATUS *status);
/* ecatmatrixlist.c */
void ecatMListInit(ECAT_MATRIXLIST *ml);
void ecatMListFree(ECAT_MATRIXLIST *ml);
void ecatMListReadId(int format, unsigned int id, ECAT_MATVAL *mv);
unsigned int ecatMListMakeId(
  int format,
  unsigned int frame, unsigned int plane, unsigned int gate, unsigned int data, unsigned int bed
);
unsigned int ecatMValToId(int format, ECAT_MATVAL *mv);
int ecatMListRead(int format, FILE *fp, ECAT_MATRIXLIST *ml, TPCSTATUS *status);
void ecatMListPrint(int format, ECAT_MATRIXLIST *ml, FILE *fp);
/*****************************************************************************/

/*****************************************************************************/
#endif // _LIBTPCECAT_H
