/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpcextensions.h"
/*****************************************************************************/

/*****************************************************************************/
int test_floatMatch(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  float v1, v2, lim;
  int ret;

  v1=v2=lim=nanf("");
  if(verbose>1) printf("%g vs %g within %g\n", v1, v2, lim);
  ret=floatMatch(v1, v2, lim); if(verbose>2) printf("  -> %d\n", ret);
  if(ret!=1) return 1;

  v1=0; v2=lim=nanf("");
  if(verbose>1) printf("%g vs %g within %g\n", v1, v2, lim);
  ret=floatMatch(v1, v2, lim); if(verbose>2) printf("  -> %d\n", ret);
  if(ret!=0) return 2;

  v1=0; v2=0; lim=nanf("");
  if(verbose>1) printf("%g vs %g within %g\n", v1, v2, lim);
  ret=floatMatch(v1, v2, lim); if(verbose>2) printf("  -> %d\n", ret);
  if(ret!=1) return 3;

  v1=1.001; v2=1.002; lim=0.002;
  if(verbose>1) printf("%g vs %g within %g\n", v1, v2, lim);
  ret=floatMatch(v1, v2, lim); if(verbose>2) printf("  -> %d\n", ret);
  if(ret!=1) return 4;

  v1=1.01; v2=1.02; lim=0.002;
  if(verbose>1) printf("%g vs %g within %g\n", v1, v2, lim);
  ret=floatMatch(v1, v2, lim); if(verbose>2) printf("  -> %d\n", ret);
  if(ret!=0) return 5;

  v1=-1.01; v2=-1.02; lim=0.002;
  if(verbose>1) printf("%g vs %g within %g\n", v1, v2, lim);
  ret=floatMatch(v1, v2, lim); if(verbose>2) printf("  -> %d\n", ret);
  if(ret!=0) return 6;

  v1=-1.001; v2=-1.002; lim=0.002;
  if(verbose>1) printf("%g vs %g within %g\n", v1, v2, lim);
  ret=floatMatch(v1, v2, lim); if(verbose>2) printf("  -> %d\n", ret);
  if(ret!=1) return 7;

  v1=-1.001; v2=-1.002; lim=0;
  if(verbose>1) printf("%g vs %g within %g\n", v1, v2, lim);
  ret=floatMatch(v1, v2, lim); if(verbose>2) printf("  -> %d\n", ret);
  if(ret!=0) return 8;

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_floatMatchRel(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  float v1, v2, lim;
  int ret;

  v1=v2=lim=nanf("");
  if(verbose>1) printf("%g vs %g within %g\n", v1, v2, lim);
  ret=floatMatchRel(v1, v2, lim); if(verbose>2) printf("  -> %d\n", ret);
  if(ret!=1) return 1;

  v1=0; v2=lim=nanf("");
  if(verbose>1) printf("%g vs %g within %g\n", v1, v2, lim);
  ret=floatMatchRel(v1, v2, lim); if(verbose>2) printf("  -> %d\n", ret);
  if(ret!=0) return 2;

  v1=0; v2=0; lim=nanf("");
  if(verbose>1) printf("%g vs %g within %g\n", v1, v2, lim);
  ret=floatMatchRel(v1, v2, lim); if(verbose>2) printf("  -> %d\n", ret);
  if(ret!=1) return 3;

  v1=1.001; v2=1.002; lim=0.002;
  if(verbose>1) printf("%g vs %g within %g\n", v1, v2, lim);
  ret=floatMatchRel(v1, v2, lim); if(verbose>2) printf("  -> %d\n", ret);
  if(ret!=1) return 4;

  v1=1.01; v2=1.02; lim=0.002;
  if(verbose>1) printf("%g vs %g within %g\n", v1, v2, lim);
  ret=floatMatchRel(v1, v2, lim); if(verbose>2) printf("  -> %d\n", ret);
  if(ret!=0) return 5;

  v1=-1.01; v2=-1.02; lim=0.002;
  if(verbose>1) printf("%g vs %g within %g\n", v1, v2, lim);
  ret=floatMatchRel(v1, v2, lim); if(verbose>2) printf("  -> %d\n", ret);
  if(ret!=0) return 6;

  v1=-1.001; v2=-1.002; lim=0.002;
  if(verbose>1) printf("%g vs %g within %g\n", v1, v2, lim);
  ret=floatMatchRel(v1, v2, lim); if(verbose>2) printf("  -> %d\n", ret);
  if(ret!=1) return 7;

  v1=-1.001; v2=-1.002; lim=0;
  if(verbose>1) printf("%g vs %g within %g\n", v1, v2, lim);
  ret=floatMatchRel(v1, v2, lim); if(verbose>2) printf("  -> %d\n", ret);
  if(ret!=0) return 8;

  v1=0.0; v2=0.0; lim=0.001;
  if(verbose>1) printf("%g vs %g within %g\n", v1, v2, lim);
  ret=floatMatchRel(v1, v2, lim); if(verbose>2) printf("  -> %d\n", ret);
  if(ret!=1) return 9;

  v1=-1.0; v2=1.0; lim=0.001;
  if(verbose>1) printf("%g vs %g within %g\n", v1, v2, lim);
  ret=floatMatchRel(v1, v2, lim); if(verbose>2) printf("  -> %d\n", ret);
  if(ret!=0) return 10;

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_floatMachEps(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  float v=floatMachEps();
  if(verbose>1) printf("MachEps := %e\n", v);
  if(!isnormal(v)) return(1);
  if(!isfinite(v)) return(2);
  if(v<=0.0) return(3);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_floatCopy(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  float t[10], s[10];
  unsigned int n, i;

  if(verbose>1) printf("NULL data\n");
  floatCopy(NULL, NULL, 10); 
  if(verbose>2) printf("  -> Good, not crashed\n");

  if(verbose>1) printf("Ok data\n");
  n=10; for(i=0; i<n; i++) {s[i]=(float)(1+i); t[i]=0.0;}
  floatCopy(t, s, 10);
  for(i=0; i<n; i++) if(!floatMatch(s[i], t[i], 1.0E-08)) return 10;

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return 0;
}
/*****************************************************************************/

/*****************************************************************************/
int test_floatMaxIndex(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  unsigned int i;
  float a[]={3,2,1,0,1,2,3};

  if(verbose>1) printf("NULL data\n");
  i=floatMaxIndex(NULL, 0);
  if(verbose>2) printf("  -> Good, not crashed\n");
  if(i!=0) return(1);
  i=floatMaxIndex(NULL, 10);
  if(verbose>2) printf("  -> Good, not crashed\n");
  if(i!=0) return(2);

  if(verbose>1) printf("Decent data\n");
  i=floatMaxIndex(a, 7);
  if(verbose>2) printf("  i := %d\n", i);
  if(i!=0) return(11);
  i=floatMaxIndex(a+1, 6);
  if(verbose>2) printf("  i := %d\n", i);
  if(i!=5) return(12);

  if(verbose>1) printf("Data with nanf\n");
  a[0]=nanf("");
  i=floatMaxIndex(a, 7);
  if(verbose>2) printf("  i := %d\n", i);
  if(i!=6) return(21);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_floatSum(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  float v;

  if(verbose>1) printf("NULL data\n");
  v=floatSum(NULL, 0);
  if(verbose>2) printf("  -> Good, not crashed\n");
  if(!floatMatch(v, 0.0, floatMachEps())) return(1);
  v=floatSum(NULL, 10);
  if(verbose>2) printf("  -> Good, not crashed\n");
  if(!floatMatch(v, 0.0, floatMachEps())) return(2);

  float a[]={3,2,1,0,1,2,3};

  if(verbose>1) printf("Decent data\n");
  v=floatSum(a, 7);
  if(verbose>2) printf("  v := %g\n", v);
  if(!floatMatch(v, 12.0, floatMachEps())) return(11);
  v=floatSum(a+1, 6);
  if(verbose>2) printf("  v := %g\n", v);
  if(!floatMatch(v, 9.0, floatMachEps())) return(12);

  if(verbose>1) printf("Data with nanf\n");
  a[0]=nanf("");
  v=floatSum(a, 7);
  if(verbose>2) printf("  v := %g\n", v);
  if(!floatMatch(v, 9.0, floatMachEps())) return(21);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_floatMean(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  float v;

  if(verbose>1) printf("NULL data\n");
  v=floatMean(NULL, 0);
  if(verbose>2) printf("  -> Good, not crashed\n");
  if(!isnan(v)) return(1);
  v=floatMean(NULL, 10);
  if(verbose>2) printf("  -> Good, not crashed\n");
  if(!isnan(v)) return(2);

  float a[]={3,2,1,1,2,3};

  if(verbose>1) printf("Decent data\n");
  v=floatMean(a, 6);
  if(verbose>2) printf("  v := %g\n", v);
  if(!floatMatch(v, 2.0, floatMachEps())) return(11);
  v=floatMean(a+1, 5);
  if(verbose>2) printf("  v := %g\n", v);
  if(!floatMatch(v, 1.8, floatMachEps())) return(12);

  if(verbose>1) printf("Data with nanf\n");
  a[0]=nanf("");
  v=floatMean(a, 6);
  if(verbose>2) printf("  v := %g\n", v);
  if(!floatMatch(v, 1.8, floatMachEps())) return(21);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_floatGetWithUnit(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  char str[64];
  float v;
  int unit, ret;

  if(verbose>1) printf("str := NULL\n");
  ret=floatGetWithUnit(NULL, NULL, NULL);
  if(ret==0) return(1);

  strcpy(str, ""); if(verbose>1) printf("str := '%s'\n", str);
  ret=floatGetWithUnit(str, &v, NULL); if(verbose>2) printf("  -> %g\n", v);
  if(ret==0 || !isnan(v)) return(2);

  strcpy(str, "nanf"); if(verbose>1) printf("str := '%s'\n", str);
  ret=floatGetWithUnit(str, NULL, NULL);
  if(ret==0) return(3);

  strcpy(str, " 0"); if(verbose>1) printf("str := '%s'\n", str);
  ret=floatGetWithUnit(str, &v, NULL); if(verbose>2) printf("  -> %g\n", v);
  if(ret==0 || !isnan(v)) return(4);

  // below fabs() used instead of fabsf() because compiler converts values to doubles
  strcpy(str, "1.2345"); if(verbose>1) printf("str := '%s'\n", str);
  ret=floatGetWithUnit(str, &v, NULL); if(verbose>2) printf("  -> %g\n", v);
  if(ret!=0 || fabs(v-1.2345)>1.0E-006) return(11);
  strcpy(str, "1,2345"); if(verbose>1) printf("str := '%s'\n", str);
  ret=floatGetWithUnit(str, &v, NULL); if(verbose>2) printf("  -> %g\n", v);
  if(ret!=0 || fabs(v-1.2345)>1.0E-006) return(12);
  strcpy(str, "+1.2345E4"); if(verbose>1) printf("str := '%s'\n", str);
  ret=floatGetWithUnit(str, &v, NULL); if(verbose>2) printf("  -> %g\n", v);
  if(ret!=0 || fabs(v-12345.0)>1.0E-006) return(13);
  strcpy(str, "-1,2345E4"); if(verbose>1) printf("str := '%s'\n", str);
  ret=floatGetWithUnit(str, &v, NULL); if(verbose>2) printf("  -> %g\n", v);
  if(ret!=0 || fabs(v-(-12345.0))>1.0E-006) return(14);

  strcpy(str, "1.2345 sec"); if(verbose>1) printf("str := '%s'\n", str);
  ret=floatGetWithUnit(str, &v, &unit); 
  if(verbose>2) printf("  -> %g %s\n", v, unitName(unit));
  if(ret!=0 || fabs(v-1.2345)>1.0E-006 || unit!=UNIT_SEC) return(21);
  strcpy(str, "1,2345 viallinen"); if(verbose>1) printf("str := '%s'\n", str);
  ret=floatGetWithUnit(str, &v, &unit); 
  if(verbose>2) printf("  -> %g %s\n", v, unitName(unit));
  if(ret!=0 || fabs(v-1.2345)>1.0E-006 || unit!=UNIT_UNKNOWN) return(22);
  strcpy(str, "+1.2345E4  min"); if(verbose>1) printf("str := '%s'\n", str);
  ret=floatGetWithUnit(str, &v, &unit); if(verbose>2) printf("  -> %g\n", v);
  if(ret!=0 || fabs(v-12345.0)>1.0E-006 || unit!=UNIT_MIN) return(23);
  strcpy(str, "-1,2345E4 1/min"); if(verbose>1) printf("str := '%s'\n", str);
  ret=floatGetWithUnit(str, &v, &unit); if(verbose>2) printf("  -> %g\n", v);
  if(ret!=0 || fabs(v-(-12345.0))>1.0E-006 || unit!=UNIT_PER_MIN) return(24);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_floatSpanPositives(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int gi, gn;
  float g[20], *gp;

  g[0]=0.0;
  g[1]=1.0;
  g[2]=2.0;
  g[3]=3.0;
  g[4]=4.0;
  g[5]=0.0;
  g[6]=-1.0;
  g[7]=nanf("");
  g[8]=0.0;
  g[9]=5.0;
  g[10]=nanf("");
  g[11]=6.0;
  g[12]=7.0;
  g[13]=-1.0;
  g[14]=0.0;
  g[15]=0.0;
  g[16]=0.0;
  g[17]=0.0;
  g[18]=0.0;
  g[19]=0.0;

  if(verbose>1) printf("\nNULL data\n");
  gi=floatSpanPositives(NULL, 0); if(verbose>3) printf("  -> %d\n", gi);
  if(gi!=0) return(1);
  gi=floatSpanPositives(NULL, 10); if(verbose>3) printf("  -> %d\n", gi);
  if(gi!=0) return(2);
  gi=floatSpanPositives(g, 0); if(verbose>3) printf("  -> %d\n", gi);
  if(gi!=0) return(3);

  if(verbose>1) printf("\nArray starts with zero\n");
  gn=20; gp=g; 
  if(verbose>3) for(int i=0; i<gn; i++) printf(" a[%d]=%g\n", i, gp[i]);
  gi=floatSpanPositives(gp, gn); if(verbose>3) printf("  -> %d\n", gi);
  if(gi!=0) return(10);

  if(verbose>1) printf("\nArray starts with nanf\n");
  gn=7; gp=&g[10]; 
  if(verbose>3) for(int i=0; i<gn; i++) printf(" a[%d]=%g\n", i, gp[i]);
  gi=floatSpanPositives(gp, gn); if(verbose>3) printf("  -> %d\n", gi);
  if(gi!=0) return(11);

  if(verbose>1) printf("\nArray stops with zero\n");
  gn=19; gp=&g[1]; 
  if(verbose>3) for(int i=0; i<gn; i++) printf(" a[%d]=%g\n", i, gp[i]);
  gi=floatSpanPositives(gp, gn); if(verbose>3) printf("  -> %d\n", gi);
  if(gi!=4) return(12);

  if(verbose>1) printf("\nArray stops with negative\n");
  gn=5; gp=&g[11]; 
  if(verbose>3) for(int i=0; i<gn; i++) printf(" a[%d]=%g\n", i, gp[i]);
  gi=floatSpanPositives(gp, gn); if(verbose>3) printf("  -> %d\n", gi);
  if(gi!=2) return(13);

  if(verbose>1) printf("\nArray stops with N\n");
  gn=3; gp=&g[1]; 
  if(verbose>3) for(int i=0; i<gn; i++) printf(" a[%d]=%g\n", i, gp[i]);
  gi=floatSpanPositives(gp, gn); if(verbose>3) printf("  -> %d\n", gi);
  if(gi!=3) return(14);

  if(verbose>1) printf("\nArray has nothing but zeroes\n");
  gn=4; gp=&g[16]; 
  if(verbose>3) for(int i=0; i<gn; i++) printf(" a[%d]=%g\n", i, gp[i]);
  gi=floatSpanPositives(gp, gn); if(verbose>3) printf("  -> %d\n", gi);
  if(gi!=0) return(15);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_floatCSpanPositives(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int gi, gn;
  float g[20], *gp;

  g[0]=0.0;
  g[1]=1.0;
  g[2]=2.0;
  g[3]=3.0;
  g[4]=4.0;
  g[5]=0.0;
  g[6]=-1.0;
  g[7]=nanf("");
  g[8]=0.0;
  g[9]=5.0;
  g[10]=nanf("");
  g[11]=6.0;
  g[12]=7.0;
  g[13]=-1.0;
  g[14]=0.0;
  g[15]=0.0;
  g[16]=0.0;
  g[17]=0.0;
  g[18]=0.0;
  g[19]=0.0;

  if(verbose>1) printf("\nNULL data\n");
  gi=floatCSpanPositives(NULL, 0); if(verbose>3) printf("  -> %d\n", gi);
  if(gi!=0) return(1);
  gi=floatCSpanPositives(NULL, 10); if(verbose>3) printf("  -> %d\n", gi);
  if(gi!=0) return(2);
  gi=floatCSpanPositives(g, 0); if(verbose>3) printf("  -> %d\n", gi);
  if(gi!=0) return(3);

  if(verbose>1) printf("\nArray starts with zero\n");
  gn=20; gp=g; 
  if(verbose>3) for(int i=0; i<gn; i++) printf(" a[%d]=%g\n", i, gp[i]);
  gi=floatCSpanPositives(gp, gn); if(verbose>3) printf("  -> %d\n", gi);
  if(gi!=1) return(10);

  if(verbose>1) printf("\nArray starts with nanf followed by zero\n");
  gn=10; gp=&g[7]; 
  if(verbose>3) for(int i=0; i<gn; i++) printf(" a[%d]=%g\n", i, gp[i]);
  gi=floatCSpanPositives(gp, gn); if(verbose>3) printf("  -> %d\n", gi);
  if(gi!=2) return(11);

  if(verbose>1) printf("\nArray has negative, nanf and zero\n");
  gn=11; gp=&g[6]; 
  if(verbose>3) for(int i=0; i<gn; i++) printf(" a[%d]=%g\n", i, gp[i]);
  gi=floatCSpanPositives(gp, gn); if(verbose>3) printf("  -> %d\n", gi);
  if(gi!=3) return(12);

  if(verbose>1) printf("\nArray stops with N\n");
  gn=6; gp=&g[14]; 
  if(verbose>3) for(int i=0; i<gn; i++) printf(" a[%d]=%g\n", i, gp[i]);
  gi=floatCSpanPositives(gp, gn); if(verbose>3) printf("  -> %d\n", gi);
  if(gi!=6) return(13);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_floatNonzeroes(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  unsigned int gi, gn;
  float g[20], *gp;

  g[0]=0.0;
  g[1]=1.0;
  g[2]=2.0;
  g[3]=3.0;
  g[4]=4.0;
  g[5]=0.0;
  g[6]=-1.0;
  g[7]=nanf("");
  g[8]=0.0;
  g[9]=5.0;
  g[10]=nanf("");
  g[11]=6.0;
  g[12]=7.0;
  g[13]=-1.0;
  g[14]=0.0;
  g[15]=0.0;
  g[16]=0.0;
  g[17]=0.0;
  g[18]=0.0;
  g[19]=0.0;

  if(verbose>1) printf("\nNULL data\n");
  gi=floatNonzeroes(NULL, 0); if(verbose>3) printf("  -> %d\n", gi);
  if(gi!=0) return(1);
  gi=floatNonzeroes(NULL, 10); if(verbose>3) printf("  -> %d\n", gi);
  if(gi!=0) return(2);
  gi=floatNonzeroes(g, 0); if(verbose>3) printf("  -> %d\n", gi);
  if(gi!=0) return(3);

  if(verbose>1) printf("\nArray contains only zeroes\n");
  gn=1; gp=g; 
  if(verbose>3) for(unsigned int i=0; i<gn; i++) printf(" a[%d]=%g\n", i, gp[i]);
  gi=floatNonzeroes(gp, gn); if(verbose>3) printf("  -> %d\n", gi);
  if(gi!=0) return(10);
  gn=5; gp=g+14; 
  if(verbose>3) for(unsigned int i=0; i<gn; i++) printf(" a[%d]=%g\n", i, gp[i]);
  gi=floatNonzeroes(gp, gn); if(verbose>3) printf("  -> %d\n", gi);
  if(gi!=0) return(11);

  if(verbose>1) printf("\nArray contains ... what not\n");
  gn=20; gp=g; 
  if(verbose>3) for(unsigned int i=0; i<gn; i++) printf(" a[%d]=%g\n", i, gp[i]);
  gi=floatNonzeroes(gp, gn); if(verbose>3) printf("  -> %d\n", gi);
  if(gi!=9) return(20);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
