/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpcfileutil.h"
/*****************************************************************************/

/*****************************************************************************/
int test_pathExist(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int ret;
  char fname[FILENAME_MAX];
  FILE *fp;

  if(verbose>1) printf("\nTrying with NULL input...\n");
  ret=pathExist(NULL);
  if(ret==1) return(1);

  if(verbose>1) printf("\nTrying with non-existing path...\n");
  strcpy(fname, "nonexisting.dir");
  ret=pathExist(fname);
  if(ret==1) return(2);

  if(verbose>1) printf("\nTrying with existing file...\n");
  strcpy(fname, "existing.txt");
  fp=fopen(fname, "w"); fclose(fp);
  ret=pathExist(fname);
  if(ret==1) return(3);
  remove(fname);

  if(verbose>1) printf("\nTrying with existing path...\n");
  strcpy(fname, "../test");
  ret=pathExist(fname);
  if(ret!=1) return(4);

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_pathRemove(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int ret;
  char fname[FILENAME_MAX];
  FILE *fp;

  if(verbose>1) printf("\nTrying with NULL input...\n");
  ret=pathRemove(NULL);
  if(ret!=0) return(1);

  if(verbose>1) printf("\nTrying with non-existing path...\n");
  strcpy(fname, "nonexisting2.dir");
  ret=pathRemove(fname);
  if(ret!=0) return(2);

  if(verbose>1) printf("\nTrying with existing file...\n");
  strcpy(fname, "existing2.txt");
  fp=fopen(fname, "w"); fclose(fp);
  ret=pathRemove(fname);
  remove(fname);
  if(ret==0) return(3);

  if(verbose>1) printf("\nTrying with existing path that cannot be removed...\n");
  strcpy(fname, "../test");
  ret=pathRemove(fname);
  if(ret==0) return(4);

  if(verbose>1) printf("\nTrying with valid existing path tested elsewhere\n");

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_pathCreate(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int ret;
  char fname[FILENAME_MAX], fname2[FILENAME_MAX];
  FILE *fp;

  if(verbose>1) printf("\nTrying with NULL input...\n");
  ret=pathCreate(NULL);
  if(ret==0) return(1);

  strcpy(fname, ".");
  if(verbose>1) printf("\nTrying with '%s'\n", fname);
  ret=pathCreate(fname);
  if(ret!=0) return(2);

  strcpy(fname, "..");
  if(verbose>1) printf("\nTrying with '%s'\n", fname);
  ret=pathCreate(fname);
  if(ret!=0) return(3);

  strcpy(fname, "./");
  if(verbose>1) printf("\nTrying with '%s'\n", fname);
  ret=pathCreate(fname);
  if(ret!=0) return(4);

  strcpy(fname, "../");
  if(verbose>1) printf("\nTrying with '%s'\n", fname);
  ret=pathCreate(fname);
  if(ret!=0) return(5);


  if(verbose>1) printf("\nTrying with existing file...\n");
  strcpy(fname, "existing3.txt");
  fp=fopen(fname, "w"); fclose(fp);
  ret=pathCreate(fname);
  remove(fname);
  if(ret==0) return(11);


  strcpy(fname, "testpath3");
  if(verbose>1) printf("\nTrying with '%s'\n", fname);
  ret=pathCreate(fname);
  if(ret!=0) return(21);
  if(!pathExist(fname)) return(22);
  if(pathRemove(fname)) return(23);

  strcpy(fname, "testpath3/");
  if(verbose>1) printf("\nTrying with '%s'\n", fname);
  ret=pathCreate(fname);
  if(ret!=0) return(24);
  if(!pathExist(fname)) return(25);
  if(pathRemove(fname)) return(26);


  strcpy(fname, "testpath3/test");
  if(verbose>1) printf("\nTrying with '%s'\n", fname);
  ret=pathCreate(fname);
  if(ret!=0) return(31);
  if(!pathExist(fname)) return(32);

  if(verbose>1) printf("\nTrying with '%s' again\n", fname);
  ret=pathCreate(fname);
  if(ret!=0) return(33);
  if(!pathExist(fname)) return(34);

  strcpy(fname2, "testpath3/test2");
  if(verbose>1) printf("\nTrying with '%s'\n", fname2);
  ret=pathCreate(fname2);
  if(ret!=0) return(35);
  if(!pathExist(fname2)) return(36);

  if(pathRemove(fname2)) return(37);
  if(pathRemove(fname)) return(38);
  if(pathRemove("testpath3")) return(39);


  strcpy(fname, "../test/testpath3");
  strcpy(fname2, "../test/testpath3/test/");
  if(verbose>1) printf("\nTrying with '%s'\n", fname2);
  ret=pathCreate(fname2);
  if(ret!=0) return(41);
  if(!pathExist(fname2)) return(42);

  if(pathRemove(fname2)) return(43);
  if(pathRemove(fname)) return(44);
  if(pathExist(fname)) return(45);


  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
