/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpcift.h"
/*****************************************************************************/

/*****************************************************************************/
int test_iftFindKey(
  int verbose
) {
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int i, n;
  IFT ift;

  iftInit(&ift);
  i=iftFindKey(&ift, NULL, 0); if(i>=0) return 1;
  i=iftFindKey(&ift, "", 0); if(i>=0) return 2;
  i=iftFindKey(&ift, "", -1); if(i>=0) return 3;
  i=iftFindKey(&ift, "", 10); if(i>=0) return 4;
  i=iftFindKey(&ift, "ach", 0); if(i>=0) return 5;

  iftPut(&ift, "testkey", "testvalue", 0, NULL);
  iftPut(&ift, "testkey2", "testvalue2", 0, NULL);
  iftPut(&ift, "unit", "ms", 0, NULL);
  iftPut(&ift, "unit", "s", 0, NULL);
  iftPut(&ift, "unit", "min", 0, NULL);

  i=iftFindKey(&ift, NULL, 0); if(i>=0) {iftFree(&ift); return 11;}
  i=iftFindKey(&ift, "", 0); if(i>=0) {iftFree(&ift); return 12;}
  i=iftFindKey(&ift, "", -1); if(i>=0) {iftFree(&ift); return 13;}
  i=iftFindKey(&ift, "", 10); if(i>=0) {iftFree(&ift); return 14;}
  i=iftFindKey(&ift, "ach", 0); if(i>=0) {iftFree(&ift); return 15;}

  i=iftFindKey(&ift, "testkey", 0); if(i!=0) {iftFree(&ift); return 21;}
  i=iftFindKey(&ift, "unit", 0); if(i!=2) {iftFree(&ift); return 22;}
  i=iftFindKey(&ift, "TESTKEY2", 0); if(i!=1) {iftFree(&ift); return 23;}

  i=n=0; while((i=iftFindKey(&ift, "unit", i))>=0) {
    if(verbose>1) iftWriteItem(&ift, i, stdout, NULL);
    i++; n++;
  }
  if(n!=3) {iftFree(&ift); return 31;}

  iftFree(&ift);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_iftFindPair(
  int verbose
) {
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int i;
  IFT ift;
  
  iftInit(&ift);
  i=iftFindPair(&ift, NULL, NULL, 0); if(i>=0) return 1;
  i=iftFindPair(&ift, "", "", 0); if(i>=0) return 2;
  i=iftFindPair(&ift, "", "", -1); if(i>=0) return 3;
  i=iftFindPair(&ift, "", "", 10); if(i>=0) return 4;
  i=iftFindPair(&ift, "ach", "so", 0); if(i>=0) return 5;

  iftPut(&ift, "testkey", "testvalue", 0, NULL);
  iftPut(&ift, "testkey", "testvalue2", 0, NULL);
  iftPut(&ift, "testkey", "testvalue3", 0, NULL);
  iftPut(&ift, "testkey2", "testvalue2", 0, NULL);

  i=iftFindPair(&ift, "key", "testvalue2", 0);
  if(i>=0) {iftFree(&ift); return 11;}
  i=iftFindPair(&ift, "testkey", "testvalue1", 0);
  if(i>=0) {iftFree(&ift); return 12;}

  i=iftFindPair(&ift, "testkey", "testvalue2", 0);
  if(i!=1) {iftFree(&ift); return 22;}
  if(verbose>1) iftWriteItem(&ift, i, stdout, NULL);
  i=iftFindPair(&ift, "testkey", "testvalue2", 2);
  if(i>=0) {iftFree(&ift); return 23;}

  iftFree(&ift);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_iftSearchKey(
  int verbose
) {
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int i, n;
  IFT ift;

  iftInit(&ift);
  i=iftSearchKey(&ift, NULL, 0); if(i>=0) return 1;
  i=iftSearchKey(&ift, "", 0); if(i>=0) return 2;
  i=iftSearchKey(&ift, "", -1); if(i>=0) return 3;
  i=iftSearchKey(&ift, "", 10); if(i>=0) return 4;
  i=iftSearchKey(&ift, "ach", 0); if(i>=0) return 5;

  iftPut(&ift, "testkey", "testvalue", 0, NULL);
  iftPut(&ift, "testkey2", "testvalue2", 0, NULL);
  iftPut(&ift, "Unit1", "ms", 0, NULL);
  iftPut(&ift, "Unit2", "s", 0, NULL);
  iftPut(&ift, "Unit3", "min", 0, NULL);

  i=iftSearchKey(&ift, NULL, 0); if(i>=0) {iftFree(&ift); return 11;}
  i=iftSearchKey(&ift, "", 0); if(i>=0) {iftFree(&ift); return 12;}
  i=iftSearchKey(&ift, "", -1); if(i>=0) {iftFree(&ift); return 13;}
  i=iftSearchKey(&ift, "", 10); if(i>=0) {iftFree(&ift); return 14;}
  i=iftSearchKey(&ift, "ach", 0); if(i>=0) {iftFree(&ift); return 15;}

  i=iftSearchKey(&ift, "testkey", 0); if(i!=0) {iftFree(&ift); return 21;}
  i=iftSearchKey(&ift, "unit", 0); if(i!=2) {iftFree(&ift); return 22;}
  i=iftSearchKey(&ift, "TESTKEY2", 0); if(i!=1) {iftFree(&ift); return 23;}

  i=n=0; while((i=iftSearchKey(&ift, "unit", i))>=0) {
    if(verbose>1) iftWriteItem(&ift, i, stdout, NULL);
    i++; n++;
  }
  if(n!=3) {iftFree(&ift); return 31;}

  iftFree(&ift);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_iftSearchValue(
  int verbose
) {
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  int i, n;
  IFT ift;

  iftInit(&ift);
  i=iftSearchValue(&ift, NULL, 0); if(i>=0) return 1;
  i=iftSearchValue(&ift, "", 0); if(i>=0) return 2;
  i=iftSearchValue(&ift, "", -1); if(i>=0) return 3;
  i=iftSearchValue(&ift, "", 10); if(i>=0) return 4;
  i=iftSearchValue(&ift, "ach", 0); if(i>=0) return 5;

  iftPut(&ift, "key",  "value", 0, NULL);
  iftPut(&ift, "key2", "value2", 0, NULL);
  iftPut(&ift, "key3", "valu", 0, NULL);
  iftPut(&ift, "key4", "48", 0, NULL);
  iftPut(&ift, "key5", "Value5", 0, NULL);

  i=iftSearchValue(&ift, NULL, 0); if(i>=0) {iftFree(&ift); return 11;}
  i=iftSearchValue(&ift, "", 0); if(i>=0) {iftFree(&ift); return 12;}
  i=iftSearchValue(&ift, "", -1); if(i>=0) {iftFree(&ift); return 13;}
  i=iftSearchValue(&ift, "", 10); if(i>=0) {iftFree(&ift); return 14;}
  i=iftSearchValue(&ift, "ach", 0); if(i>=0) {iftFree(&ift); return 15;}
  i=iftSearchValue(&ift, "key", 0); if(i>=0) {iftFree(&ift); return 15;}

  i=iftSearchValue(&ift, "value", 0); if(i!=0) {iftFree(&ift); return 21;}
  i=iftSearchValue(&ift, "48", 0); if(i!=3) {iftFree(&ift); return 22;}
  i=iftSearchValue(&ift, "VALUE2", 0); if(i!=1) {iftFree(&ift); return 23;}
  i=iftSearchValue(&ift, "LU", 0); if(i!=0) {iftFree(&ift); return 24;}
  i=iftSearchValue(&ift, "5", 0); if(i!=4) {iftFree(&ift); return 25;}

  i=n=0; while((i=iftSearchValue(&ift, "lue", i))>=0) {
    if(verbose>1) iftWriteItem(&ift, i, stdout, NULL);
    i++; n++;
  }
  if(n!=3) {iftFree(&ift); return 31;}

  iftFree(&ift);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_iftFindNrOfKeys(
  int verbose
) {
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int i;
  IFT ift;

  iftInit(&ift);
  i=iftFindNrOfKeys(&ift, NULL); if(i!=0) return 1;
  i=iftFindNrOfKeys(&ift, ""); if(i!=0) return 2;
  i=iftFindNrOfKeys(&ift, ""); if(i!=0) return 3;
  i=iftFindNrOfKeys(&ift, ""); if(i!=0) return 4;
  i=iftFindNrOfKeys(&ift, "ach"); if(i!=0) return 5;

  iftPut(&ift, "key", "1", 0, NULL);
  iftPut(&ift, "key2", "2", 0, NULL);
  iftPut(&ift, "Key", "3", 0, NULL);
  iftPut(&ift, "",   "empty", 0, NULL);
  iftPut(&ift, NULL, "empty", 0, NULL);
  iftPut(&ift, "key_nr", "4", 0, NULL);
  iftPut(&ift, "key", "5", 0, NULL);

  i=iftFindNrOfKeys(&ift, NULL); if(i!=2) {iftFree(&ift); return 11;}
  i=iftFindNrOfKeys(&ift, ""); if(i!=2) {iftFree(&ift); return 12;}
  i=iftFindNrOfKeys(&ift, "ach"); if(i!=0) {iftFree(&ift); return 13;}

  i=iftFindNrOfKeys(&ift, "key"); if(verbose>1) printf("nr_of_keys := %d\n", i);
  if(i!=3) {iftFree(&ift); return 21;}
  i=iftFindNrOfKeys(&ift, "empty"); if(i!=0) {iftFree(&ift); return 22;}
  i=iftFindNrOfKeys(&ift, "KEY2"); if(i!=1) {iftFree(&ift); return 23;}

  iftFree(&ift);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_iftDeleteKey(
  int verbose
) {
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  IFT ift;
  int ret;
  iftInit(&ift);
  
  iftDeleteKey(&ift, "key");
  
  ret=iftPut(&ift, "key1", "value1", 0, NULL);
  if(ret!=TPCERROR_OK) {iftFree(&ift); return 11;}
  ret=iftPut(&ift, "key2", "value2", 0, NULL);
  if(ret!=TPCERROR_OK) {iftFree(&ift); return 12;}
  ret=iftPut(&ift, "key2", "value3", 0, NULL);
  if(ret!=TPCERROR_OK) {iftFree(&ift); return 13;}
  if(ift.keyNr!=3) {iftFree(&ift); return 14;}
  iftDeleteKey(&ift, "Key2");
  if(ift.keyNr!=1) {iftFree(&ift); return 15;}
  iftFree(&ift);
  
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_iftGetDoubleValue(
  int verbose
) {
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int i;
  double v;
  IFT ift;

  iftInit(&ift);
  i=iftGetDoubleValue(&ift, NULL, 0, &v); if(i>=0 || !isnan(v)) return 1;
  i=iftGetDoubleValue(&ift, "", 0, &v); if(i>=0 || !isnan(v)) return 2;
  i=iftGetDoubleValue(&ift, "", -1, &v); if(i>=0 || !isnan(v)) return 3;
  i=iftGetDoubleValue(&ift, "", 10, &v); if(i>=0 || !isnan(v)) return 4;
  i=iftGetDoubleValue(&ift, "ach", 0, &v); if(i>=0 || !isnan(v)) return 5;

  iftPutDouble(&ift, "testkey", 3.14, 0, NULL);
  iftPutDouble(&ift, "testkey2", -3.14, 0, NULL);
  iftPut(&ift, "nonvalue", "ms", 0, NULL);
  iftPutDouble(&ift, "value", 1.0E+06, 0, NULL);
  iftPutDouble(&ift, "value", 2.0E+06, 0, NULL);

  i=iftGetDoubleValue(&ift, NULL, 0, &v); if(i>=0 || !isnan(v)) {iftFree(&ift); return 11;}
  i=iftGetDoubleValue(&ift, "", 0, &v); if(i>=0 || !isnan(v)) {iftFree(&ift); return 12;}
  i=iftGetDoubleValue(&ift, "", -1, &v); if(i>=0 || !isnan(v)) {iftFree(&ift); return 13;}
  i=iftGetDoubleValue(&ift, "", 10, &v); if(i>=0 || !isnan(v)) {iftFree(&ift); return 14;}
  i=iftGetDoubleValue(&ift, "ach", 0, &v); if(i>=0 || !isnan(v)) {iftFree(&ift); return 15;}

  i=iftGetDoubleValue(&ift, "testkey", 0, &v); 
  if(i!=0 || !doubleMatch(v, 3.14, 1.0E-10)) {iftFree(&ift); return 21;}
  i=iftGetDoubleValue(&ift, "testkey", 1, &v); if(i>=0 || !isnan(v)) {iftFree(&ift); return 22;}
  i=iftGetDoubleValue(&ift, "nonvalue", 0, &v); if(i>=0 || !isnan(v)) {iftFree(&ift); return 23;}
  i=iftGetDoubleValue(&ift, "TESTKEY2", 0, &v);
  if(i!=1 || !doubleMatch(v, -3.14, 1.0E-10)) {iftFree(&ift); return 24;}

  i=iftGetDoubleValue(&ift, "value", 0, &v);
  if(i!=3 || !doubleMatch(v, 1.0E+06, 1.0E-03)) {iftFree(&ift); return 31;}
  i=iftGetDoubleValue(&ift, "value", i+1, &v);
  if(i!=4 || !doubleMatch(v, 2.0E+06, 1.0E-03)) {iftFree(&ift); return 32;}

  iftFree(&ift);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
