/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpcift.h"
/*****************************************************************************/

/*****************************************************************************/
int test_iftGetFloat(
  int verbose
) {
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  IFT ift;
  int ret;
  float f;

  iftInit(&ift);
  ret=iftGetFloat(&ift, 0, &f); if(ret==0 || !isnan(f)) return 1;

  iftPut(&ift, NULL, "0", 1, NULL);
  iftPut(&ift, NULL, "1.23", 1, NULL);
  iftPut(&ift, "key1", "+1.23E-003", 1, NULL);
  iftPut(&ift, "key2", "+1.2345E-003", 0, NULL);
  iftPut(&ift, "key3", "-987654.3", 0, NULL);
  if(verbose>1) iftWrite(&ift, stdout, NULL);

  ret=iftGetFloat(&ift, -1, &f); if(verbose>2) printf("  -> %f\n", f);
  if(ret==0 || !isnan(f)) {iftFree(&ift); return 2;}
  ret=iftGetFloat(&ift, 678, &f); if(verbose>2) printf("  -> %f\n", f);
  if(ret==0 || !isnan(f)) {iftFree(&ift); return 3;}

  ret=iftGetFloat(&ift, 0, &f); if(verbose>2) printf("  -> %f\n", f);
  if(ret!=0 || f!=0) {iftFree(&ift); return 11;}
  ret=iftGetFloat(&ift, 1, &f); if(verbose>2) printf("  -> %f\n", f);
  if(ret!=0 || fabsf(f-(float)1.23)>1.0E-6) {iftFree(&ift); return 12;}
  ret=iftGetFloat(&ift, 2, &f); if(verbose>2) printf("  -> %f\n", f);
  if(ret!=0 || fabsf(f-(float)0.00123)>1.0e-6) {iftFree(&ift); return 13;}
  ret=iftGetFloat(&ift, 3, &f); if(verbose>2) printf("  -> %f\n", f);
  if(ret!=0 || fabsf(f-(float)0.0012345)>1.0E-6) {iftFree(&ift); return 14;}
  ret=iftGetFloat(&ift, 4, &f); if(verbose>2) printf("  -> %f\n", f);
  if(ret!=0 || fabsf(f-(float)(-987654.3))>0.1) {iftFree(&ift); return 15;}

  char key[64];
  strcpy(key, "none"); if(verbose>1) printf("key = '%s'\n", key);
  ret=iftGetFloat(&ift, iftFindKey(&ift, key, 0), &f);
  if(verbose>2) printf("  -> %f\n", f);
  if(ret==0 || !isnan(f)) {iftFree(&ift); return 21;}

  strcpy(key, "key2"); if(verbose>1) printf("key = '%s'\n", key);
  ret=iftGetFloat(&ift, iftFindKey(&ift, key, 0), &f);
  if(verbose>2) printf("  -> %f\n", f);
  if(ret!=0 || fabsf(f-(float)0.0012345)>1.0E-6) {iftFree(&ift); return 14;}

  iftFree(&ift);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_iftGetDouble(
  int verbose
) {
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  IFT ift;
  int ret;
  double f;

  iftInit(&ift);
  ret=iftGetDouble(&ift, 0, &f); if(ret==0 || !isnan(f)) return 1;

  iftPut(&ift, NULL, "0", 1, NULL);
  iftPut(&ift, NULL, "1.23", 1, NULL);
  iftPut(&ift, "key1", "+1.23E-003", 1, NULL);
  iftPut(&ift, "key2", "+1.2345E-003", 0, NULL);
  iftPut(&ift, "key3", "-987654.3", 0, NULL);
  if(verbose>1) iftWrite(&ift, stdout, NULL);

  ret=iftGetDouble(&ift, -1, &f); if(verbose>2) printf("  -> %f\n", f);
  if(ret==0 || !isnan(f)) {iftFree(&ift); return 2;}
  ret=iftGetDouble(&ift, 678, &f); if(verbose>2) printf("  -> %f\n", f);
  if(ret==0 || !isnan(f)) {iftFree(&ift); return 3;}

  ret=iftGetDouble(&ift, 0, &f); if(verbose>2) printf("  -> %f\n", f);
  if(ret!=0 || f!=0) {iftFree(&ift); return 11;}
  ret=iftGetDouble(&ift, 1, &f); if(verbose>2) printf("  -> %f\n", f);
  if(ret!=0 || fabs(f-1.23)>1.0E-20) {iftFree(&ift); return 12;}
  ret=iftGetDouble(&ift, 2, &f); if(verbose>2) printf("  -> %f\n", f);
  if(ret!=0 || fabs(f-0.00123)>1.0e-20) {iftFree(&ift); return 13;}
  ret=iftGetDouble(&ift, 3, &f); if(verbose>2) printf("  -> %f\n", f);
  if(ret!=0 || fabs(f-0.0012345)>1.0E-20) {iftFree(&ift); return 14;}
  ret=iftGetDouble(&ift, 4, &f); if(verbose>2) printf("  -> %f\n", f);
  if(ret!=0 || fabs(f-(-987654.3))>1.0E-20) {iftFree(&ift); return 15;}

  char key[64];
  strcpy(key, "none"); if(verbose>1) printf("key = '%s'\n", key);
  ret=iftGetDouble(&ift, iftFindKey(&ift, key, 0), &f);
  if(verbose>2) printf("  -> %f\n", f);
  if(ret==0 || !isnan(f)) {iftFree(&ift); return 21;}

  strcpy(key, "key2"); if(verbose>1) printf("key = '%s'\n", key);
  ret=iftGetDouble(&ift, iftFindKey(&ift, key, 0), &f);
  if(verbose>2) printf("  -> %f\n", f);
  if(ret!=0 || fabs(f-0.0012345)>1.0E-20) {iftFree(&ift); return 14;}

  iftFree(&ift);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_iftGetInt(
  int verbose
) {
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  IFT ift;
  int ret;
  int v;

  iftInit(&ift);
  ret=iftGetInt(&ift, 0, &v); if(ret==0 || v!=-9999) return 1;

  iftPut(&ift, NULL, "0", 1, NULL);
  iftPut(&ift, NULL, "123", 1, NULL);
  iftPut(&ift, "key1", "+1.23", 1, NULL);
  iftPut(&ift, "key2", "+123,45", 0, NULL);
  iftPut(&ift, "key3", "-987654", 0, NULL);
  if(verbose>1) iftWrite(&ift, stdout, NULL);

  ret=iftGetInt(&ift, -1, &v); if(verbose>2) printf("  -> %d\n", v);
  if(ret==0 || v!=-9999) {iftFree(&ift); return 2;}
  ret=iftGetInt(&ift, 678, &v); if(verbose>2) printf("  -> %d\n", v);
  if(ret==0 || v!=-9999) {iftFree(&ift); return 3;}

  ret=iftGetInt(&ift, 0, &v); if(verbose>2) printf("  -> %d\n", v);
  if(ret!=0 || v!=0) {iftFree(&ift); return 11;}
  ret=iftGetInt(&ift, 1, &v); if(verbose>2) printf("  -> %d\n", v);
  if(ret!=0 || v!=123) {iftFree(&ift); return 12;}
  ret=iftGetInt(&ift, 2, &v); if(verbose>2) printf("  -> %d\n", v);
  if(ret!=0 || v!=1) {iftFree(&ift); return 13;}
  ret=iftGetInt(&ift, 3, &v); if(verbose>2) printf("  -> %d\n", v);
  if(ret!=0 || v!=123) {iftFree(&ift); return 14;}
  ret=iftGetInt(&ift, 4, &v); if(verbose>2) printf("  -> %d\n", v);
  if(ret!=0 || v!=-987654) {iftFree(&ift); return 15;}

  char key[64];
  strcpy(key, "none"); if(verbose>1) printf("key = '%s'\n", key);
  ret=iftGetInt(&ift, iftFindKey(&ift, key, 0), &v);
  if(verbose>2) printf("  -> %d\n", v);
  if(ret==0 || v!=-9999) {iftFree(&ift); return 21;}

  strcpy(key, "key2"); if(verbose>1) printf("key = '%s'\n", key);
  ret=iftGetInt(&ift, iftFindKey(&ift, key, 0), &v);
  if(verbose>2) printf("  -> %d\n", v);
  if(ret!=0 || v!=123) {iftFree(&ift); return 22;}
    
  iftFree(&ift);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_iftGetUInt(
  int verbose
) {
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  IFT ift;
  int ret;
  unsigned int v;

  iftInit(&ift);
  ret=iftGetUInt(&ift, 0, &v); if(ret==0 || v!=0) return 1;

  iftPutUInt(&ift, NULL, 0, 1, NULL);
  iftPutUInt(&ift, NULL, 123, 1, NULL);
  iftPutUInt(&ift, "key1", (unsigned int)1.23, 1, NULL);
  iftPutUInt(&ift, "key2", +123, 0, NULL);
  iftPutUInt(&ift, "key3", 987654, 0, NULL);
  if(verbose>1) iftWrite(&ift, stdout, NULL);

  ret=iftGetUInt(&ift, -1, &v); if(verbose>2) printf("  -> %d\n", v);
  if(ret==0 || v!=0) {iftFree(&ift); return 2;}
  ret=iftGetUInt(&ift, 678, &v); if(verbose>2) printf("  -> %d\n", v);
  if(ret==0 || v!=0) {iftFree(&ift); return 3;}

  ret=iftGetUInt(&ift, 0, &v); if(verbose>2) printf("  -> %d\n", v);
  if(ret!=0 || v!=0) {iftFree(&ift); return 11;}
  ret=iftGetUInt(&ift, 1, &v); if(verbose>2) printf("  -> %d\n", v);
  if(ret!=0 || v!=123) {iftFree(&ift); return 12;}
  ret=iftGetUInt(&ift, 2, &v); if(verbose>2) printf("  -> %d\n", v);
  if(ret!=0 || v!=1) {iftFree(&ift); return 13;}
  ret=iftGetUInt(&ift, 3, &v); if(verbose>2) printf("  -> %d\n", v);
  if(ret!=0 || v!=123) {iftFree(&ift); return 14;}
  ret=iftGetUInt(&ift, 4, &v); if(verbose>2) printf("  -> %d\n", v);
  if(ret!=0 || v!=987654) {iftFree(&ift); return 15;}

  char key[64];
  strcpy(key, "none"); if(verbose>1) printf("key = '%s'\n", key);
  ret=iftGetUInt(&ift, iftFindKey(&ift, key, 0), &v);
  if(verbose>2) printf("  -> %d\n", v);
  if(ret==0 || v!=0) {iftFree(&ift); return 21;}

  strcpy(key, "key2"); if(verbose>1) printf("key = '%s'\n", key);
  ret=iftGetUInt(&ift, iftFindKey(&ift, key, 0), &v);
  if(verbose>2) printf("  -> %d\n", v);
  if(ret!=0 || v!=123) {iftFree(&ift); return 22;}

  iftFree(&ift);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_iftGetDoubleWithUnit(
  int verbose
) {
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  int i, ret, u;
  double f;
  IFT ift; iftInit(&ift);

  ret=iftGetDoubleWithUnit(&ift, 0, &f, &u); 
  if(ret==0 || !isnan(f) || u!=UNIT_UNKNOWN) return 1;

  iftPut(&ift, NULL, "0 s", 1, NULL);
  iftPut(&ift, NULL, "0", 1, NULL);
  iftPut(&ift, NULL, "1.23 min", 1, NULL);
  iftPut(&ift, "key1", "+1.23E-003 1/s", 1, NULL);
  iftPut(&ift, "key2", "+1.2345E-003 [1/min]", 0, NULL);
  iftPut(&ift, "key3", "-987654.3 [s]", 0, NULL);
  iftPut(&ift, "key4", "323,62 Bq/cc", 0, NULL);
  iftPut(&ift, "key5", "x Bq/cc", 0, NULL);
  if(verbose>1) iftWrite(&ift, stdout, NULL);

  ret=iftGetDoubleWithUnit(&ift, -1, &f, &u);
  if(ret==0 || !isnan(f) || u!=UNIT_UNKNOWN) {iftFree(&ift); return 2;}
  ret=iftGetDoubleWithUnit(&ift, 678, &f, &u);
  if(ret==0 || !isnan(f) || u!=UNIT_UNKNOWN) {iftFree(&ift); return 3;}

  i=0; ret=iftGetDoubleWithUnit(&ift, i, &f, &u); 
  if(verbose>2) printf(" index %d -> %g %s\n", i, f, unitName(u));
  if(ret!=0 || f!=0 || u!=UNIT_SEC) {iftFree(&ift); return 11;}
  i++; ret=iftGetDoubleWithUnit(&ift, i, &f, &u); 
  if(verbose>2) printf(" index %d -> %g %s\n", i, f, unitName(u));
  if(ret!=0 || f!=0 || u!=UNIT_UNKNOWN) {iftFree(&ift); return 12;}
  i++; ret=iftGetDoubleWithUnit(&ift, i, &f, &u); 
  if(verbose>2) printf(" index %d -> %g %s\n", i, f, unitName(u));
  if(ret!=0 || f!=1.23 || u!=UNIT_MIN) {iftFree(&ift); return 13;}

  i=2; ret=iftGetDoubleWithUnit(&ift, i, &f, NULL); 
  if(verbose>2) printf(" index %d -> %g\n", i, f);
  if(ret!=0 || f!=1.23) {iftFree(&ift); return 14;}
  ret=iftGetDoubleWithUnit(&ift, i, NULL, &u); 
  if(verbose>2) printf(" index %d -> %s\n", i, unitName(u));
  if(ret!=0 || u!=UNIT_MIN) {iftFree(&ift); return 15;}

  char key[64];

  strcpy(key, "none"); if(verbose>1) printf("key = '%s'\n", key);
  ret=iftGetDoubleWithUnit(&ift, iftFindKey(&ift, key, 0), &f, &u);
  if(verbose>2) printf("  -> %g %s\n", f, unitName(u));
  if(ret==0 || !isnan(f) || u!=UNIT_UNKNOWN) {iftFree(&ift); return 21;}

  strcpy(key, "key1"); if(verbose>1) printf("key = '%s'\n", key);
  ret=iftGetDoubleWithUnit(&ift, iftFindKey(&ift, key, 0), &f, &u);
  if(verbose>2) printf("  -> %g %s\n", f, unitName(u));
  if(ret!=0 || !doubleMatch(f, 1.23E-003, 1E-20) || u!=UNIT_PER_SEC) {
    iftFree(&ift); return 31;}
  strcpy(key, "key2"); if(verbose>1) printf("key = '%s'\n", key);
  ret=iftGetDoubleWithUnit(&ift, iftFindKey(&ift, key, 0), &f, &u);
  if(verbose>2) printf("  -> %g %s\n", f, unitName(u));
  if(ret!=0 || !doubleMatch(f, 1.2345E-003, 1E-20) || u!=UNIT_PER_MIN) {
    iftFree(&ift); return 32;}
  strcpy(key, "key3"); if(verbose>1) printf("key = '%s'\n", key);
  ret=iftGetDoubleWithUnit(&ift, iftFindKey(&ift, key, 0), &f, &u);
  if(verbose>2) printf("  -> %g %s\n", f, unitName(u));
  if(ret!=0 || !doubleMatch(f, -987654.3, 1E-20) || u!=UNIT_SEC) {
    iftFree(&ift); return 33;}
  strcpy(key, "key4"); if(verbose>1) printf("key = '%s'\n", key);
  ret=iftGetDoubleWithUnit(&ift, iftFindKey(&ift, key, 0), &f, &u);
  if(verbose>2) printf("  -> %g %s\n", f, unitName(u));
  if(ret!=0 || !doubleMatch(f, 323.62, 1E-20) || u!=UNIT_BQ_PER_ML) {
    iftFree(&ift); return 34;}
  strcpy(key, "key5"); if(verbose>1) printf("key = '%s'\n", key);
  ret=iftGetDoubleWithUnit(&ift, iftFindKey(&ift, key, 0), &f, &u);
  if(verbose>2) printf("  -> %g %s\n", f, unitName(u));
  if(ret!=0 || !isnan(f) || u!=UNIT_BQ_PER_ML) {
    iftFree(&ift); return 35;}

  iftFree(&ift);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
