/** @file imageheader.c
    @brief Process header information in IMG structure.
    @copyright (c) Turku PET Centre
    @author Vesa Oikonen
 */
/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcimage.h"
/*****************************************************************************/

/*****************************************************************************/
/** Fill/edit IMG output header.
    @remark Stub function.
    @sa imgInit, imgWrite, imgFree
    @return enum tpcerror (TPCERROR_OK when successful).
 */
int imgFillOHeader(
  /** Pointer to image structure. */
  IMG *img,
  /** Pointer to status data; enter NULL if not needed. */
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  if(verbose>0) {printf("%s(img)\n", __func__); fflush(stdout);}

  if(img==NULL || !imgHasData(img)) {
    statusSet(status, __func__, __FILE__, __LINE__, TPCERROR_NO_DATA);
    return(TPCERROR_NO_DATA);
  }

  /* If output header is empty then copy input header;
     if file formats match, copy directly, otherwise convert contents */
  if(img->oh.keyNr==0 && img->ih.keyNr>0) {
    if(img->format==img->oformat) {
      if(verbose>1) printf("copying header\n");
      if(iftDuplicate(&img->ih, &img->oh)!=TPCERROR_OK) {
        statusSet(status, __func__, __FILE__, __LINE__, TPCERROR_INVALID_HEADER);
        return(TPCERROR_INVALID_HEADER);
      }
    } else {
      if(verbose>1) printf("converting header\n");

    }
  }

  /* Set fields from IMG structure */

  iftDeleteKey(&img->oh, "dimx");
  if(iftPutUInt(&img->oh, "dimx", img->dimz, 0, NULL)!=0) return(TPCERROR_INVALID_HEADER);
  iftDeleteKey(&img->oh, "dimy");
  if(iftPutUInt(&img->oh, "dimy", img->dimz, 0, NULL)!=0) return(TPCERROR_INVALID_HEADER);
  iftDeleteKey(&img->oh, "dimz");
  if(iftPutUInt(&img->oh, "dimz", img->dimz, 0, NULL)!=0) return(TPCERROR_INVALID_HEADER);
  iftDeleteKey(&img->oh, "dimt");
  if(iftPutUInt(&img->oh, "dimt", img->dimz, 0, NULL)!=0) return(TPCERROR_INVALID_HEADER);

  if(img->modality!=IMG_MODALITY_UNKNOWN) {
    iftDeleteKey(&img->oh, "modality");
    if(iftPut(&img->oh, "modality", imgModalityDescr(img->modality), 0, NULL)!=0) 
      return(TPCERROR_INVALID_HEADER);
  }
  if(img->content!=IMG_CONTENT_UNKNOWN) {
    iftDeleteKey(&img->oh, "content");
    if(iftPut(&img->oh, "content", imgContentDescr(img->content), 0, NULL)!=0) 
      return(TPCERROR_INVALID_HEADER);
  }
  if(img->format!=IMG_FORMAT_UNKNOWN) {
    iftDeleteKey(&img->oh, "format");
    if(iftPut(&img->oh, "format", imgFormatDescr(img->format), 0, NULL)!=0) 
      return(TPCERROR_INVALID_HEADER);
  }
  if(img->isot!=ISOTOPE_UNKNOWN) {
    iftDeleteKey(&img->oh, "isotope");
    if(iftPut(&img->oh, "isotope", isotopeName(img->isot), 0, NULL)!=0)
      return(TPCERROR_INVALID_HEADER);
  }
  if(img->decayCorrection!=DECAY_UNKNOWN) {
    iftDeleteKey(&img->oh, "decay_correction");
    char buf[8];
    if(img->decayCorrection==DECAY_CORRECTED) strcpy(buf, "y"); else strcpy(buf, "n");
    if(iftPut(&img->oh, "decay_correction", buf, 0, NULL)!=0)
      return(TPCERROR_INVALID_HEADER);
  }
  if(img->cunit!=UNIT_UNKNOWN) {
    iftDeleteKey(&img->oh, "pixel_unit");
    if(iftPut(&img->oh, "pixel_unit", unitName(img->cunit), 0, NULL)!=0)
      return(TPCERROR_INVALID_HEADER);
  }
  if(img->tunit!=UNIT_UNKNOWN) {
    iftDeleteKey(&img->oh, "time_unit");
    if(iftPut(&img->oh, "time_unit", unitName(img->tunit), 0, NULL)!=0)
      return(TPCERROR_INVALID_HEADER);
  }

  statusSet(status, __func__, __FILE__, __LINE__, TPCERROR_OK);
  return(TPCERROR_OK);
}
/*****************************************************************************/

/*****************************************************************************/

/*****************************************************************************/

/*****************************************************************************/
