/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpcmodels.h"
/*****************************************************************************/

/*****************************************************************************/
int test_optcritNr(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  unsigned int n;
  
  n=optcritNr();
  if(verbose>1) printf("optcritNr() := %u\n", n);
  if(n<=0) {return(1);}

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_optcritCode(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  unsigned int n;
  
  n=optcritNr();
  if(verbose>3) printf("optcritNr() := %u\n", n);
  if(n<=0) {return(1);}

  if(strcasecmp(optcritCode(OPTCRIT_UNKNOWN), "unknown")!=0) return(2);
  if(optcritCode(n)!=NULL) return(3);
  if(strcasecmp(optcritCode(OPTCRIT_OLS), "OLS")!=0) return(4);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_optcritDesc(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  unsigned int n;
  
  n=optcritNr();
  if(verbose>3) printf("optcritNr() := %u\n", n);
  if(n<=0) {return(1);}

  if(strcasecmp(optcritDesc(OPTCRIT_UNKNOWN), "Unknown optimality criterion")!=0) return(2);
  if(optcritCode(n)!=NULL) return(3);
  if(optcritCode(OPTCRIT_LAD)==NULL) return(4);
  if(strcasecmp(optcritDesc(OPTCRIT_LAD), "Least Absolute Deviations")!=0) return(5);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_optcritId(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  
  if(optcritId((char*)NULL)!=OPTCRIT_UNKNOWN) return(1);
  if(optcritId("")!=OPTCRIT_UNKNOWN) return(2);
  if(optcritId("ugh")!=OPTCRIT_UNKNOWN) return(3);
  if(optcritId("OLS")!=OPTCRIT_OLS) return(11);
  if(optcritId("sumsqr")!=OPTCRIT_OLS) return(12);
  if(optcritId("lms")!=OPTCRIT_LMS) return(13);
  if(optcritId("Lad")!=OPTCRIT_LAD) return(14);
  if(optcritId("MAD")!=OPTCRIT_MAD) return(15);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
