/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpcnlopt.h"
/*****************************************************************************/

/*****************************************************************************/
int test_nloptCheckParameters(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  unsigned int i, n, ret;
  double p[100], low[100], up[100], corp[100];
  double penalty;

  if(verbose>1) printf("\ncalling function with empty input\n");
  ret=nloptCheckParameters(0, NULL, NULL, NULL, NULL, NULL);
  if(ret!=0) return(1);
  if(verbose>2) printf("  -> error returned, which is good\n");
  n=0;
  ret=nloptCheckParameters(n, low, up, p, NULL, NULL);
  if(ret!=0) return(2);
  if(verbose>2) printf("  -> error returned, which is good\n");

  if(verbose>1) printf("\nfixed parameters\n");
  n=100; penalty=-1.0;
  for(i=0; i<n; i++) {
    p[i]=low[i]=up[i]=0.05;
    corp[i]=nan("");
  }
  ret=nloptCheckParameters(n, low, up, p, corp, &penalty);
  if(ret!=n) return(11);
  for(i=0; i<n; i++) {
    if(!doubleMatch(corp[i], low[i], 1.0E-20)) return(12);
  }
  if(!doubleMatch(penalty, 1.0, 1.0E-20)) return(13);

  if(verbose>1) printf("\nnormal limits\n");
  n=5;
  i=0; low[i]=0.0; up[i]=10.0;
  i=1; low[i]=0.0; up[i]=0.0;
  i=2; low[i]=10.0; up[i]=10.0;
  i=3; low[i]=-10.0; up[i]=0.0;
  i=4; low[i]=1.0E-06; up[i]=2.0E-06;

  if(verbose>1) printf("\nLower\n");
  for(i=0; i<n; i++) p[i]=low[i]-1.0E-03;
  ret=nloptCheckParameters(n, low, up, p, corp, &penalty);
  if(ret!=0) return(21);
  for(i=0; i<n; i++) {
    if(!doubleMatch(corp[i], low[i], 1.0E-20)) return(22);
  }
  if(penalty<1.01) return(23);

  if(verbose>1) printf("\nUpper\n");
  for(i=0; i<n; i++) p[i]=up[i]+1.0E-03;
  ret=nloptCheckParameters(n, low, up, p, corp, &penalty);
  if(ret!=0) return(31);
  for(i=0; i<n; i++) {
    if(!doubleMatch(corp[i], up[i], 1.0E-20)) return(32);
  }
  if(penalty<1.01) return(33);

  if(verbose>1) printf("\nInside\n");
  for(i=0; i<n; i++) p[i]=0.5*(low[i]+up[i]);
  ret=nloptCheckParameters(n, low, up, p, corp, &penalty);
  if(ret!=n) return(41);
  for(i=0; i<n; i++) {
    if(!doubleMatch(corp[i], p[i], 1.0E-20)) return(42);
  }
  if(!doubleMatch(penalty, 1.0, 1.0E-20)) return(43);

  if(verbose>2) printf("  -> ok\n");

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_nloptForceLimits(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  if(verbose>1) printf("\ncalling function with empty input\n");
  if(nloptForceLimits(0, NULL, NULL, NULL)!=0) return(1);

  unsigned int i, n;
  double p[10], low[10], up[10], corp[10];

  if(verbose>1) printf("\nfixed parameters\n");
  n=10;
  for(i=0; i<n; i++) {
    p[i]=low[i]=up[i]=0.05;
    corp[i]=0.05;
  }
  if(nloptForceLimits(n, low, up, p)!=n) return(10);
  for(i=0; i<n; i++) if(!doubleMatch(corp[i], p[i], 1.0E-20)) return(11);

  for(i=0; i<n; i++) p[i]=0.0;
  if(nloptForceLimits(n, low, up, p)!=0) return(12);
  for(i=0; i<n; i++) if(!doubleMatch(corp[i], p[i], 1.0E-20)) return(13);


  if(verbose>1) printf("\nnormal limits\n");
  n=5;
  i=0; low[i]=0.0; up[i]=10.0;
  i=1; low[i]=0.0; up[i]=20.0;
  i=2; low[i]=10.0; up[i]=100.0;
  i=3; low[i]=-10.0; up[i]=0.0;
  i=4; low[i]=1.0E-06; up[i]=2.0E-06;

  for(i=0; i<n; i++) corp[i]=p[i]=0.5*(low[i]+up[i]);
  if(nloptForceLimits(n, low, up, p)!=n) return(20);
  for(i=0; i<n; i++) if(!doubleMatch(corp[i], p[i], 1.0E-20)) return(21);

  p[0]=15.0;  corp[0]=10.0;
  p[1]=15.0;  corp[1]=15.0;
  p[2]=5.0;   corp[2]=10.0;
  p[3]=-50.0; corp[3]=-10.0;
  p[4]=1.0E-06; corp[4]=1.0E-06;

  if(nloptForceLimits(n, low, up, p)!=2) return(30);
  for(i=0; i<n; i++) if(!doubleMatch(corp[i], p[i], 1.0E-20)) return(31);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
