#ifndef _TEST_TPCNLOPT_H_
#define _TEST_TPCNLOPT_H_
/*****************************************************************************/

/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>
/*****************************************************************************/
#include "tpcnlopt.h"
/*****************************************************************************/

/*****************************************************************************/
/* nlopt */
extern int test_nloptInit(TPCSTATUS *status);
extern int test_nloptFree(TPCSTATUS *status);
extern int test_nloptAllocate(TPCSTATUS *status);
extern int test_nloptDuplicate(TPCSTATUS *status);
extern int test_nloptAddP(TPCSTATUS *status);
extern int test_nloptSortP(TPCSTATUS *status);
extern int test_nloptMeanP(TPCSTATUS *status);
extern int test_nloptLimitFixedNr(TPCSTATUS *status);
extern int test_nloptFixedNr(TPCSTATUS *status);
extern int test_nloptRemoveEmpties(TPCSTATUS *status);
/* Test functions */
extern double nloptDejong2(int n, double *x, void *func_data);
extern double nloptRastrigin(int n, double *x, void *func_data);
extern double nloptRastrigin1(int n, double *x, void *func_data);
extern double nloptX2(int n, double *x, void *func_data);
extern double nloptBiexp(int parNr, double *p, void *func_data);
/*****************************************************************************/

/*****************************************************************************/
/* constraints */
extern int test_nloptCheckParameters(TPCSTATUS *status);
extern int test_nloptForceLimits(TPCSTATUS *status);
/*****************************************************************************/

/*****************************************************************************/
/* rndpoint */
extern int test_nloptRandomPoint(TPCSTATUS *status);
extern int test_nloptGaussianPoint(TPCSTATUS *status);
/*****************************************************************************/

/*****************************************************************************/
/* nlopt1d */
extern int test_nlopt1D(TPCSTATUS *status);
/*****************************************************************************/

/*****************************************************************************/
/* simplex */
extern int test_nloptSimplex(TPCSTATUS *status);
extern int test_nloptSimplexARRS(TPCSTATUS *status);
/*****************************************************************************/

/*****************************************************************************/
/* praxis */
extern int test_nloptPowellBrent(TPCSTATUS *status);
/*****************************************************************************/

/*****************************************************************************/
/* mpso */
extern int test_nloptMPSO(TPCSTATUS *status);
/*****************************************************************************/

/*****************************************************************************/
/* tgo */
extern int test_nloptITGO1(TPCSTATUS *status);
extern int test_nloptITGO2(TPCSTATUS *status);
extern int test_nloptIATGO(TPCSTATUS *status);
/*****************************************************************************/

/*****************************************************************************/
#endif /* TEST_TPCNLOPT */
