/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpcpar.h"
/*****************************************************************************/

/*****************************************************************************/
int test_parWriteCSV(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  if(verbose>1) printf("tested in test_parWrite() and test_parReadCSV\n");

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_parReadCSV(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  if(verbose>1) printf("mostly tested in test_parRead()\n");

  char fname[128];
  PAR par1, par2;
  parInit(&par1); parInit(&par2);
  int ret, pi, ri;
  FILE *fp;

  if(verbose>1) printf("make test data with different models.\n");
  /* Allocate memory */
  ret=parAllocate(&par1, 3, 3); if(ret!=TPCERROR_OK) return 1;
  par1.tacNr=3; par1.parNr=3;
  par1.format=PAR_FORMAT_CSV_UK;
  /* Set parameter names */
  for(pi=0; pi<par1.parNr; pi++) sprintf(par1.n[pi].name, "pa%d", 1+pi);
  /* Set region names */
  for(ri=0; ri<par1.tacNr; ri++) sprintf(par1.r[ri].name, "roi%d", 1+ri);
  /* Set parameter values */
  for(pi=0; pi<par1.parNr; pi++) for(ri=0; ri<par1.tacNr; ri++)
    par1.r[ri].p[pi]=(double)(pi+5*ri);
  /* Set models */
  par1.r[0].model=modelCodeIndex("SRTM");
  par1.r[1].model=modelCodeIndex("RRTM");
  par1.r[2].model=modelCodeIndex("TRTM");

  strcpy(fname, "parcsv1.csv");
  if(verbose>1) printf("open file %s for writing.\n", fname);
  fp=fopen(fname, "w");
  if(fp==NULL) {parFree(&par1); parFree(&par2); return 11;}
  ret=parWrite(&par1, fp, PAR_FORMAT_UNKNOWN, 1, status);
  fclose(fp);
  if(ret!=TPCERROR_OK) {parFree(&par1); parFree(&par2); return 12;}

  if(verbose>1) printf("trying to read file %s\n", fname);
  ret=parRead(&par2, fname, status);
  if(ret!=TPCERROR_OK) {parFree(&par1); parFree(&par2); return 13;}
  if(verbose>1) printf("verify PAR contents\n");
  ret=0;
  if(parCompareParameterNames(&par1, &par2, -1, 1, status)) ret+=1;
  if(parCompareTacNames(&par1, &par2, -1, 1, status)) ret+=2;
  if(parCompareParameters(&par1, &par2, -1, -1, 1, 0, 0, 1.0E-08, 1.0E-06, status))
    ret+=4;
  for(ri=0; ri<par1.tacNr; ri++) if(par1.r[ri].model!=par2.r[ri].model) {
    ret+=8; break;}
  if(ret!=0) {parFree(&par1); parFree(&par2); return(20+ret);}

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  parFree(&par1); parFree(&par2);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
