/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpcpar.h"
/*****************************************************************************/

/*****************************************************************************/
int test_parExampleTTACs(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  int n, ret;
  FILE *fp;
  
  if(verbose>1) printf("should not crash with NULL input\n");
  n=parExampleTTACs(NULL, 0, status);
  if(n==0) {return 1;}
  
  PAR par; parInit(&par);

  if(verbose>1) printf("create test data\n");
  ret=parExampleTTACs(&par, 0, status); if(ret!=0) {parFree(&par); return(11);}

  char fname[128];
  strcpy(fname, "test1313.csv");
  if(verbose>1) printf("open file %s for writing.\n", fname);
  fp=fopen(fname, "w");
  if(fp==NULL) {parFree(&par); return(12);}
  if(verbose>1)
    printf("trying to write in %s format\n", parFormattxt(par.format));
  ret=parWrite(&par, fp, PAR_FORMAT_UNKNOWN, 1, status);
  fclose(fp);
  if(ret!=TPCERROR_OK) {parFree(&par); return(13);}

  par.format=PAR_FORMAT_FIT;
  strcpy(fname, "test1313.fit");
  if(verbose>1) printf("open file %s for writing.\n", fname);
  fp=fopen(fname, "w");
  if(fp==NULL) {parFree(&par); return(14);}
  if(verbose>1)
    printf("trying to write in %s format\n", parFormattxt(par.format));
  ret=parWrite(&par, fp, PAR_FORMAT_UNKNOWN, 1, status);
  fclose(fp);
  if(ret!=TPCERROR_OK) {parFree(&par); return(15);}

  
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  parFree(&par);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_parExamplePerfectBolus(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  int n, ret;
  FILE *fp;
  
  if(verbose>1) printf("should not crash with NULL input\n");
  n=parExamplePerfectBolus(NULL, status);
  if(n==0) {return 1;}
  
  PAR par; parInit(&par);

  if(verbose>1) printf("create test data\n");
  ret=parExamplePerfectBolus(&par, status); 
  if(ret!=0) {parFree(&par); return(11);}

  char fname[128];
  strcpy(fname, "test1401.csv");
  if(verbose>1) printf("open file %s for writing.\n", fname);
  fp=fopen(fname, "w");
  if(fp==NULL) {parFree(&par); return(12);}
  if(verbose>1)
    printf("trying to write in %s format\n", parFormattxt(par.format));
  ret=parWrite(&par, fp, PAR_FORMAT_UNKNOWN, 1, status);
  fclose(fp);
  if(ret!=TPCERROR_OK) {parFree(&par); return(13);}

  par.format=PAR_FORMAT_FIT;
  strcpy(fname, "test1401.fit");
  if(verbose>1) printf("open file %s for writing.\n", fname);
  fp=fopen(fname, "w");
  if(fp==NULL) {parFree(&par); return(14);}
  if(verbose>1)
    printf("trying to write in %s format\n", parFormattxt(par.format));
  ret=parWrite(&par, fp, PAR_FORMAT_UNKNOWN, 1, status);
  fclose(fp);
  if(ret!=TPCERROR_OK) {parFree(&par); return(15);}

  
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  parFree(&par);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
