/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpcpar.h"
/*****************************************************************************/

/*****************************************************************************/
int test_parSortByName(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  int n, ret;
  
  if(verbose>1) printf("should not crash with NULL input\n");
  n=parSortByName(NULL, status);
  if(n==0) {return 1;}
  
  PAR par; parInit(&par);

  if(verbose>1) printf("should not crash with empty PAR struct\n");
  n=parSortByName(&par, status);
  if(n!=0) {parFree(&par); return 2;}
  
  if(verbose>1) printf("create test data\n");
  ret=create_par(&par); if(ret!=0) {parFree(&par); return 5;}

  if(verbose>1) printf("sort test data (already sorted)\n");
  if(verbose>2) {
    printf("'%s'", par.r[0].name);
    for(int i=1; i<par.tacNr; i++) printf(", '%s'", par.r[i].name);
    printf("\n");
  }
  n=parSortByName(&par, status);
  if(n!=0) {parFree(&par); return 11;}
  if(verbose>2) {
    printf("-> '%s'", par.r[0].name);
    for(int i=1; i<par.tacNr; i++) printf(", '%s'", par.r[i].name);
    printf("\n");
  }
  if(strcmp(par.r[0].name, "roi1") || strcmp(par.r[2].name, "roi3"))
    {parFree(&par); return 12;}

  if(verbose>1) printf("sort test data (in wrong order)\n");
  strcpy(par.r[0].name, "roi2");
  strcpy(par.r[1].name, "roi3");
  strcpy(par.r[2].name, "roi1");
  if(verbose>2) {
    printf("'%s'", par.r[0].name);
    for(int i=1; i<par.tacNr; i++) printf(", '%s'", par.r[i].name);
    printf("\n");
  }
  n=parSortByName(&par, status);
  if(n!=0) {parFree(&par); return 21;}
  if(verbose>2) {
    printf("-> '%s'", par.r[0].name);
    for(int i=1; i<par.tacNr; i++) printf(", '%s'", par.r[i].name);
    printf("\n");
  }
  if(strcmp(par.r[0].name, "roi1") || strcmp(par.r[2].name, "roi3"))
    {parFree(&par); return 22;}
  
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  parFree(&par);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
