/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "tpcstatist.h"
#include "test_tpcrand.h"
/*****************************************************************************/

/*****************************************************************************/
int test_mertwiSeed32(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  uint32_t u;
  for(int i=0; i<10; i++) {
    u=mertwiSeed32();
    if(verbose>1) printf("seed: %20u\n", u);
  }

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_mertwiSeed64(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  uint64_t u;
  for(int i=0; i<10; i++) {
    u=mertwiSeed64(); 
    if(verbose>1) printf("seed: %20llu\n", (long long unsigned)u);
  }

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_mertwiRandomInt64(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  MERTWI mt; mertwiInit(&mt);

  /* set fixed seed to allways get the same random numbers for testing */
  uint64_t init[4]={UINT64_C(0x12345), UINT64_C(0x23456), 
                    UINT64_C(0x34567), UINT64_C(0x45678)};
  uint64_t length=4;
  int      i;
  uint64_t v[1000];

  mertwiInitByArray64(&mt, init, length);
  for(i=0; i<1000; i++) v[i]=mertwiRandomInt64(&mt);
  if(verbose>10) {
    printf("\n1000 outputs of mertwiRandomInt64()\n");
    for(i=0; i<1000; i++) {printf("%20llu ", (long long unsigned)v[i]); 
    if(i%5==4) printf("\n");}
    printf("\n");
  }
  if(v[0] != UINT64_C(7266447313870364031)) return(2);
  if(v[999] != UINT64_C(994412663058993407)) return(3);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_mertwiRandomDouble1(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  MERTWI mt; mertwiInit(&mt);

  /* set fixed seed to allways get the same random numbers for testing */
  uint64_t init[4]={UINT64_C(0x12345), UINT64_C(0x23456), 
                    UINT64_C(0x34567), UINT64_C(0x45678)};
  uint64_t length=4;
  int      i;
  double   v[1000], mean, meansd;

  mertwiInitByArray64(&mt, init, length);
  for(i=0; i<1000; i++) v[i]=mertwiRandomDouble1(&mt);
  if(verbose>10) {
    printf("\n1000 outputs of mertwiRandomDouble1()\n");
    for(i=0; i<1000; i++) {printf("%10.8f ", v[i]); if(i%5==4) printf("\n");}
    printf("\n");
  }
  if(!doubleMatch(v[0], 0.39391490, 0.0000001)) return(2);
  if(!doubleMatch(v[999], 0.05390722, 0.0000001)) return(3);
  /* Calculate the mean and SD of the created random numbers */
  statMeanSD(v, 1000, &mean, &meansd, NULL);
  if(verbose>0) printf("  simulated mean=%g and sd=%g\n", mean, meansd);
  if(!doubleMatch(0.50, mean, 0.01)) return 4;
  /* SD should be close to the correct value, sd=(up-low)/sqrt(12),
     now that we have uniform distribution. */
  if(!doubleMatch(0.28867513, meansd, 0.01)) return 5;

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_mertwiRandomDouble2(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  MERTWI mt; mertwiInit(&mt);

  /* set fixed seed to allways get the same random numbers for testing */
  uint64_t init[4]={UINT64_C(0x12345), UINT64_C(0x23456), 
                    UINT64_C(0x34567), UINT64_C(0x45678)};
  uint64_t length=4;
  int      i;
  double   v[1000], mean, meansd;

  mertwiInitByArray64(&mt, init, length);
  for(i=0; i<1000; i++) v[i]=mertwiRandomDouble2(&mt);
  if(verbose>10) {
    printf("\n1000 outputs of mertwiRandomDouble2()\n");
    for(i=0; i<1000; i++) {printf("%10.8f ", v[i]); if(i%5==4) printf("\n");}
    printf("\n");
  }
  if(!doubleMatch(v[0], 0.39391490, 0.0000001)) return(2);
  if(!doubleMatch(v[999], 0.05390722, 0.0000001)) return(3);
  /* Calculate the mean and SD of the created random numbers */
  statMeanSD(v, 1000, &mean, &meansd, NULL);
  if(verbose>0) printf("  simulated mean=%g and sd=%g\n", mean, meansd);
  if(!doubleMatch(0.50, mean, 0.01)) return 4;
  /* SD should be close to the correct value, sd=(up-low)/sqrt(12),
     now that we have uniform distribution. */
  if(!doubleMatch(0.28867513, meansd, 0.01)) return 5;

//printf("uint64_t %llu\n", (long long unsigned)sizeof(uint64_t));
//printf("unsigned int %llu\n", (long long unsigned)sizeof(unsigned int));
//printf("time_t %llu\n", (long long unsigned)sizeof(time_t));

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_mertwiRandomBetween(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  /* Make a set of random numbers with even distribution, check that all are 
     between specified limits and that mean is in the middle */
  /* Check also that sd is close to the correct value, sd=(up-low)/sqrt(12),
     now that we have uniform distribution.
     CV would be cv=(up-low)/(sqrt(3)*(low+up)) that we don't need to test here.
  */
  int ret=0;
  unsigned int i, n=2000;
  double r[n], low, up, mean, sd, truemean, truesd;

  MERTWI mt; mertwiInit(&mt); mertwiInitWithSeed64(&mt, mertwiSeed64());

  low=200.0; up=400.0;
  truemean=0.5*(low+up); truesd=(up-low)/sqrt(12.0);
  if(verbose>1) printf("[%g,%g] (%g+-%g):\n", low, up, truemean, truesd);
  ret=mertwiRandomBetween(&mt, n, r, low, up, 0);
  if(ret!=0) return(2);
  for(i=0; i<n; i++) if(r[i]<low || r[i]>up) return(3);
  /* Calculate the mean and SD of the created random numbers */
  statMeanSD(r, n, &mean, &sd, NULL);
  if(verbose>1) printf("mertwiRandomBetween() mean=%g sd=%g\n", mean, sd);
  if(!doubleMatch(truemean, mean, 0.10*truemean)) return(4);
  if(!doubleMatch(truesd, sd, 0.10*truesd)) return(5);
  

  low=-0.9; up=0.1;
  truemean=0.5*(low+up); truesd=(up-low)/sqrt(12.0);
  if(verbose>1) printf("[%g,%g] (%g+-%g):\n", low, up, truemean, truesd);
  ret=mertwiRandomBetween(&mt, n, r, low, up, 0);
  if(ret!=0) return(12);
  for(i=0; i<n; i++) if(r[i]<low || r[i]>up) return(13);
  /* Calculate the mean and SD of the created random numbers */
  statMeanSD(r, n, &mean, &sd, NULL);
  if(verbose>1) printf("mertwiRandomBetween() mean=%g sd=%g\n", mean, sd);
  if(!doubleMatch(truemean, mean, fabs(0.10*truemean))) return(14);
  if(!doubleMatch(truesd, sd, 0.10*truesd)) return(15);


  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_mertwiRandomExponential(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  MERTWI mt; mertwiInit(&mt); mertwiInitWithSeed64(&mt, mertwiSeed64());
  int n=1500;
  double r[n], mean=1.0, meansd;


  /* Make a set of random numbers */
  if(verbose>1) printf("  true mean=%g\n", mean);
  for(int i=0; i<n; i++) r[i]=mertwiRandomExponential(&mt, mean);
  /* Calculate the mean and SD of the created random numbers */
  statMeanSD(r, n, &mean, &meansd, NULL);
  if(verbose>1) printf("  simulated mean=%g and sd=%g\n", mean, meansd);
  if(!doubleMatch(1.0, mean, 0.10)) return(2);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_mertwiRandomGaussian(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  MERTWI mt; mertwiInit(&mt); mertwiInitWithSeed64(&mt, mertwiSeed64());
  int n=1500;
  double r[n], mean, meansd;

  /* Make a set of random numbers */
  if(verbose>1) printf("  true mean=%g and sd=%g\n", 0.0, 1.0);
  for(int i=0; i<n; i++) r[i]=mertwiRandomGaussian(&mt);
  /* Calculate the mean and SD of the created random numbers */
  statMeanSD(r, n, &mean, &meansd, NULL);
  if(verbose>1) printf("  simulated mean=%g and sd=%g\n", mean, meansd);
  if(!doubleMatch(0.0, mean, 0.10)) return(2);
  if(!doubleMatch(1.0, meansd, 0.10)) return(3);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
