/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "tpcstatist.h"
#include "test_tpcrand.h"
/*****************************************************************************/

/*****************************************************************************/
int test_randomShuffle(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  /* Create list with values [1001..2000] */
  unsigned int i, n=1000;
  int data[n];
  for(i=0; i<n; i++) data[i]=1001+(int)i;
  
  /* Suffle the list */
  MERTWI mt; mertwiInit(&mt); mertwiInitWithSeed64(&mt, mertwiSeed64());
  randomShuffle(data, n, &mt);
  if(data[0]==1001 && data[n-1]==2000) return(2);
  
  /* Sort the list back to check that contents are like before suffling */
  statSortInt(data, n, 0);
  for(i=0; i<n; i++) if(data[i]!=1001+(int)i) return(3);

  if(verbose>1) printf("ok\n");
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_randomShuffleUnsigned(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }


  /* Create list with values [0..999] */
  unsigned int i, n=1000;
  unsigned int data[n];
  for(i=0; i<n; i++) data[i]=(unsigned int)i;
  
  /* Suffle the list */
  MERTWI mt; mertwiInit(&mt); mertwiInitWithSeed64(&mt, mertwiSeed64());
  randomShuffleUnsigned(data, n, &mt);
  if(data[0]==0 && data[n-1]==999) return(2);
  
  /* Sort the list back to check that contents are like before suffling */
  statSortUnsigned(data, n, 0);
  for(i=0; i<n; i++) if(data[i]!=(unsigned int)i) return(3);

  if(verbose>1) printf("ok\n");
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_randomPermutation(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  unsigned int i, n=100;
  int data[n], a=-50;
  
  MERTWI mt; mertwiInit(&mt); mertwiInitWithSeed64(&mt, mertwiSeed64());
  randomPermutation(data, n, a, &mt);
  if(data[0]==a && data[n-1]==(int)n+a-1) return(2);
  statSortInt(data, n, 0);
  for(i=0; i<n; i++) if(data[i]!=a+(int)i) return(3);
  if(verbose>1) printf("ok\n");

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_randomPermutationUnsigned(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  unsigned int i, n=100;
  unsigned int data[n], a=50;
  
  MERTWI mt; mertwiInit(&mt); mertwiInitWithSeed64(&mt, mertwiSeed64());
  randomPermutationUnsigned(data, n, a, &mt);
  if(data[0]==a && data[n-1]==n+a-1) return(2);
  statSortUnsigned(data, n, 0);
  for(i=0; i<n; i++) if(data[i]!=a+i) return(3);
  if(verbose>1) printf("ok\n");

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
